/*
 * @author		Alfonso Muñoz-Pomer Fuentes, 
 * 				<a href="mailto:alfonso.munozpomer@biotechvana.com">
 * 				alfonso.munozpomer@biotechvana.com</a>,  
 * 				<a href="http://www.biotechvana.com">Biotechvana</a>
 *
 * @date		2011-04-11
 * 
 * @copyright	Copyright Biotech Vana, S.L. 2006-2011
 */

package com.biotechvana.javabiotoolkit;

/**
 * Interface for classes that represent a reversible two-way directionality for biological sequences. 
 * 
 * @version	1.5, 2011-07-19
 *
 * @author	<a href="mailto:alfonso.munozpomer@biotechvana.com">Alfonso Muñoz-Pomer Fuentes</a>,
 *			<a href="http://www.biotechvana.com">Biotechvana</a>.
 *
 * @see		NucleotideSequenceDirectionality
 * @see		PeptideSequenceDirectionality
 *
 * <style type="text/css">
 * 		table.t0 {
 * 			border:0px solid black;
 * 			border-collapse: collapse;
 * 		}
 * 		table.t0 td {
 * 			text-align: center;
 * 			padding: 4px;
 * 		}
 * 		tr.d0 td {
 * 			background-color: #FFFFFF; color: black;
 * 		}
 * 		tr.d1 td {
 * 			background-color: #DDDDDD; color: black;
 * 		}
 * </style>
 */
public interface BioSequenceDirectionality
{
	/**
	 * Returns a <code>String</code> with a text description of this direction.
	 * 
	 * @return	<code>String</code> with a text description of this direction.
	 *
	 * @since	1.0
	 */
	public String getFullName();
	
	/**
	 * Returns the opposite direction of this one.
	 * 
	 * @return	the opposite direction of this one.
	 *
	 * @since	1.0
	 */
	public BioSequenceDirectionality reverse();
	
	/*
	 * (non-Javadoc) @see java.lang.Object#toString()
	 */
	@Override
	public String toString();
}
