/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.users;

import com.biotechvana.commons.model.ServiceStatus;
import com.biotechvana.commons.model.UserLoginInfo;
import com.biotechvana.commons.model.UserNotifyListener;
import com.biotechvana.users.InvalidLoginInfoException;
import com.biotechvana.utils.Constants;
import com.biotechvana.utils.IPrefs;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class UserManager
implements IPrefs {
    static final Logger LOGGER = Logger.getLogger("global");
    protected UserLoginInfo activeLogin = null;
    boolean isChrootedInitilezed = false;
    protected boolean ischRooted = true;
    LocalPathManager localPathManager = new LocalPathManager();
    RemotePathManager hostPathManager = new RemotePathManager();
    ArrayList<UserNotifyListener> userNotifyListeners = new ArrayList();

    public UserLoginInfo getUserLoginInfo() throws InvalidLoginInfoException {
        if (this.activeLogin == null) {
            throw new InvalidLoginInfoException();
        }
        return this.activeLogin;
    }

    public boolean setLogin(UserLoginInfo newLogin) throws InvalidLoginInfoException, IOException {
        if (newLogin == null) {
            this.notifyChangingListener();
            this.activeLogin = null;
            throw new InvalidLoginInfoException("New Login info can not be empty");
        }
        if (this.activeLogin != null && this.activeLogin.equals(newLogin)) {
            return true;
        }
        String userName = newLogin.getUserName();
        String host = newLogin.getHostInfo().getServerURL();
        int sshPort = newLogin.getHostInfo().getSshPort();
        int ftpPort = newLogin.getHostInfo().getFtpPort();
        int httpPort = newLogin.getHostInfo().getHttpPort();
        String password = newLogin.getPassword();
        String scheme = newLogin.getHostInfo().getScheme();
        if (this.testConnection(newLogin)) {
            this.notifyChangingListener();
            this.put("ssh_host", host);
            this.put("ssh_port", Integer.toString(sshPort));
            this.put("http_port", Integer.toString(httpPort));
            this.put("ftp_port", Integer.toString(ftpPort));
            this.put("ftp_scheme", scheme);
            this.put("ssh_user", userName);
            this.put("ssh_password", password);
            this.put("email", newLogin.getEmailAddress());
            this.activeLogin = newLogin;
            this.userConnectionRefresh();
            this.notifyChangedListener();
            return true;
        }
        return false;
    }

    protected void userConnectionRefresh() throws IOException {
        this.echoStatus();
        if (this.activeLogin != null) {
            this.chechIfRooted();
            this.initAppPaths();
            this.postLoginHandle();
        }
    }

    protected abstract void postLoginHandle() throws IOException;

    private void echoStatus() {
        String host = "";
        String user = "";
        if (this.activeLogin != null) {
            host = this.activeLogin.getHostInfo().getServerName();
            user = this.activeLogin.getUserName();
        }
        LOGGER.log(Level.INFO, String.format("Current user is [%1$s] at %2$s", user, host));
    }

    public boolean getIsChRooted() {
        if (!this.isChrootedInitilezed) {
            this.chechIfRooted();
            this.isChrootedInitilezed = true;
        }
        return this.ischRooted;
    }

    protected abstract void chechIfRooted();

    public void addUserNotiferList(UserNotifyListener listener) {
        listener.setUserManager(this);
        this.userNotifyListeners.add(listener);
    }

    public void removeUserNotiferList(UserNotifyListener listener) {
        this.userNotifyListeners.remove(listener);
    }

    protected void notifyChangedListener() {
        this.localPathManager.init();
        this.hostPathManager.init();
        Thread backgroundThread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (UserNotifyListener listener : UserManager.this.userNotifyListeners) {
                    try {
                        listener.userChanged();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "notifyChangedListener : can not notify listener Object may be unavalaibe .");
                    }
                }
            }
        });
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    protected void notifyChangingListener() {
        for (UserNotifyListener listener : this.userNotifyListeners) {
            try {
                listener.userChanging();
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "notifyChangingListener : can not notify listener Object may be unavalaibe .");
            }
        }
    }

    private String getUserHomePath() {
        String userHomePath = "";
        Object host = this.activeLogin.getHostInfo().getServerURL();
        String userName = this.activeLogin.getUserName();
        int httpPort = this.activeLogin.getHostInfo().getHttpPort();
        if (httpPort != 80) {
            host = (String)host + ":" + httpPort;
        }
        try {
            URL url = new URL("http://" + (String)host + "/gpro/gpro/getUserHomePath.php?username=" + userName);
            try {
                String linea;
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(15000);
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((linea = in.readLine()) != null) {
                    if (linea.trim().isEmpty()) continue;
                    userHomePath = linea;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return userHomePath;
    }

    public String getModuleId() {
        return Constants.MODULE_ID.replace(" ", "");
    }

    public LocalPathManager getLocalPathManager() {
        return this.localPathManager;
    }

    public RemotePathManager getHostPathManager() {
        return this.hostPathManager;
    }

    private void initAppPaths() {
        String binPath = UserManager.getBinPath(this);
        Constants.PIPELINE_AUGUSTUS_CONFIG = binPath + "/augustus_config";
        Constants.PIPELINE_AUGUSTUS_EXE = binPath + "augustus";
        Constants.PIPELINE_AUGUSTUS_SCRIPT = binPath + "augustusBatch.jar";
        Constants.PIPELINE_AUGUSTUS_SCRIPT_PATH = binPath + "augustus_scripts";
        Constants.PIPELINE_BAMTOOLS_EXE = "bamtools";
        Constants.PIPELINE_BESST_EXE = "runBESST";
        Constants.PIPELINE_BLASR_EXE = binPath + "blasr";
        Constants.PIPELINE_BLASTALL_EXE = binPath + "blastall";
        Constants.PIPELINE_BLAST_DB_PATH = binPath + "database/blast";
        Constants.PIPELINE_BLASTXML_EXE = binPath + "blastxml.php";
        Constants.PIPELINE_BOWTIE2_EXE = binPath + "bowtie2";
        Constants.PIPELINE_BWA_EXE = binPath + "bwa";
        Constants.PIPELINE_CANU_EXE = binPath + "canu";
        Constants.PIPELINE_CUTADAPT_PATH = binPath + "cutadapt";
        Constants.PIPELINE_EXTRACT_FASTACMD_EXE = "php " + binPath + "ExtractFastacmd.php";
        Constants.PIPELINE_EXTRACT_SEQUENCES_FASTA_DATABASE_EXE = "php " + binPath + "ExtractSequences.php";
        Constants.PIPELINE_FASTQ_COLLAPSER = "java -jar " + binPath + "FastqCollapser.jar";
        Constants.PIPELINE_FASTQC_PATH = binPath + "fastqc";
        Constants.PIPELINE_FASTQ_CSV_TRIMMER = "java -jar " + binPath + "FastqCsvTrimmer.jar";
        Constants.PIPELINE_FASTQ_INTERSECT = "java -Xmx10000m -jar " + binPath + "FastqIntersect.jar";
        Constants.PIPELINE_FASTQ_MID_CLEANER = "java -jar " + binPath + "FastqMidCleaner.jar";
        Constants.PIPELINE_FASXTOOLKIT_FASTA_CLIPPING_HISTOGRAM_EXE = "perl " + binPath + "fasta_clipping_histogram.pl";
        Constants.PIPELINE_FASXTOOLKIT_FASTA_FORMATTER_EXE = binPath + "fasta_formatter";
        Constants.PIPELINE_FASXTOOLKIT_FASTA_NUCLEOTIDES_CHANGER_EXE = binPath + "fasta_nucleotide_changer";
        Constants.PIPELINE_FASXTOOLKIT_FASTQ_QUALITY_CHART_EXE = binPath + "fastq_quality_boxplot_graph.sh";
        Constants.PIPELINE_FASXTOOLKIT_FASTQ_QUALITY_FILTER_EXE = binPath + "fastq_quality_filter";
        Constants.PIPELINE_FASXTOOLKIT_FASTQ_TO_FASTA_EXE = binPath + "fastq_to_fasta";
        Constants.PIPELINE_FASXTOOLKIT_FASTX_ARTIFACTS_FILTER_EXE = binPath + "fastx_artifacts_filter";
        Constants.PIPELINE_FASXTOOLKIT_FASTX_BARCODE_SPLITTER_EXE = "perl " + binPath + "fastx_barcode_splitter.pl";
        Constants.PIPELINE_FASXTOOLKIT_FASTX_CLIPPER_EXE = binPath + "fastx_clipper";
        Constants.PIPELINE_FASXTOOLKIT_FASTX_COLLAPSER_EXE = binPath + "fastx_collapser";
        Constants.PIPELINE_FASXTOOLKIT_FASTX_NUCLEOTIDE_DISTRIBUTION_EXE = binPath + "fastx_nucleotide_distribution_graph.sh";
        Constants.PIPELINE_FASXTOOLKIT_FASTX_RENAMER_EXE = binPath + "fastx_renamer";
        Constants.PIPELINE_FASXTOOLKIT_FASTX_REVERSE_COMPLEMENT_EXE = binPath + "fastx_reverse_complement";
        Constants.PIPELINE_FASXTOOLKIT_FASTX_STATISTICS_EXE = binPath + "fastx_quality_stats";
        Constants.PIPELINE_FASXTOOLKIT_FASTX_TRIMMER_EXE = binPath + "fastx_trimmer";
        Constants.PIPELINE_FILTER_REDUNDANT_CSV_EXE = "java -jar " + binPath + "removeRedundantCsv.jar";
        Constants.PIPELINE_FORMAT_CSV_EXE = "php " + binPath + "process_multi_hsp_csv.php";
        Constants.PIPELINE_FORMATDB_EXE = binPath + "formatdb";
        Constants.PIPELINE_GAPCLOSER_EXE = binPath + "GapCloser";
        Constants.PIPELINE_GMAP = binPath + "gmap";
        Constants.PIPELINE_HMM_CREATE_PROFILE_SCRIPT = binPath + "pipelineHmm.php";
        Constants.PIPELINE_HMM_DB_PATH = binPath + "database/hmm";
        Constants.PIPELINE_HMMEMIT_EXE = binPath + "hmemit";
        Constants.PIPELINE_HMMPARSE_SCRIPT = binPath + "HMM3Parser.jar";
        Constants.PIPELINE_HMMPFAM_BATCH_SCRIPT = binPath + "hmmPfamBatch.php";
        Constants.PIPELINE_HMMPFAM_EXE = binPath + "hmmpfam";
        Constants.PIPELINE_HMMSCAN_BATCH_SCRIPT = binPath + "HMMScanBatch.jar";
        Constants.PIPELINE_HMMSCAN_EXE = binPath + "hmmscan";
        Constants.PIPELINE_HMMSEARCH_BATCH_SCRIPT = binPath + "HMMSearchBatch.jar";
        Constants.PIPELINE_HMMSEARCH_EXE = binPath + "hmmsearch";
        Constants.PIPELINE_INTERPRO_EXE = binPath + "iprscan/bin/iprscan";
        Constants.PIPELINE_INTERPRO_PARSE_EXE = binPath + "InterproParser.jar";
        Constants.PIPELINE_INTERPRO_SCRIPT = binPath + "InterProLauncher.jar";
        Constants.PIPELINE_MERGE_CSV_EXE = "php " + binPath + "merge_csv.php";
        Constants.PIPELINE_OASES_PATH = binPath + "oases";
        Constants.PIPELINE_OASES_PIPELINE_PATH = binPath + "oases_pipeline.py";
        Constants.PIPELINE_OPERALG_BIN_EXE = binPath + "OPERA-LG";
        Constants.PIPELINE_OPERALG_BIN_FOLDER = binPath + "opera_bin";
        Constants.PIPELINE_OPERALG_EXE = "perl " + binPath + "OPERA-long-read.pl";
        Constants.PIPELINE_PARSE_BLAST_XML_EXE = "php " + binPath + "ParseBlastXml.php";
        Constants.PIPELINE_PICARD_EXE = "java -Xmx4g -jar " + binPath + "picard.jar";
        Constants.PIPELINE_PLATANUS_INTERNAL_TRIM = binPath + "platanus_internal_trim";
        Constants.PIPELINE_PREPROCESSING_CSFASQ_TO_CSFASTQ_EXE = binPath + "solid2fastq";
        Constants.PIPELINE_PREPROCESSING_CSFASQ_TO_FASTQ_EXE = binPath + "csFastq2fastq.sh";
        Constants.PIPELINE_PREPROCESSING_CSFASTA_TO_FASTQ_EXE = binPath + "csFasta_qual2fastq.sh";
        Constants.PIPELINE_PREPROCESSING_FASTAQUAL_TO_FASTQ_EXE = binPath + "fastaQual2fastq.pl";
        Constants.PIPELINE_PRINSEQ_PATH = "perl " + binPath + "prinseq-lite.pl";
        Constants.PIPELINE_REMOVE_REDUNDANT_SCRIPT = binPath + "removeRedundantCsv.jar";
        Constants.PIPELINE_REVERSE_FRAME_EXE = "php " + binPath + "reverse_sequences_with_frame.php";
        Constants.PIPELINE_SOAP_127_EXE = binPath + "SOAPdenovo-127mer";
        Constants.PIPELINE_SOAP_63_EXE = binPath + "SOAPdenovo-63mer";
        Constants.PIPELINE_SOAP_TRANS_127_EXE = " " + binPath + "SOAPdenovo-Trans-127mer";
        Constants.PIPELINE_SOAP_TRANS_31_EXE = " " + binPath + "SOAPdenovo-Trans-31mer";
        Constants.PIPELINE_SPADES_EXE = "python " + binPath + "spades.py";
        Constants.PIPELINE_TRIMMOMATIC = "java -jar " + binPath + "trimmomatic.jar";
        Constants.PIPELINE_VELVETG_PATH = binPath + "velvetg";
        Constants.PIPELINE_VELVETH_PATH = binPath + "velveth";
    }

    public boolean testConnection(UserLoginInfo userLogin) {
        if (userLogin != null) {
            List<ServiceStatus> services = this.getCheckStatus(userLogin);
            return this.checkServices(services);
        }
        return false;
    }

    public abstract List<ServiceStatus> getCheckStatus(UserLoginInfo var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkServices(List<ServiceStatus> services) {
        try {
            ServiceStatus ss;
            boolean status;
            Iterator<ServiceStatus> iterator = services.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (status = (ss = iterator.next()).runCheck());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    public boolean testConnection() {
        if (this.activeLogin != null) {
            this.testConnection(this.activeLogin);
        }
        return false;
    }

    public boolean isLogin() {
        return this.activeLogin != null;
    }

    public String getBinPath() {
        return UserManager.getBinPath(this);
    }

    public static String getBinPath(UserManager userManager) {
        String downloaded_bin_path = userManager.get("SERVER_BIN_PATH", Constants.PIPELINE_BASE_PATH);
        if (downloaded_bin_path != null && !downloaded_bin_path.isEmpty()) {
            return downloaded_bin_path;
        }
        return Constants.PIPELINE_BASE_PATH;
    }

    public static void fetchDatabaseSettings(UserManager preferences, String host, String user, String hash) throws IOException {
        URL url = new URL("http://" + host + "/gpro/db_settings/db_connection.php?user=" + user + "&pass=" + hash.toLowerCase());
        URLConnection urlConn = url.openConnection();
        urlConn.setConnectTimeout(30000);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));){
            String line;
            preferences.put("PBS", "NO");
            preferences.put("ssh_home_prefix", "home");
            while ((line = in.readLine()) != null) {
                if (line.isEmpty()) continue;
                String[] parts = line.split(":");
                System.out.println("line: " + line);
                if (parts[0].equals("DB_HOST")) {
                    preferences.put("DB_HOST", parts[1]);
                    continue;
                }
                if (parts[0].equals("DB_USER")) {
                    preferences.put("DB_USER", parts[1]);
                    continue;
                }
                if (parts[0].equals("DB_PASS")) {
                    preferences.put("DB_PASS", parts[1]);
                    continue;
                }
                if (parts[0].equals("DB_PIPELINE")) {
                    preferences.put("DB_PIPELINE", parts[1]);
                    continue;
                }
                if (parts[0].equals("DB_TAXONOMY")) {
                    preferences.put("DB_TAXONOMY", parts[1]);
                    continue;
                }
                if (parts[0].equals("DB_COG")) {
                    preferences.put("DB_COG", parts[1]);
                    continue;
                }
                if (parts[0].equals("DB_KOG")) {
                    preferences.put("DB_KOG", parts[1]);
                    continue;
                }
                if (parts[0].equals("DB_ORTHOMCL")) {
                    preferences.put("DB_ORTHOMCL", parts[1]);
                    continue;
                }
                if (parts[0].equals("PBS")) {
                    preferences.put("PBS", parts[1]);
                    continue;
                }
                if (parts[0].equals("ssh_home_prefix")) {
                    preferences.put("ssh_home_prefix", parts[1]);
                    continue;
                }
                if (parts[0].equals("MAX_PROCESSES")) {
                    preferences.put("MAX_PROCESSES", parts[1]);
                    continue;
                }
                if (parts[0].equals("SERVER_BIN_PATH")) {
                    preferences.put("SERVER_BIN_PATH", parts[1]);
                    continue;
                }
                if (parts[0].equals("DEMO_MODE")) {
                    preferences.put("DEMO_MODE", parts[1]);
                    continue;
                }
                if (parts[0].equals("DEFAULT_NUMBER_PROCESSES")) {
                    preferences.put("DEFAULT_NUMBER_PROCESSES", parts[1]);
                    continue;
                }
                if (!parts[0].equals("EXPIRES_ON")) continue;
                preferences.put("EXPIRES_ON", parts[1]);
            }
        }
        System.out.println("expires_on: " + preferences.get("EXPIRES_ON", "") + "\n");
    }

    public abstract String get(String var1, String var2);

    public abstract void put(String var1, String var2);

    public abstract void savePreferences();

    public class LocalPathManager {
        String gproLocalFolderStr;
        String userLocalFolderStr;
        String pipelineLocalFolderStr;
        String userLogFolderStr;
        String userTrackFolderStr;
        String userReportsFolderStr;

        private void init() {
            this.gproLocalFolderStr = null;
            this.userLocalFolderStr = null;
            this.pipelineLocalFolderStr = null;
            this.userLogFolderStr = null;
            this.userTrackFolderStr = null;
            this.userReportsFolderStr = null;
            String gproHomeFolderName = "GPRO";
            File userPath = new File(System.getProperty("user.home"));
            File gproLocalFolder = new File(userPath, gproHomeFolderName);
            if (!gproLocalFolder.exists()) {
                gproLocalFolder.mkdir();
            }
            this.gproLocalFolderStr = gproLocalFolder.getAbsolutePath();
            if (UserManager.this.activeLogin != null) {
                String userAccount = UserManager.this.activeLogin.getUserName();
                String serverName = UserManager.this.activeLogin.getHostInfo().getServerURL();
                File userLocalFolder = new File(gproLocalFolder, userAccount);
                if (!userLocalFolder.exists()) {
                    userLocalFolder.mkdir();
                }
                if (!(userLocalFolder = new File(userLocalFolder, serverName)).exists()) {
                    userLocalFolder.mkdir();
                }
                this.userLocalFolderStr = userLocalFolder.getAbsolutePath();
                File pipelineLocalFolder = new File(userLocalFolder, UserManager.this.getModuleId());
                if (!pipelineLocalFolder.exists()) {
                    pipelineLocalFolder.mkdir();
                }
                this.pipelineLocalFolderStr = pipelineLocalFolder.getAbsolutePath();
                File localFolder = new File(pipelineLocalFolder, "logs");
                if (!localFolder.exists()) {
                    localFolder.mkdirs();
                }
                this.userLogFolderStr = localFolder.getAbsolutePath();
                localFolder = new File(pipelineLocalFolder, "tracks");
                if (!localFolder.exists()) {
                    localFolder.mkdirs();
                }
                this.userTrackFolderStr = localFolder.getAbsolutePath();
                localFolder = new File(pipelineLocalFolder, "reports");
                if (!localFolder.exists()) {
                    localFolder.mkdirs();
                }
                this.userReportsFolderStr = localFolder.getAbsolutePath();
            }
        }

        public File getGproHome() {
            return new File(this.gproLocalFolderStr);
        }

        public File getuserFolder() {
            return new File(this.userLocalFolderStr);
        }

        public File getModuleFolder() {
            return new File(this.pipelineLocalFolderStr);
        }

        public File getModuleFolder(String child) {
            return new File(this.pipelineLocalFolderStr, child);
        }

        public File getLogFolder() {
            return new File(this.userLogFolderStr);
        }

        public File getLogFolder(String child) {
            return new File(this.userLogFolderStr, child);
        }

        public File getTrackFolder() {
            return new File(this.userTrackFolderStr);
        }

        public File getTrackFolder(String child) {
            return new File(this.userTrackFolderStr, child);
        }

        public File getReportFolder() {
            return new File(this.userReportsFolderStr);
        }

        public File getReportFolder(String child) {
            return new File(this.userReportsFolderStr, child);
        }
    }

    public class RemotePathManager {
        String remoteUserHomePath;
        String remoteGproFolder;
        String remoteAppUserFolder;
        String remoteAppTrackFolder;
        String remoteAppLogFolder;
        String remoteUserHistoryFile;
        String remoteUserSubmittedPipelinesFolder;
        String remoteUserSubmittedProjectFolder;
        String remoteLockFolder;
        String remoteTmpFolder;

        private void init() {
            this.remoteTmpFolder = null;
            this.remoteLockFolder = null;
            this.remoteUserSubmittedProjectFolder = null;
            this.remoteUserSubmittedPipelinesFolder = null;
            this.remoteUserHistoryFile = null;
            this.remoteAppLogFolder = null;
            this.remoteAppTrackFolder = null;
            this.remoteAppUserFolder = null;
            this.remoteGproFolder = null;
            this.remoteUserHomePath = null;
            if (UserManager.this.activeLogin != null) {
                this.remoteUserHomePath = UserManager.this.getUserHomePath();
                this.remoteGproFolder = "/.gpro/";
                if (!UserManager.this.getIsChRooted()) {
                    this.remoteGproFolder = this.remoteUserHomePath + this.remoteGproFolder;
                }
                this.remoteAppUserFolder = this.remoteGproFolder + UserManager.this.getModuleId() + "/";
                this.remoteAppTrackFolder = this.remoteAppUserFolder + "track/";
                this.remoteAppLogFolder = this.remoteAppUserFolder + "logs/";
                this.remoteUserHistoryFile = this.remoteAppUserFolder + "hist.hist";
                this.remoteUserSubmittedPipelinesFolder = this.remoteAppUserFolder + "Pipelines/";
                this.remoteUserSubmittedProjectFolder = this.remoteAppUserFolder + "Projects/";
                this.remoteLockFolder = this.remoteGproFolder + "lock/";
                this.remoteTmpFolder = this.remoteGproFolder + "tmp/";
            }
        }

        public String getUserHomePath() {
            return this.remoteUserHomePath;
        }

        public String getRemoteGproFolder() {
            return this.remoteGproFolder;
        }

        public String getRemoteAppUserFolder() {
            return this.remoteAppUserFolder;
        }

        public String getRemoteAppTrackFolder() {
            return this.remoteAppTrackFolder;
        }

        public String getRemoteAppLogFolder() {
            return this.remoteAppLogFolder;
        }

        public String getRemoteUserHistoryFile() {
            return this.remoteUserHistoryFile;
        }

        public String getRemoteUserSubmittedPipelinesFolder() {
            return this.remoteUserSubmittedPipelinesFolder;
        }

        public String getRemoteUserSubmittedPipelinesFolder(String child) {
            return this.remoteUserSubmittedPipelinesFolder + child;
        }

        public String getRemoteUserSubmittedProjectFolder() {
            return this.remoteUserSubmittedProjectFolder;
        }

        public String getRemoteUserSubmittedProjectFolder(String child) {
            return this.remoteUserSubmittedProjectFolder + child;
        }

        public String getRemoteLockFolder() {
            return this.remoteLockFolder;
        }

        public String getRemoteTmpFolder() {
            return this.remoteTmpFolder;
        }

        public String sanitizeFTPFilePath(String filePath) {
            if (UserManager.this.getIsChRooted() && filePath.startsWith(this.remoteUserHomePath)) {
                return filePath.replaceFirst(this.remoteUserHomePath, "");
            }
            return filePath;
        }

        public String sanitizeFilePathWithTelda(String filePath) {
            if (!UserManager.this.getIsChRooted()) {
                return filePath;
            }
            if (!filePath.startsWith(this.remoteUserHomePath) && !filePath.startsWith("$HOME")) {
                if (filePath.isEmpty()) {
                    return "$HOME";
                }
                if (filePath.charAt(0) == '/') {
                    filePath = filePath.substring(1);
                }
                return "$HOME/" + filePath;
            }
            return filePath;
        }
    }
}

