/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.fileExplorerBasic.jobs;

import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class PasteFilesJob
extends Job {
    private FileExplorerBasic fileExplorer;

    public PasteFilesJob(String name, final FileExplorerBasic fileExplorer) {
        super(name);
        this.fileExplorer = fileExplorer;
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (fileExplorer.getCut()) {
                            final File[] selectedFiles = fileExplorer.getSelectedFilesCut();
                            if (selectedFiles != null) {
                                IProgressService service = PlatformUI.getWorkbench().getProgressService();
                                try {
                                    service.runInUI((IRunnableContext)service, new IRunnableWithProgress(){

                                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                            fileExplorer.deleteNodes(selectedFiles, monitor);
                                        }
                                    }, null);
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            fileExplorer.setCut(false);
                        }
                    }
                });
            }
        });
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.fileExplorer.paste(super.getName(), monitor);
        monitor.done();
        return Status.OK_STATUS;
    }
}

