/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.fileExplorerBasic.dialogs;

import com.biotechvana.e3utils.PreferenceManager;
import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import java.io.File;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileNewDialog
extends TitleAreaDialog {
    private FileExplorerBasic fileExplorer;
    private Text textParent;
    private Text textFile;
    private Button buttonParent;
    private String parentDirectory;

    public FileNewDialog(Shell parentShell, FileExplorerBasic fileExplorer, String parentDirectory) {
        super(parentShell);
        this.fileExplorer = fileExplorer;
        this.parentDirectory = parentDirectory;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Composite compositeArea = new Composite(composite, 0);
        GridLayout layoutArea = new GridLayout(3, false);
        compositeArea.setLayout((Layout)layoutArea);
        compositeArea.setLayoutData((Object)new GridData(768));
        Label labelParent = new Label(compositeArea, 0);
        labelParent.setText("Parent folder:");
        GridData layoutData = new GridData();
        labelParent.setLayoutData((Object)layoutData);
        this.textParent = new Text(compositeArea, 2052);
        if (this.parentDirectory != null) {
            this.textParent.setText(this.parentDirectory);
        }
        layoutData = new GridData(768);
        layoutData.widthHint = 400;
        this.textParent.setLayoutData((Object)layoutData);
        this.buttonParent = new Button(compositeArea, 8);
        this.buttonParent.setText("Browse");
        layoutData = new GridData();
        this.buttonParent.setLayoutData((Object)layoutData);
        Label labelFile = new Label(compositeArea, 0);
        labelFile.setText("File name:");
        layoutData = new GridData();
        labelFile.setLayoutData((Object)layoutData);
        this.textFile = new Text(compositeArea, 2052);
        this.textFile.setText(".txt");
        this.textFile.setSelection(0);
        layoutData = new GridData(768);
        layoutData.widthHint = 400;
        layoutData.horizontalSpan = 2;
        this.textFile.setLayoutData((Object)layoutData);
        this.textFile.setFocus();
        this.addListeners();
        return super.createDialogArea(parent);
    }

    private void addListeners() {
        this.buttonParent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileNewDialog.this.selectParent();
                FileNewDialog.this.validate();
            }
        });
        this.textFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileNewDialog.this.validate();
            }
        });
    }

    public void create() {
        super.create();
        this.setTitle("New File");
        this.setMessage("Create a new file");
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        this.fileExplorer.createNewFile(this.textParent.getText(), this.textFile.getText());
        super.okPressed();
    }

    private boolean validate() {
        this.getButton(0).setEnabled(false);
        if (!this.validateFile()) {
            return false;
        }
        if (!this.validateParent()) {
            return false;
        }
        this.getButton(0).setEnabled(true);
        return true;
    }

    private boolean validateFile() {
        return !this.textFile.getText().isEmpty();
    }

    private boolean validateParent() {
        if (this.textParent.getText().isEmpty()) {
            return false;
        }
        File parent = new File(this.textParent.getText());
        return parent.isDirectory();
    }

    private void selectParent() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4);
        dialog.setFilterPath(PreferenceManager.getInstance().get("workspace", ""));
        String res = dialog.open();
        if (res == null) {
            return;
        }
        this.textParent.setText(res);
    }
}

