/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.fileExplorerBasic;

import com.biotechvana.commons.SharedImages;
import java.io.File;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class FileExplorerLabelProvider
implements ILabelProvider {
    private File workspace;

    public FileExplorerLabelProvider(File workspace) {
        this.workspace = workspace;
    }

    public Image getImage(Object element) {
        File file = (File)element;
        if (file.isDirectory()) {
            if (file.getAbsolutePath().equalsIgnoreCase(this.workspace.getAbsolutePath())) {
                return SharedImages.PROJECT;
            }
            return SharedImages.FOLDER;
        }
        String filename = file.getName();
        if (filename.endsWith(".html") || filename.endsWith(".htm") || filename.endsWith(".xml")) {
            return SharedImages.HTML;
        }
        if (filename.endsWith(".txt") || filename.endsWith(".fa") || filename.endsWith(".fasta") || filename.endsWith(".fna") || filename.endsWith(".faa") || filename.endsWith(".aln") || filename.endsWith(".pir") || filename.endsWith(".sto") || filename.endsWith(".phy")) {
            return SharedImages.FILE;
        }
        if (filename.endsWith(".doc") || filename.endsWith(".docx") || filename.endsWith(".rtf")) {
            return SharedImages.WORD;
        }
        if (filename.endsWith(".tgz") || filename.endsWith(".gz") || filename.endsWith(".zip") || filename.endsWith(".7z") || filename.endsWith(".bzip") || filename.endsWith(".tar") || filename.endsWith(".rar")) {
            return SharedImages.PACKAGE;
        }
        if (filename.endsWith(".csv") || filename.endsWith(".xls") || filename.endsWith(".xlsx")) {
            return SharedImages.TABLE;
        }
        if (filename.endsWith(".pdf") || filename.endsWith(".ps")) {
            return SharedImages.ACROBAT;
        }
        if (filename.endsWith(".gb") || filename.endsWith(".gbk")) {
            return SharedImages.GENBANK;
        }
        if (filename.endsWith(".png") || filename.endsWith(".gif") || filename.endsWith(".jpg") || filename.endsWith(".jpeg") || filename.endsWith(".tiff")) {
            return SharedImages.IMAGEFILE;
        }
        return SharedImages.DEFAULT;
    }

    public String getText(Object element) {
        return ((File)element).getName();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

