/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.e3utils.ui;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ProductProperties;
import org.eclipse.ui.internal.about.AboutItem;
import org.eclipse.ui.internal.about.AboutTextManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class AboutDialog
extends TrayDialog {
    public static String AboutDialog_shellTitle = "About {0}";
    private static final int MAX_IMAGE_WIDTH_FOR_TEXT = 250;
    private IProduct product;
    private String productName;
    private ArrayList<Image> images = new ArrayList();
    private StyledText text;
    private AboutTextManager aboutTextManager;
    public static final ImageDescriptor PROJECT_LOGO_DESC = AboutDialog.getImageDescriptor("icons/ciencia.png");
    public static final Image PROJECT_LOGO = PROJECT_LOGO_DESC.createImage();

    public AboutDialog(Shell parentShell) {
        super(parentShell);
        this.product = Platform.getProduct();
        if (this.product != null) {
            this.productName = this.product.getName();
        }
    }

    public boolean close() {
        for (Image image : this.images) {
            image.dispose();
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)AboutDialog_shellTitle, (Object)this.productName));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Button b = this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
        b.setFocus();
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Image aboutImage = null;
        AboutItem item = null;
        if (this.product != null) {
            String aboutText;
            ImageDescriptor imageDescriptor = ProductProperties.getAboutImage((IProduct)this.product);
            if (imageDescriptor != null) {
                aboutImage = imageDescriptor.createImage();
            }
            if ((aboutImage == null || aboutImage.getBounds().width <= 250) && (aboutText = ProductProperties.getAboutText((IProduct)this.product)) != null) {
                item = AboutTextManager.scan((String)aboutText);
            }
            if (aboutImage != null) {
                this.images.add(aboutImage);
            }
        }
        Composite workArea = new Composite(parent, 0);
        GridLayout workLayout = new GridLayout();
        workLayout.marginHeight = 0;
        workLayout.marginWidth = 0;
        workLayout.verticalSpacing = 0;
        workLayout.horizontalSpacing = 0;
        workArea.setLayout((Layout)workLayout);
        workArea.setLayoutData((Object)new GridData(1808));
        Color background = JFaceColors.getBannerBackground((Display)parent.getDisplay());
        Color foreground = JFaceColors.getBannerForeground((Display)parent.getDisplay());
        Composite top = (Composite)super.createDialogArea(workArea);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        top.setBackground(background);
        top.setForeground(foreground);
        Composite topContainer = new Composite(top, 0);
        topContainer.setBackground(background);
        topContainer.setForeground(foreground);
        layout = new GridLayout();
        layout.numColumns = aboutImage == null || item == null ? 1 : 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        topContainer.setLayout((Layout)layout);
        GC gc = new GC((Drawable)parent);
        int topContainerHeightHint = 100;
        try {
            topContainerHeightHint = Math.max(topContainerHeightHint, gc.getFontMetrics().getHeight() * 6);
        }
        finally {
            gc.dispose();
        }
        if (aboutImage != null) {
            Label imageLabel = new Label(topContainer, 0);
            imageLabel.setBackground(background);
            imageLabel.setForeground(foreground);
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            data.grabExcessHorizontalSpace = false;
            imageLabel.setLayoutData((Object)data);
            imageLabel.setImage(aboutImage);
            topContainerHeightHint = Math.max(topContainerHeightHint, aboutImage.getBounds().height);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.heightHint = topContainerHeightHint;
        topContainer.setLayoutData((Object)data);
        if (item != null) {
            int minWidth = 400;
            final ScrolledComposite scroller = new ScrolledComposite(topContainer, 768);
            data = new GridData(1808);
            data.widthHint = 400;
            scroller.setLayoutData((Object)data);
            final Composite textComposite = new Composite((Composite)scroller, 0);
            textComposite.setBackground(background);
            layout = new GridLayout();
            textComposite.setLayout((Layout)layout);
            this.text = new StyledText(textComposite, 74);
            this.text.setFont(parent.getFont());
            this.text.setText(item.getText());
            this.text.setCursor(null);
            this.text.setBackground(background);
            this.text.setForeground(foreground);
            this.aboutTextManager = new AboutTextManager(this.text);
            this.aboutTextManager.setItem(item);
            GridData gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.text.setLayoutData((Object)gd);
            scroller.getHorizontalBar().setIncrement(20);
            scroller.getVerticalBar().setIncrement(20);
            final boolean[] inresize = new boolean[1];
            textComposite.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    if (inresize[0]) {
                        return;
                    }
                    inresize[0] = true;
                    textComposite.layout(true);
                    int width = textComposite.getClientArea().width;
                    Point p = textComposite.computeSize(width, -1);
                    scroller.setMinSize(400, p.y);
                    inresize[0] = false;
                }
            });
            scroller.setExpandHorizontal(true);
            scroller.setExpandVertical(true);
            Point p = textComposite.computeSize(400, -1);
            textComposite.setSize(p.x, p.y);
            scroller.setMinWidth(400);
            scroller.setMinHeight(p.y);
            scroller.setContent((Control)textComposite);
        }
        Label bar = new Label(workArea, 258);
        data = new GridData();
        data.horizontalAlignment = 4;
        bar.setLayoutData((Object)data);
        Composite bottom = (Composite)super.createDialogArea(workArea);
        layout = new GridLayout();
        bottom.setLayout((Layout)layout);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        bottom.setLayoutData((Object)data);
        bar = new Label(bottom, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        bar.setLayoutData((Object)data);
        return workArea;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        Bundle bundle = FrameworkUtil.getBundle(AboutDialog.class);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        return imageDescriptor;
    }
}

