/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.e3utils;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class WorkspaceUtils {
    public static String getPerspectiveId() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void switchPerspective(String perspectiveId) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().setPerspective(PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getPartState(IWorkbenchPartReference partReference) {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPartState(partReference);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static int getPartState(String partID) {
        try {
            IViewReference ref = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(partID);
            return WorkspaceUtils.getPartState((IWorkbenchPartReference)ref);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static void minimizePart(IWorkbenchPartReference partReference) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().setPartState(partReference, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void minimizePart(String partID) {
        try {
            IViewReference ref = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(partID);
            WorkspaceUtils.minimizePart((IWorkbenchPartReference)ref);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void restorePart(IWorkbenchPartReference partReference) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().setPartState(partReference, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void restorePart(String partID) {
        try {
            IViewReference ref = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(partID);
            WorkspaceUtils.restorePart((IWorkbenchPartReference)ref);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void maximizePart(IWorkbenchPartReference partReference) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().setPartState(partReference, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void maximizePart(String partID) {
        try {
            IViewReference ref = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(partID);
            WorkspaceUtils.maximizePart((IWorkbenchPartReference)ref);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Shell getShell() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static IEditorPart getActiveEditor() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static IEditorReference getActiveEditorReference(String editorId) {
        try {
            IEditorReference[] editorReferences;
            IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference edRef = iEditorReferenceArray[n2];
                if (edRef.getId().equals(editorId) && edRef.getEditor(false).equals(activeEditor)) {
                    return edRef;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static IEditorReference[] getEditorReference(String editorId) {
        ArrayList<IEditorReference> listReferences;
        block5: {
            try {
                IEditorReference[] editorReferences;
                listReferences = new ArrayList<IEditorReference>();
                IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference edRef = iEditorReferenceArray[n2];
                    if (edRef.getId().equals(editorId)) {
                        listReferences.add(edRef);
                    }
                    ++n2;
                }
                if (listReferences.size() != 0) break block5;
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return listReferences.toArray(new IEditorReference[listReferences.size()]);
    }

    public static IEditorReference[] getEditorReference(String editorId, String partName) {
        ArrayList<IEditorReference> listReferences;
        block5: {
            try {
                IEditorReference[] editorReferences;
                listReferences = new ArrayList<IEditorReference>();
                IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference edRef = iEditorReferenceArray[n2];
                    if (edRef.getId().equals(editorId) && edRef.getPartName().equals(partName)) {
                        listReferences.add(edRef);
                    }
                    ++n2;
                }
                if (listReferences.size() != 0) break block5;
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return listReferences.toArray(new IEditorReference[listReferences.size()]);
    }

    public static void activateEditor(String editorId) {
        try {
            IEditorReference[] editorReferences;
            IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference edRef = iEditorReferenceArray[n2];
                if (edRef.getId().equals(editorId)) {
                    WorkspaceUtils.activateEditor(edRef);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void activateEditor(IEditorReference editorReference) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate(editorReference.getPart(true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void closeEditor(String editorId, boolean save) {
        try {
            IEditorReference[] editorReferences;
            IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference edRef = iEditorReferenceArray[n2];
                if (edRef.getId().equals(editorId)) {
                    WorkspaceUtils.closeEditor(edRef, save);
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void closeEditor(IEditorPart editorPart, boolean save) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorPart, save);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void closeEditor(IEditorReference editorReference, boolean save) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorReference.getEditor(true), save);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void activateView(String viewId) {
        try {
            WorkspaceUtils.activateView(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(viewId));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void activateView(String viewId, String secondaryId) {
        try {
            WorkspaceUtils.activateView(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(viewId, secondaryId));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void activateView(IViewReference viewReference) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate(viewReference.getPart(true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void hideView(String viewId) {
        try {
            WorkspaceUtils.hideView(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(viewId));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void hideView(String viewId, String secondaryId) {
        try {
            WorkspaceUtils.hideView(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(viewId, secondaryId));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void hideView(IViewReference viewReference) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(viewReference);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static IViewPart showView(String viewId) throws PartInitException {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewId);
    }

    public static IViewPart findView(String viewId) {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(viewId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static IViewReference findViewReference(String viewId) {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(viewId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static IViewReference findViewReference(String viewId, String secondaryId) {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(viewId, secondaryId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static IEditorPart openEditor(IEditorInput editorInput, String editorId) throws PartInitException {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(editorInput, editorId);
    }

    public static void updateViews(String[] viewIds) {
        try {
            IViewReference[] viewReferences;
            Arrays.sort(viewIds);
            Object[] objectArray = viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
            int n = viewReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference ref = objectArray[n2];
                if (Arrays.binarySearch(viewIds, ref.getId()) < 0) {
                    WorkspaceUtils.hideView(ref);
                }
                ++n2;
            }
            objectArray = viewIds;
            n = viewIds.length;
            n2 = 0;
            while (n2 < n) {
                IViewReference s = objectArray[n2];
                if (!WorkspaceUtils.viewIsOpen((String)s)) {
                    try {
                        WorkspaceUtils.showView((String)s);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean viewIsOpen(String id) {
        try {
            IViewReference[] viewReferences;
            IViewReference[] iViewReferenceArray = viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
            int n = viewReferences.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IViewReference ref = iViewReferenceArray[n2];
                if (ref.getId().equals(id)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static Font getFontMono() {
        return JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
    }
}

