/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.e3utils;

import com.biotechvana.utils.Constants;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class P2Util {
    private static final String JUSTUPDATED = "justUpdated";
    private static boolean doUpdate = false;

    static IStatus checkForUpdates(IProvisioningAgent agent, IProgressMonitor monitor) throws OperationCanceledException {
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Checking for application updates...", (int)200);
        IStatus status = operation.resolveModal((IProgressMonitor)sub.newChild(100));
        System.out.println("Update Stats : ");
        P2Util.printIStatus(status);
        if (status.getCode() == 10000) {
            return status;
        }
        if (status.getSeverity() == 8) {
            throw new OperationCanceledException();
        }
        if (status.getSeverity() != 4) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    doUpdate = MessageDialog.openConfirm(null, (String)(String.valueOf(Constants.MODULE_NAME) + " Updates"), (String)("A new version of " + Constants.MODULE_NAME + " is available.\nDo you want to update now ?"));
                }
            });
            if (doUpdate) {
                doUpdate = false;
                ProvisioningJob job = operation.getProvisioningJob(null);
                status = job.runModal((IProgressMonitor)sub.newChild(100));
                if (status.getSeverity() == 8) {
                    throw new OperationCanceledException();
                }
            } else {
                throw new OperationCanceledException();
            }
        }
        return status;
    }

    public static void checkForUpdate(BundleContext context, String plugin_ID, final IPreferenceStore prefStore) {
        final IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)context, (String)IProvisioningAgent.SERVICE_NAME);
        if (agent == null) {
            LogHelper.log((IStatus)new Status(4, plugin_ID, "No provisioning agent found.  This application is not set up for updates."));
        }
        if (prefStore.getBoolean(JUSTUPDATED)) {
            prefStore.setValue(JUSTUPDATED, false);
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IStatus updateStatus = P2Util.checkForUpdates(agent, monitor);
                if (updateStatus.getCode() != 10000) {
                    if (updateStatus.getSeverity() != 4) {
                        prefStore.setValue(P2Util.JUSTUPDATED, true);
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PlatformUI.getWorkbench().restart();
                            }
                        });
                    } else {
                        LogHelper.log((IStatus)updateStatus);
                    }
                }
            }
        };
        try {
            new ProgressMonitorDialog(null).run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void printIStatus(IStatus status) {
        System.err.println();
        System.err.printf("UpdateStatus NOK : %s", status.getMessage());
        System.err.println();
        if (status.getException() != null) {
            System.err.printf("Error : %s", status.getException());
        }
        if (status.isMultiStatus()) {
            int i = 0;
            while (i < status.getChildren().length) {
                P2Util.printIStatus(status.getChildren()[i]);
                ++i;
            }
        }
    }

    @Deprecated
    static IStatus checkForUpdates1(IProvisioningAgent agent, IProgressMonitor monitor) throws OperationCanceledException {
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        URI uri = null;
        try {
            uri = new URI("http://opathy.uv.es/gpro/updates/VariantSeq");
        }
        catch (URISyntaxException e) {
            throw new OperationCanceledException("Invalid repository location");
        }
        operation.getProvisioningContext().setArtifactRepositories(new URI[]{uri});
        operation.getProvisioningContext().setMetadataRepositories(new URI[]{uri});
        IStatus status = operation.resolveModal(monitor);
        P2Util.printIStatus(status);
        if (status.getCode() == 10000) {
            return Status.CANCEL_STATUS;
        }
        ProvisioningJob provisioningJob = operation.getProvisioningJob(monitor);
        if (provisioningJob == null) {
            return Status.CANCEL_STATUS;
        }
        provisioningJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    PlatformUI.getWorkbench().restart();
                }
                super.done(event);
            }
        });
        provisioningJob.schedule();
        return Status.OK_STATUS;
    }

    public static Version getProductVersion(String productID) {
        ProvisioningUI provisioningUI = ProvisioningUI.getDefaultUI();
        if (provisioningUI == null) {
            return null;
        }
        String profileId = provisioningUI.getProfileId();
        ProvisioningSession session = provisioningUI.getSession();
        if (profileId == null || session == null) {
            return null;
        }
        IProvisioningAgent provisioningAgent = session.getProvisioningAgent();
        if (provisioningAgent == null) {
            return null;
        }
        IProfileRegistry registry = (IProfileRegistry)provisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
        if (registry == null) {
            return null;
        }
        IProfile profile = registry.getProfile(profileId);
        if (profile == null) {
            return null;
        }
        IQuery iuProductQuery = QueryUtil.createIUProductQuery();
        IQueryResult result = profile.query(iuProductQuery, null);
        if (result == null) {
            return null;
        }
        for (IInstallableUnit productIU : result) {
            if (!productID.equals(productIU.getId())) continue;
            Version version = new Version(productIU.getVersion().getOriginal());
            return version;
        }
        return null;
    }
}

