/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.e3utils;

import com.biotechvana.e3utils.BrowseFilesUtils;
import com.biotechvana.utils.FilenameUtils;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MultiFileInput
extends Composite {
    private Button buttonInputSingle;
    private Button buttonInputMulti;
    private File fileInput;
    private Text textInput;
    private Text textOutput;
    public static final int INPUT_MODE_SINGLE = 0;
    public static final int INPUT_MODE_MULTI = 1;

    public MultiFileInput(Composite parent, int style, File fileInput) {
        super(parent, style);
        this.fileInput = fileInput;
        GridLayout layout = new GridLayout(3, false);
        layout.marginBottom = 20;
        this.setLayout((Layout)layout);
        Group groupInput = new Group((Composite)this, 0);
        groupInput.setText("Input mode: ");
        groupInput.setLayout((Layout)new GridLayout(2, false));
        groupInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.buttonInputSingle = new Button((Composite)groupInput, 16);
        this.buttonInputSingle.setText("Single file");
        this.buttonInputSingle.setSelection(fileInput != null);
        this.buttonInputSingle.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonInputMulti = new Button((Composite)groupInput, 16);
        this.buttonInputMulti.setText("Folder with multiple files");
        this.buttonInputMulti.setSelection(fileInput == null);
        this.buttonInputMulti.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Label label = new Label((Composite)this, 0);
        label.setText("Input source:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textInput = new Text((Composite)this, 2060);
        this.textInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)this.textInput.getLayoutData()).widthHint = 300;
        if (fileInput != null) {
            this.textInput.setText(fileInput.getAbsolutePath());
            this.textInput.setSelection(fileInput.getAbsolutePath().length() - 1);
        }
        Button button = new Button((Composite)this, 8);
        button.setText("Browse");
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseFilesUtils.browseFile(MultiFileInput.this.getShell(), MultiFileInput.this.textInput, MultiFileInput.this.buttonInputSingle.getSelection());
            }
        });
        Label label2 = new Label((Composite)this, 0);
        label2.setText("Output folder: ");
        label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textOutput = new Text((Composite)this, 2060);
        this.textOutput.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ((GridData)this.textOutput.getLayoutData()).widthHint = 300;
        Button buttonBrowseOutput = new Button((Composite)this, 8);
        buttonBrowseOutput.setText("Browse");
        buttonBrowseOutput.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        buttonBrowseOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowseFilesUtils.browseOutputFolder(MultiFileInput.this.getShell(), MultiFileInput.this.textOutput, FilenameUtils.getPath((String)MultiFileInput.this.textInput.getText()));
            }
        });
        label2 = new Label((Composite)this, 258);
        label2.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
    }

    public Text getInputControl() {
        return this.textInput;
    }

    public String getInputPath() {
        return this.textInput.getText();
    }

    public String getOutputPath() {
        return this.textOutput.getText();
    }

    public File getFileInput() {
        return this.fileInput;
    }

    public int getInputMode() {
        if (this.buttonInputMulti.getSelection()) {
            return 1;
        }
        return 0;
    }

    public File[] getInputFileList() {
        if (this.buttonInputMulti.getSelection()) {
            return BrowseFilesUtils.getFilesFromFolder(this.textInput.getText());
        }
        return new File[]{new File(this.textInput.getText())};
    }
}

