/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.e3utils;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DetectAppParameters {
    private Pattern patternXms = Pattern.compile("^-Xms(\\d+)([m|M|g|G])$");
    private Pattern patternXmx = Pattern.compile("^-Xmx(\\d+)([m|M|g|G])$");
    private int xms = 0;
    private int xmx = 0;

    public DetectAppParameters() {
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        List<String> listArgs = rb.getInputArguments();
        for (String s : listArgs) {
            Matcher matcherXms = this.patternXms.matcher(s);
            if (matcherXms.matches()) {
                if (matcherXms.group(2).equalsIgnoreCase("g")) {
                    this.xms = Integer.parseInt(matcherXms.group(1)) * 1024;
                    continue;
                }
                this.xms = Integer.parseInt(matcherXms.group(1));
                continue;
            }
            Matcher matcherXmx = this.patternXmx.matcher(s);
            if (!matcherXmx.matches()) continue;
            this.xmx = matcherXmx.group(2).equalsIgnoreCase("g") ? Integer.parseInt(matcherXmx.group(1)) * 1024 : Integer.parseInt(matcherXmx.group(1));
        }
    }

    public int getXms() {
        return this.xms;
    }

    public int getXmx() {
        return this.xmx;
    }
}

