/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.e3utils;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BrowseFilesUtils {
    public static void browseFile(Shell shell, Text textControl, boolean singleFile) {
        if (singleFile) {
            FileDialog dialog = new FileDialog(shell, 4096);
            String res = dialog.open();
            if (res != null) {
                textControl.setText(res);
                textControl.setSelection(res.length());
            }
        } else {
            DirectoryDialog dialog = new DirectoryDialog(shell, 4096);
            String res = dialog.open();
            if (res != null) {
                textControl.setText(res);
                textControl.setSelection(res.length());
            }
        }
    }

    public static void browseOutputFolder(Shell shell, Text textControl, String defaultPath) {
        String res;
        DirectoryDialog dialog = new DirectoryDialog(shell, 8192);
        if (defaultPath != null && !defaultPath.isEmpty()) {
            dialog.setFilterPath(defaultPath);
        }
        if ((res = dialog.open()) != null) {
            textControl.setText(res);
            textControl.setSelection(res.length());
        }
    }

    public static File[] getFilesFromFolder(String filePath) {
        return new File(filePath).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && !pathname.getName().startsWith(".");
            }
        });
    }
}

