/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.pipelineCommander;

import com.biotechvana.pipelineCommander.ActivationHardware;
import com.biotechvana.utils.Constants;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.ProxyManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigInteger;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Date;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;

public class PipelineCommander {
    private static final String appName = "GPRO";
    private static final String appVersion = Constants.APP_VERSION;
    private String DTD = "";
    private int portNumber = 80;
    private URI hostURI;
    private URL commandURL;
    private URL queryURL;
    private URL statusURL;
    private URL cancelURL;
    private Document xmlRequest;
    IPrefs prefs;

    public PipelineCommander(String hostname, IPrefs prefs) throws URISyntaxException, MalformedURLException {
        this.prefs = prefs;
        this.DTD = "http://" + hostname + "/gpro/pipelineCommander/pipelineRequest.dtd";
        if (this.commandURL == null) {
            this.commandURL = new URL("http://" + hostname + "/gpro/pipelineCommander/pipeline_command.php");
        }
        if (this.queryURL == null) {
            this.queryURL = new URL("http://" + hostname + "/gpro/pipelineCommander/pipeline_query.php");
        }
        if (this.statusURL == null) {
            this.statusURL = new URL("http://" + hostname + "/gpro/pipelineCommander/pipeline_status.php");
        }
        if (this.cancelURL == null) {
            this.cancelURL = new URL("http://" + hostname + "/gpro/pipelineCommander/pipeline_cancel.php");
        }
        if (this.hostURI == null) {
            this.hostURI = new URI("http://" + hostname);
        }
    }

    public PipelineCommander(String hostname, int httpPort, IPrefs prefs) throws URISyntaxException, MalformedURLException {
        this.prefs = prefs;
        if (httpPort != 80) {
            hostname = (String)hostname + ":" + httpPort;
        }
        this.DTD = "http://" + (String)hostname + "/gpro/pipelineCommander/pipelineRequest.dtd";
        if (this.commandURL == null) {
            this.commandURL = new URL("http://" + (String)hostname + "/gpro/pipelineCommander/pipeline_command.php");
        }
        if (this.queryURL == null) {
            this.queryURL = new URL("http://" + (String)hostname + "/gpro/pipelineCommander/pipeline_query.php");
        }
        if (this.statusURL == null) {
            this.statusURL = new URL("http://" + (String)hostname + "/gpro/pipelineCommander/pipeline_status.php");
        }
        if (this.cancelURL == null) {
            this.cancelURL = new URL("http://" + (String)hostname + "/gpro/pipelineCommander/pipeline_cancel.php");
        }
        if (this.hostURI == null) {
            this.hostURI = new URI("http://" + (String)hostname);
        }
    }

    public void prepareCommandRequest(String username, String password, String command, boolean ssh, String emailAddress, boolean emailOnCompletion) throws UnknownHostException, SocketException, NoSuchAlgorithmException {
        Element root = new Element("pipelineRequest");
        Element timestampElement = new Element("timestamp");
        timestampElement.appendChild(new Timestamp(new Date().getTime()).toString());
        root.appendChild((Node)timestampElement);
        Element ipElement = new Element("ip");
        ipElement.appendChild(InetAddress.getLocalHost().toString());
        root.appendChild((Node)ipElement);
        Element hidElement = new Element("hid");
        hidElement.appendChild(ActivationHardware.getActiveHardwareAddress());
        root.appendChild((Node)hidElement);
        Element credentialsElement = new Element("credentials");
        Element usernameElement = new Element("username");
        usernameElement.appendChild(username);
        Element passwordElement = new Element("password");
        passwordElement.appendChild(PipelineCommander.md5Hash(password));
        credentialsElement.appendChild((Node)usernameElement);
        credentialsElement.appendChild((Node)passwordElement);
        root.appendChild((Node)credentialsElement);
        Element applicationElement = new Element("application");
        Element appNameElement = new Element("name");
        appNameElement.appendChild(appName);
        Element appVersionElement = new Element("version");
        appVersionElement.appendChild(appVersion);
        applicationElement.appendChild((Node)appNameElement);
        applicationElement.appendChild((Node)appVersionElement);
        root.appendChild((Node)applicationElement);
        Element commandElement = new Element("command");
        commandElement.appendChild(command);
        Attribute sshAtt = new Attribute("ssh", ssh ? "yes" : "no");
        commandElement.addAttribute(sshAtt);
        root.appendChild((Node)commandElement);
        if (emailOnCompletion) {
            Element emailOnCompletionElement = new Element("emailOnCompletion");
            Attribute emailAddressAtt = new Attribute("emailAddress", emailAddress);
            emailOnCompletionElement.addAttribute(emailAddressAtt);
            root.appendChild((Node)emailOnCompletionElement);
        }
        this.xmlRequest = new Document(root);
        this.xmlRequest.insertChild((Node)new DocType("pipelineRequest", this.DTD), 0);
    }

    public void prepareQueryRequest(String username, String password, String database, String query) throws UnknownHostException, SocketException, NoSuchAlgorithmException {
        Element root = new Element("pipelineRequest");
        Element timestampElement = new Element("timestamp");
        timestampElement.appendChild(new Timestamp(new Date().getTime()).toString());
        root.appendChild((Node)timestampElement);
        Element ipElement = new Element("ip");
        ipElement.appendChild(InetAddress.getLocalHost().toString());
        root.appendChild((Node)ipElement);
        Element hidElement = new Element("hid");
        hidElement.appendChild(ActivationHardware.getActiveHardwareAddress());
        root.appendChild((Node)hidElement);
        Element credentialsElement = new Element("credentials");
        Element usernameElement = new Element("username");
        usernameElement.appendChild(username);
        Element passwordElement = new Element("password");
        passwordElement.appendChild(password);
        credentialsElement.appendChild((Node)usernameElement);
        credentialsElement.appendChild((Node)passwordElement);
        root.appendChild((Node)credentialsElement);
        Element applicationElement = new Element("application");
        Element appNameElement = new Element("name");
        appNameElement.appendChild(appName);
        Element appVersionElement = new Element("version");
        appVersionElement.appendChild(appVersion);
        applicationElement.appendChild((Node)appNameElement);
        applicationElement.appendChild((Node)appVersionElement);
        root.appendChild((Node)applicationElement);
        Element databaseElement = new Element("database");
        databaseElement.appendChild(database);
        root.appendChild((Node)databaseElement);
        Element queryElement = new Element("query");
        queryElement.appendChild(query);
        root.appendChild((Node)queryElement);
        this.xmlRequest = new Document(root);
        this.xmlRequest.insertChild((Node)new DocType("pipelineRequest", this.DTD), 0);
    }

    public void prepareStatusRequest(String username, String password) throws UnknownHostException, SocketException, NoSuchAlgorithmException {
        Element root = new Element("pipelineRequest");
        Element timestampElement = new Element("timestamp");
        timestampElement.appendChild(new Timestamp(new Date().getTime()).toString());
        root.appendChild((Node)timestampElement);
        Element ipElement = new Element("ip");
        ipElement.appendChild(InetAddress.getLocalHost().toString());
        root.appendChild((Node)ipElement);
        Element hidElement = new Element("hid");
        hidElement.appendChild(ActivationHardware.getActiveHardwareAddress());
        root.appendChild((Node)hidElement);
        Element credentialsElement = new Element("credentials");
        Element usernameElement = new Element("username");
        usernameElement.appendChild(username);
        Element passwordElement = new Element("password");
        passwordElement.appendChild(PipelineCommander.md5Hash(password));
        credentialsElement.appendChild((Node)usernameElement);
        credentialsElement.appendChild((Node)passwordElement);
        root.appendChild((Node)credentialsElement);
        Element applicationElement = new Element("application");
        Element appNameElement = new Element("name");
        appNameElement.appendChild(appName);
        Element appVersionElement = new Element("version");
        appVersionElement.appendChild(appVersion);
        applicationElement.appendChild((Node)appNameElement);
        applicationElement.appendChild((Node)appVersionElement);
        root.appendChild((Node)applicationElement);
        Element statusElement = new Element("status");
        root.appendChild((Node)statusElement);
        this.xmlRequest = new Document(root);
        this.xmlRequest.insertChild((Node)new DocType("pipelineRequest", this.DTD), 0);
    }

    public void prepareStatusRequest(String username, String password, int pid) throws UnknownHostException, SocketException, NoSuchAlgorithmException {
        Element root = new Element("pipelineRequest");
        Element timestampElement = new Element("timestamp");
        timestampElement.appendChild(new Timestamp(new Date().getTime()).toString());
        root.appendChild((Node)timestampElement);
        Element ipElement = new Element("ip");
        ipElement.appendChild(InetAddress.getLocalHost().toString());
        root.appendChild((Node)ipElement);
        Element hidElement = new Element("hid");
        hidElement.appendChild(ActivationHardware.getActiveHardwareAddress());
        root.appendChild((Node)hidElement);
        Element credentialsElement = new Element("credentials");
        Element usernameElement = new Element("username");
        usernameElement.appendChild(username);
        Element passwordElement = new Element("password");
        passwordElement.appendChild(PipelineCommander.md5Hash(password));
        credentialsElement.appendChild((Node)usernameElement);
        credentialsElement.appendChild((Node)passwordElement);
        root.appendChild((Node)credentialsElement);
        Element applicationElement = new Element("application");
        Element appNameElement = new Element("name");
        appNameElement.appendChild(appName);
        Element appVersionElement = new Element("version");
        appVersionElement.appendChild(appVersion);
        applicationElement.appendChild((Node)appNameElement);
        applicationElement.appendChild((Node)appVersionElement);
        root.appendChild((Node)applicationElement);
        Element statusElement = new Element("status");
        Attribute pidAtt = new Attribute("pid", Integer.toString(pid));
        statusElement.addAttribute(pidAtt);
        root.appendChild((Node)statusElement);
        this.xmlRequest = new Document(root);
        this.xmlRequest.insertChild((Node)new DocType("pipelineRequest", this.DTD), 0);
    }

    public void prepareCancelRequest(String username, String password, int pid) throws UnknownHostException, SocketException {
        Element root = new Element("pipelineRequest");
        Element timestampElement = new Element("timestamp");
        timestampElement.appendChild(new Timestamp(new Date().getTime()).toString());
        root.appendChild((Node)timestampElement);
        Element ipElement = new Element("ip");
        ipElement.appendChild(InetAddress.getLocalHost().toString());
        root.appendChild((Node)ipElement);
        Element hidElement = new Element("hid");
        hidElement.appendChild(ActivationHardware.getActiveHardwareAddress());
        root.appendChild((Node)hidElement);
        Element credentialsElement = new Element("credentials");
        Element usernameElement = new Element("username");
        usernameElement.appendChild(username);
        Element passwordElement = new Element("password");
        passwordElement.appendChild(password);
        credentialsElement.appendChild((Node)usernameElement);
        credentialsElement.appendChild((Node)passwordElement);
        root.appendChild((Node)credentialsElement);
        Element applicationElement = new Element("application");
        Element appNameElement = new Element("name");
        appNameElement.appendChild(appName);
        Element appVersionElement = new Element("version");
        appVersionElement.appendChild(appVersion);
        applicationElement.appendChild((Node)appNameElement);
        applicationElement.appendChild((Node)appVersionElement);
        root.appendChild((Node)applicationElement);
        Element cancelElement = new Element("cancel");
        Attribute pidAtt = new Attribute("pid", Integer.toString(pid));
        cancelElement.addAttribute(pidAtt);
        root.appendChild((Node)cancelElement);
        this.xmlRequest = new Document(root);
        this.xmlRequest.insertChild((Node)new DocType("pipelineRequest", this.DTD), 0);
    }

    public void postPipelineRequest(Writer output) throws IOException {
        HttpURLConnection connection = null;
        try {
            try {
                URL connectionURL = null;
                Builder parser = new Builder(false);
                parser.build(this.xmlRequest.toXML(), null);
                if (this.xmlRequest.getRootElement().getChildElements("command").size() > 0) {
                    connectionURL = this.commandURL;
                } else if (this.xmlRequest.getRootElement().getChildElements("query").size() > 0) {
                    connectionURL = this.queryURL;
                } else if (this.xmlRequest.getRootElement().getChildElements("status").size() > 0) {
                    connectionURL = this.statusURL;
                } else if (this.xmlRequest.getRootElement().getChildElements("cancel").size() > 0) {
                    connectionURL = this.cancelURL;
                }
                try {
                    ProxyManager pm = new ProxyManager(this.prefs);
                    if (pm.getProxyType() == "proxy_type_manual") {
                        String proxyHost = (String)pm.getProxyManualSettings().get("proxy_http_host");
                        int proxyPort = Integer.parseInt((String)pm.getProxyManualSettings().get("proxy_http_port"));
                        final String proxyUser = (String)pm.getProxyManualSettings().get("proxy_user");
                        final String proxyPass = (String)pm.getProxyManualSettings().get("proxy_password");
                        try {
                            if (!proxyUser.isEmpty()) {
                                Authenticator.setDefault(new Authenticator(){

                                    @Override
                                    protected PasswordAuthentication getPasswordAuthentication() {
                                        return new PasswordAuthentication(proxyUser, proxyPass.toCharArray());
                                    }
                                });
                            }
                            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                            connection = (HttpURLConnection)connectionURL.openConnection(proxy);
                        }
                        catch (Exception e) {
                            System.out.println("Could not configure proxy");
                        }
                    } else {
                        connection = (HttpURLConnection)connectionURL.openConnection();
                    }
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(true);
                    connection.setDoInput(true);
                    connection.setUseCaches(false);
                    connection.setAllowUserInteraction(false);
                    connection.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
                    try (OutputStream out = connection.getOutputStream();){
                        try {
                            OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
                            StringReader xmlReader = new StringReader(this.xmlRequest.toXML());
                            PipelineCommander.pipe(xmlReader, writer);
                            ((Writer)writer).close();
                        }
                        catch (IOException exception) {
                            throw new IOException("IOException while posting sbufferfer", exception);
                        }
                    }
                    try (InputStream in = connection.getInputStream();){
                        try {
                            InputStreamReader reader = new InputStreamReader(in);
                            PipelineCommander.pipe(reader, output);
                            ((Reader)reader).close();
                        }
                        catch (IOException exception) {
                            throw new IOException("IOException while reading response", exception);
                        }
                    }
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                    throw new IOException("Connection error (is server running at " + connectionURL.toString() + " ?): " + String.valueOf(exception));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String md5Hash(String s) throws NoSuchAlgorithmException {
        MessageDigest md5Generator = MessageDigest.getInstance("MD5");
        md5Generator.update(s.getBytes(Charset.defaultCharset()), 0, s.length());
        String hashedPassword = String.format("%1$032X", new BigInteger(1, md5Generator.digest()));
        return hashedPassword;
    }

    private static void pipe(Reader reader, Writer writer) throws IOException {
        char[] buffer = new char[1024];
        int read = 0;
        while ((read = reader.read(buffer)) >= 0) {
            writer.write(buffer, 0, read);
        }
        writer.flush();
    }

    public static void main(String[] args) throws IOException, URISyntaxException, NoSuchAlgorithmException {
        PipelineCommander pc = new PipelineCommander("biotechvana2.uv.es", null);
        OutputStreamWriter output = new OutputStreamWriter(System.out);
        pc.prepareCommandRequest("rfutami", "xxx", "ls -lh > nueva_lista2.txt", true, "ricardo.futami@biotechvana.com", false);
        pc.postPipelineRequest(output);
        System.out.println("=============\n");
    }
}

