/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.e4.ui.internal.workbench.swt.Policy;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class WorkbenchSWTActivator
implements BundleActivator,
DebugOptionsListener {
    public static final String PI_RENDERERS = "org.eclipse.e4.ui.workbench.swt";
    private BundleContext context;
    private ServiceTracker<?, Location> locationTracker;
    private static WorkbenchSWTActivator activator;
    private DebugTrace trace;
    private static final String FN_DIALOG_SETTINGS = "dialog_settings.xml";
    private IDialogSettings dialogSettings = null;

    public static WorkbenchSWTActivator getDefault() {
        return activator;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext context) throws Exception {
        activator = this;
        this.context = context;
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("listener.symbolic.name", PI_RENDERERS);
        context.registerService(DebugOptionsListener.class, (Object)this, props);
    }

    public void stop(BundleContext context) throws Exception {
        this.saveDialogSettings();
    }

    public Bundle getBundle() {
        if (this.context == null) {
            return null;
        }
        return this.context.getBundle();
    }

    public Location getInstanceLocation() {
        if (this.locationTracker == null) {
            Filter filter = null;
            try {
                filter = this.context.createFilter(Location.INSTANCE_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.locationTracker = new ServiceTracker(this.context, filter, null);
            this.locationTracker.open();
        }
        return (Location)this.locationTracker.getService();
    }

    public static void trace(String option, String msg, Throwable error) {
        activator.getTrace().trace(option, msg, error);
    }

    public void optionsChanged(DebugOptions options) {
        this.trace = options.newDebugTrace(PI_RENDERERS);
        Policy.DEBUG = options.getBooleanOption("org.eclipse.e4.ui.workbench.swt/debug", false);
        Policy.TRACE = options.getBooleanOption("org.eclipse.e4.ui.workbench.swt/trace", false);
        Policy.DEBUG_CMDS = options.getBooleanOption("org.eclipse.e4.ui.workbench.swt/trace/commands", false);
        Policy.DEBUG_CONTEXTS = options.getBooleanOption("org.eclipse.e4.ui.workbench.swt/trace/eclipse.context", false);
        Policy.DEBUG_FOCUS = options.getBooleanOption("org.eclipse.e4.ui.workbench.swt/trace/focus", false);
        Policy.DEBUG_MENUS = options.getBooleanOption("org.eclipse.e4.ui.workbench.swt/trace/menus", false);
        Policy.DEBUG_RENDERER = options.getBooleanOption("org.eclipse.e4.ui.workbench.swt/trace/renderer", false);
        Policy.DEBUG_WORKBENCH = options.getBooleanOption("org.eclipse.e4.ui.workbench.swt/trace/workbench", false);
    }

    public DebugTrace getTrace() {
        return this.trace;
    }

    public IDialogSettings getDialogSettings() {
        if (this.dialogSettings == null) {
            this.loadDialogSettings();
        }
        return this.dialogSettings;
    }

    protected void loadDialogSettings() {
        String readWritePath;
        File settingsFile;
        this.dialogSettings = new DialogSettings("Workbench");
        IPath dataLocation = this.getStateLocationOrNull();
        if (dataLocation != null && (settingsFile = new File(readWritePath = dataLocation.append(FN_DIALOG_SETTINGS).toOSString())).exists()) {
            try {
                this.dialogSettings.load(readWritePath);
            }
            catch (IOException iOException) {
                this.dialogSettings = new DialogSettings("Workbench");
            }
            return;
        }
        Bundle bundle = this.context.getBundle();
        URL dsURL = FileLocator.find((Bundle)bundle, (IPath)IPath.fromOSString((String)FN_DIALOG_SETTINGS), null);
        if (dsURL == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream is = dsURL.openStream();){
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                this.dialogSettings.load((Reader)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            this.dialogSettings = new DialogSettings("Workbench");
        }
    }

    protected void saveDialogSettings() {
        if (this.dialogSettings == null) {
            return;
        }
        try {
            IPath path = this.getStateLocationOrNull();
            if (path == null) {
                return;
            }
            String readWritePath = path.append(FN_DIALOG_SETTINGS).toOSString();
            this.dialogSettings.save(readWritePath);
        }
        catch (IOException | IllegalStateException exception) {}
    }

    private IPath getStateLocationOrNull() {
        try {
            return InternalPlatform.getDefault().getStateLocation(this.context.getBundle(), true);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }
}

