/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.sequenceTrimmer;

import com.biotechvana.sequenceTrimmer.SequenceTrimmer2;
import com.biotechvana.sequenceTrimmer.SequenceTrimmerComposite2;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SequenceTrimmerDialog2
extends TitleAreaDialog {
    private SequenceTrimmerComposite2 stc;
    private String[] header;
    private File fileCsv;

    public SequenceTrimmerDialog2(Shell parentShell, File fileCsv, String[] header) {
        super(parentShell);
        this.fileCsv = fileCsv;
        this.header = header;
    }

    public SequenceTrimmerDialog2(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayout((Layout)new GridLayout(1, false));
        compositeParent.setLayoutData((Object)new GridData(1808));
        this.stc = new SequenceTrimmerComposite2(compositeParent, this.fileCsv, this.header);
        return compositeParent;
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void okPressed() {
        Map<String, String> mapColumns = this.stc.getColumnIndices();
        File inputFasta = this.stc.getInputFasta();
        File inputCsv = this.stc.getInputCsv();
        File outputDir = this.stc.getOutputFolder();
        int nameIndex = Integer.parseInt(mapColumns.get("name"));
        int queryFrame = Integer.parseInt(mapColumns.get("queryFrame"));
        int queryStart = Integer.parseInt(mapColumns.get("queryStart"));
        int queryEnd = Integer.parseInt(mapColumns.get("queryEnd"));
        int hspQuery = Integer.parseInt(mapColumns.get("hspQuery"));
        int hspSubject = Integer.parseInt(mapColumns.get("hspSubject"));
        final SequenceTrimmer2 trimmer = new SequenceTrimmer2(inputFasta, inputCsv, outputDir, hspQuery, hspSubject, this.stc.getHspQueryRatio(), this.stc.getHspHitRatio(), nameIndex, queryStart, queryEnd, queryFrame, this.stc.getOperationFull(), this.stc.getOperationPartial(), this.stc.areNegativeFrameSequencesAlreadyReversed(), this.stc.getKeepFrames());
        try {
            trimmer.validate();
        }
        catch (Exception e1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Sequence trimmer", (String)e1.getMessage());
            return;
        }
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        trimmer.run(monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Sequence trimmer", (String)("Error: " + e.getMessage()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.okPressed();
    }

    public void create() {
        super.create();
        this.getShell().setText("Sequence postprocessing");
        this.setTitle("Edit sequences");
        this.setMessage("Trim, mask and/or highlight regions in FASTA sequences using the annotations provided by the CSV file.");
    }
}

