/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.sequenceTrimmer;

import com.biotechvana.sequenceTrimmer.SequenceTrimmerOperations;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class SequenceTrimmerComposite2
extends Composite {
    private File inputCsv;
    private String[] header;
    private Text textCsv;
    private Text textFasta;
    private Text textOutput;
    private Text textRatio1a;
    private Text textRatio2a;
    private Text textRatio3a;
    private Text textRatio1b;
    private Text textRatio2b;
    private Text textHspQuery;
    private Text textHspHit;
    private Combo comboQueryName;
    private Combo comboQueryFrame;
    private Combo comboQueryStart;
    private Combo comboQueryEnd;
    private Combo comboSubjectStart;
    private Combo comboSubjectEnd;
    private Combo comboHspQuery;
    private Combo comboHspSubject;
    private Combo comboOperationFull;
    private Combo comboOperationPartial;
    private Combo comboOperationRelated;
    private Button buttonUpstreamFull;
    private Button buttonDownstreamFull;
    private Button buttonUpstreamPartial;
    private Button buttonDownstreamPartial;
    private Button buttonUpstreamRelated;
    private Button buttonDownstreamRelated;
    private Button buttonNegativeFrameAlreadyReversed;
    private Button buttonKeepFrame;
    private final String RATIO1_DEFAULT = "85";
    private final String RATIO2_DEFAULT = "30";
    private final String[] OPERATIONS = new String[]{"Trimming", "Masking", "Core in uppercase"};
    private final String UPSTREAM_STRING = "Upstream";
    private final String DOWNSTREAM_STRING = "Downstream";

    public SequenceTrimmerComposite2(Composite parent, String[] header) {
        this(parent, 0, null, header);
    }

    public SequenceTrimmerComposite2(Composite parent, File inputCsv, String[] header) {
        this(parent, 0, inputCsv, header);
    }

    public SequenceTrimmerComposite2(Composite parent, int style, File inputCsv, String[] header) {
        super(parent, style);
        this.inputCsv = inputCsv;
        this.header = header;
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        this.setLayout((Layout)layout);
        Composite compositeInput = this.createCompositeInput(this);
        compositeInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Group groupDataColumns = this.createGroupColumns(this);
        groupDataColumns.setLayoutData((Object)new GridData(4, 2, false, false, 3, 1));
        ((GridData)groupDataColumns.getLayoutData()).verticalIndent = 20;
        Group groupThreshold = this.createGroupThreshold(this);
        groupThreshold.setLayoutData((Object)new GridData(4, 2, false, false, 3, 1));
        ((GridData)groupThreshold.getLayoutData()).verticalIndent = 20;
        Group groupActions = this.createGroupActions(this);
        groupActions.setLayoutData((Object)new GridData(4, 2, false, false, 3, 1));
        ((GridData)groupActions.getLayoutData()).verticalIndent = 20;
        Composite compositeOutput = this.createGroupOutput(this);
        compositeOutput.setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
        ((GridData)compositeOutput.getLayoutData()).verticalIndent = 20;
        this.init();
    }

    private Group createGroupThreshold(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("HSP threshold");
        GridLayout layout = new GridLayout(5, false);
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 0);
        label.setText("HSP query > ");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textHspQuery = new Text((Composite)group, 2052);
        this.textHspQuery.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.textHspQuery.getLayoutData()).widthHint = 100;
        this.textHspQuery.setText("30");
        label = new Label((Composite)group, 0);
        label.setText("HSP hit > ");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textHspHit = new Text((Composite)group, 2052);
        this.textHspHit.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.textHspHit.getLayoutData()).widthHint = 100;
        this.textHspHit.setText("85");
        label = new Label((Composite)group, 0);
        label.setText("Set a percentage threshold for both the HSP quey and HSP hit \nto let the tool to classify sequences as full-length cDNA/transcripts \nif both HSPs reach the threshold or as partial sequence otherwise");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)label.getLayoutData()).horizontalIndent = 20;
        return group;
    }

    private Composite createCompositeInput(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText("FASTA file:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textFasta = new Text(composite, 2060);
        this.textFasta.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button button = new Button(composite, 8);
        button.setText("Browse");
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String res;
                FileDialog dialog = new FileDialog(SequenceTrimmerComposite2.this.getShell(), 4096);
                if (SequenceTrimmerComposite2.this.inputCsv != null) {
                    dialog.setFilterPath(SequenceTrimmerComposite2.this.inputCsv.getParent());
                }
                if ((res = dialog.open()) != null) {
                    SequenceTrimmerComposite2.this.textFasta.setText(res);
                    SequenceTrimmerComposite2.this.textFasta.setSelection(res.length());
                }
            }
        });
        label = new Label(composite, 0);
        label.setText("CSV file:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textCsv = new Text(composite, 2060);
        this.textCsv.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.inputCsv != null) {
            this.textCsv.setText(this.inputCsv.getAbsolutePath());
            this.textCsv.setSelection(this.inputCsv.getAbsolutePath().length());
        }
        button = new Button(composite, 8);
        button.setText("Browse");
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SequenceTrimmerComposite2.this.getShell(), 4096);
                String res = dialog.open();
                if (res != null) {
                    SequenceTrimmerComposite2.this.textCsv.setText(res);
                    SequenceTrimmerComposite2.this.textCsv.setSelection(res.length());
                }
            }
        });
        return composite;
    }

    private Group createGroupActions(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Edit actions");
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        Label label = new Label((Composite)group, 0);
        label.setText("Select operations for each category:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ((GridData)composite.getLayoutData()).horizontalIndent = 100;
        Label label2 = new Label(composite, 0);
        label2.setText("Full-length cDNA");
        label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboOperationFull = new Combo(composite, 2060);
        this.comboOperationFull.setItems(this.OPERATIONS);
        this.comboOperationFull.select(0);
        this.comboOperationFull.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboOperationFull.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SequenceTrimmerComposite2.this.operationCombos();
            }
        });
        this.buttonUpstreamFull = new Button(composite, 32);
        this.buttonUpstreamFull.setText("Upstream");
        this.buttonUpstreamFull.setSelection(true);
        this.buttonUpstreamFull.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonDownstreamFull = new Button(composite, 32);
        this.buttonDownstreamFull.setText("Downstream");
        this.buttonDownstreamFull.setSelection(true);
        this.buttonDownstreamFull.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label2 = new Label(composite, 0);
        label2.setText("Partial sequence");
        label2.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboOperationPartial = new Combo(composite, 2060);
        this.comboOperationPartial.setItems(this.OPERATIONS);
        this.comboOperationPartial.select(0);
        this.comboOperationPartial.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboOperationPartial.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SequenceTrimmerComposite2.this.operationCombos();
            }
        });
        this.buttonUpstreamPartial = new Button(composite, 32);
        this.buttonUpstreamPartial.setText("Upstream");
        this.buttonUpstreamPartial.setSelection(true);
        this.buttonUpstreamPartial.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.buttonDownstreamPartial = new Button(composite, 32);
        this.buttonDownstreamPartial.setText("Downstream");
        this.buttonDownstreamPartial.setSelection(true);
        this.buttonDownstreamPartial.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.buttonNegativeFrameAlreadyReversed = new Button(composite, 32);
        this.buttonNegativeFrameAlreadyReversed.setText("Sequences in reverse frame have been previously converted into forward frame");
        this.buttonNegativeFrameAlreadyReversed.setLayoutData((Object)new GridData(1, 1, true, false, 3, 1));
        this.buttonKeepFrame = new Button(composite, 32);
        this.buttonKeepFrame.setSelection(true);
        this.buttonKeepFrame.setText("Keep annotation frames when trimming");
        this.buttonKeepFrame.setLayoutData((Object)new GridData(1, 1, true, false, 3, 1));
        return group;
    }

    private void operationCombos() {
        if (this.comboOperationFull.getItem(this.comboOperationFull.getSelectionIndex()).equals(this.OPERATIONS[2])) {
            this.buttonDownstreamFull.setSelection(true);
            this.buttonDownstreamFull.setEnabled(false);
            this.buttonUpstreamFull.setSelection(true);
            this.buttonUpstreamFull.setEnabled(false);
        } else {
            this.buttonDownstreamFull.setEnabled(true);
            this.buttonUpstreamFull.setEnabled(true);
        }
        if (this.comboOperationPartial.getItem(this.comboOperationPartial.getSelectionIndex()).equals(this.OPERATIONS[2])) {
            this.buttonDownstreamPartial.setSelection(true);
            this.buttonDownstreamPartial.setEnabled(false);
            this.buttonUpstreamPartial.setSelection(true);
            this.buttonUpstreamPartial.setEnabled(false);
        } else {
            this.buttonDownstreamPartial.setEnabled(true);
            this.buttonDownstreamPartial.setEnabled(true);
        }
    }

    private Composite createGroupOutput(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText("Output directory:");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textOutput = new Text(composite, 2060);
        this.textOutput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button button = new Button(composite, 8);
        button.setText("Browse");
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String res;
                DirectoryDialog dialog = new DirectoryDialog(SequenceTrimmerComposite2.this.getShell(), 8192);
                if (SequenceTrimmerComposite2.this.inputCsv != null) {
                    dialog.setFilterPath(SequenceTrimmerComposite2.this.inputCsv.getParent());
                }
                if ((res = dialog.open()) != null) {
                    SequenceTrimmerComposite2.this.textOutput.setText(res);
                    SequenceTrimmerComposite2.this.textOutput.setSelection(res.length());
                }
            }
        });
        return composite;
    }

    private Group createGroupColumns(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Required columns");
        GridLayout layout = new GridLayout(8, false);
        layout.marginWidth = 10;
        group.setLayout((Layout)layout);
        new Label((Composite)group, 0).setText("Query name:");
        this.comboQueryName = new Combo((Composite)group, 2060);
        new Label((Composite)group, 0).setText("Query start:");
        this.comboQueryStart = new Combo((Composite)group, 2060);
        new Label((Composite)group, 0).setText("Hit start:");
        this.comboSubjectStart = new Combo((Composite)group, 2060);
        new Label((Composite)group, 0).setText("HSP query:");
        this.comboHspQuery = new Combo((Composite)group, 2060);
        new Label((Composite)group, 0).setText("Query frame:");
        this.comboQueryFrame = new Combo((Composite)group, 2060);
        new Label((Composite)group, 0).setText("Query end:");
        this.comboQueryEnd = new Combo((Composite)group, 2060);
        new Label((Composite)group, 0).setText("Hit end:");
        this.comboSubjectEnd = new Combo((Composite)group, 2060);
        new Label((Composite)group, 0).setText("HSP hit:");
        this.comboHspSubject = new Combo((Composite)group, 2060);
        return group;
    }

    private void init() {
        this.comboQueryName.setItems(this.header);
        this.comboQueryStart.setItems(this.header);
        this.comboQueryEnd.setItems(this.header);
        this.comboSubjectStart.setItems(this.header);
        this.comboSubjectEnd.setItems(this.header);
        this.comboHspQuery.setItems(this.header);
        this.comboHspSubject.setItems(this.header);
        this.comboQueryFrame.setItems(this.header);
        this.autodetectComboItem(this.comboQueryName, new String[]{"Query", "name", "query name", "Sequence"});
        this.autodetectComboItem(this.comboQueryFrame, new String[]{"Query frame", "Query-frame", "Query_frame"});
        this.autodetectComboItem(this.comboQueryStart, new String[]{"Query from", "query-from", "query_from", "Query start", "query-start", "query_start"});
        this.autodetectComboItem(this.comboQueryEnd, new String[]{"Query to", "query-to", "query_to", "Query end", "query-end", "query_end"});
        this.autodetectComboItem(this.comboSubjectStart, new String[]{"Hit from", "hit-from", "hit_from", "hit start", "hit-start", "hit_start", "subject from", "subject-from", "subject_from", "subject start", "subject-start", "subject_start"});
        this.autodetectComboItem(this.comboSubjectEnd, new String[]{"Hit to", "hit-to", "hit_to", "hit end", "hit-end", "hit_end", "subject to", "subject-to", "subject_to", "subject end", "subject-end", "subject_end"});
        this.autodetectComboItem(this.comboHspQuery, new String[]{"hsp/query", "hsp_query", "hsp-query"});
        this.autodetectComboItem(this.comboHspSubject, new String[]{"hsp/subject", "hsp_subject", "hsp-subject", "hsp/hit", "hsp_hit", "hsp-hit"});
    }

    private void autodetectComboItem(Combo combo, String[] searchStrings) {
        int i = 0;
        while (i < combo.getItemCount()) {
            String is = combo.getItem(i);
            String[] stringArray = searchStrings;
            int n = searchStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String ss = stringArray[n2];
                if (is.compareToIgnoreCase(ss) == 0) {
                    combo.select(i);
                    return;
                }
                ++n2;
            }
            ++i;
        }
        combo.deselectAll();
    }

    public File getInputCsv() {
        return new File(this.textCsv.getText());
    }

    public File getInputFasta() {
        return new File(this.textFasta.getText());
    }

    public File getOutputFolder() {
        return new File(this.textOutput.getText());
    }

    public Map<String, String> getColumnIndices() {
        HashMap<String, String> mapColumns = new HashMap<String, String>();
        mapColumns.put("name", String.valueOf(this.comboQueryName.getSelectionIndex()));
        mapColumns.put("queryFrame", String.valueOf(this.comboQueryFrame.getSelectionIndex()));
        mapColumns.put("queryStart", String.valueOf(this.comboQueryStart.getSelectionIndex()));
        mapColumns.put("queryEnd", String.valueOf(this.comboQueryEnd.getSelectionIndex()));
        mapColumns.put("subjectStart", String.valueOf(this.comboSubjectStart.getSelectionIndex()));
        mapColumns.put("subjectEnd", String.valueOf(this.comboSubjectEnd.getSelectionIndex()));
        mapColumns.put("hspQuery", String.valueOf(this.comboHspQuery.getSelectionIndex()));
        mapColumns.put("hspSubject", String.valueOf(this.comboHspSubject.getSelectionIndex()));
        return mapColumns;
    }

    public float getHspQueryRatio() {
        return Float.parseFloat(this.textHspQuery.getText());
    }

    public float getHspHitRatio() {
        return Float.parseFloat(this.textHspHit.getText());
    }

    public boolean getKeepFrames() {
        return this.buttonKeepFrame.getSelection();
    }

    public SequenceTrimmerOperations getOperationFull() {
        return this.getOperation(this.comboOperationFull, this.buttonUpstreamFull, this.buttonDownstreamFull);
    }

    public SequenceTrimmerOperations getOperationPartial() {
        return this.getOperation(this.comboOperationPartial, this.buttonUpstreamPartial, this.buttonDownstreamPartial);
    }

    public SequenceTrimmerOperations getOperationRelated() {
        return this.getOperation(this.comboOperationRelated, this.buttonUpstreamRelated, this.buttonDownstreamRelated);
    }

    private SequenceTrimmerOperations getOperation(Combo combo, Button buttonUpstream, Button buttonDownstream) {
        if (combo.getText().equalsIgnoreCase(this.OPERATIONS[0])) {
            if (buttonUpstream.getSelection() && buttonDownstream.getSelection()) {
                return SequenceTrimmerOperations.TRIM_BOTH;
            }
            if (buttonUpstream.getSelection()) {
                return SequenceTrimmerOperations.TRIM_UPSTREAM;
            }
            if (buttonDownstream.getSelection()) {
                return SequenceTrimmerOperations.TRIM_DOWNSTREAM;
            }
            return SequenceTrimmerOperations.NONE;
        }
        if (combo.getText().equalsIgnoreCase(this.OPERATIONS[1])) {
            if (buttonUpstream.getSelection() && buttonDownstream.getSelection()) {
                return SequenceTrimmerOperations.MASK_BOTH;
            }
            if (buttonUpstream.getSelection()) {
                return SequenceTrimmerOperations.MASK_UPSTREAM;
            }
            if (buttonDownstream.getSelection()) {
                return SequenceTrimmerOperations.MASK_DOWNSTREAM;
            }
            return SequenceTrimmerOperations.NONE;
        }
        if (combo.getText().equalsIgnoreCase(this.OPERATIONS[2])) {
            return SequenceTrimmerOperations.CORE_UPPERCASE;
        }
        return SequenceTrimmerOperations.NONE;
    }

    public boolean areNegativeFrameSequencesAlreadyReversed() {
        return this.buttonNegativeFrameAlreadyReversed.getSelection();
    }
}

