/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.main;

import com.biotechvana.metabolicPathEditor.data.SequenceEnzyme;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class CompositeEnzymes
extends Composite {
    private Table table;
    private TableViewer tableViewer;
    private List<SequenceEnzyme> model;
    private boolean showSpeciesFilter = false;
    static HashMap<String, Color> colorMap = new HashMap();

    public CompositeEnzymes(Composite parent, int style, boolean showSpeciesFilter) {
        super(parent, style);
        colorMap.put("red", new Color((Device)this.getDisplay(), 255, 0, 0));
        colorMap.put("blue", new Color((Device)this.getDisplay(), 0, 0, 255));
        colorMap.put("brown", new Color((Device)this.getDisplay(), 165, 42, 42));
        colorMap.put("yellow", new Color((Device)this.getDisplay(), 255, 255, 0));
        colorMap.put("pink", new Color((Device)this.getDisplay(), 255, 192, 203));
        colorMap.put("green", new Color((Device)this.getDisplay(), 0, 255, 0));
        colorMap.put("cyan", new Color((Device)this.getDisplay(), 0, 255, 255));
        colorMap.put("violet", new Color((Device)this.getDisplay(), 238, 130, 238));
        colorMap.put("tan", new Color((Device)this.getDisplay(), 210, 180, 140));
        colorMap.put("magenta", new Color((Device)this.getDisplay(), 255, 0, 255));
        colorMap.put("coral", new Color((Device)this.getDisplay(), 255, 127, 80));
        colorMap.put("gold", new Color((Device)this.getDisplay(), 255, 215, 0));
        colorMap.put("azure", new Color((Device)this.getDisplay(), 240, 255, 255));
        colorMap.put("gray", new Color((Device)this.getDisplay(), 128, 128, 128));
        colorMap.put("orange", new Color((Device)this.getDisplay(), 255, 165, 0));
        colorMap.put("bisque", new Color((Device)this.getDisplay(), 255, 228, 196));
        colorMap.put("BlueViolet", new Color((Device)this.getDisplay(), 138, 43, 226));
        colorMap.put("CadetBlue", new Color((Device)this.getDisplay(), 95, 158, 160));
        colorMap.put("DarkOrange", new Color((Device)this.getDisplay(), 255, 140, 0));
        colorMap.put("DarkSalmon", new Color((Device)this.getDisplay(), 233, 150, 122));
        colorMap.put("DarkSeaGreen", new Color((Device)this.getDisplay(), 143, 188, 143));
        colorMap.put("DarkSlateBlue", new Color((Device)this.getDisplay(), 72, 61, 139));
        colorMap.put("DarkSlateGray", new Color((Device)this.getDisplay(), 47, 79, 79));
        colorMap.put("DarkTurquoise", new Color((Device)this.getDisplay(), 0, 206, 209));
        colorMap.put("Turquoise", new Color((Device)this.getDisplay(), 64, 224, 208));
        colorMap.put("wheat", new Color((Device)this.getDisplay(), 245, 222, 179));
        colorMap.put("YellowGreen", new Color((Device)this.getDisplay(), 154, 205, 50));
        colorMap.put("thistle", new Color((Device)this.getDisplay(), 216, 191, 216));
        colorMap.put("salmon", new Color((Device)this.getDisplay(), 250, 128, 114));
        colorMap.put("OrangeRed", new Color((Device)this.getDisplay(), 255, 69, 0));
        colorMap.put("LightYellow", new Color((Device)this.getDisplay(), 255, 255, 224));
        this.setLayout((Layout)new FillLayout());
        this.showSpeciesFilter = showSpeciesFilter;
        this.table = new Table((Composite)this, 2060);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        TableViewerColumn col1 = new TableViewerColumn(this.tableViewer, 16384);
        col1.getColumn().setText("Color");
        col1.getColumn().setWidth(150);
        col1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SequenceEnzyme se = (SequenceEnzyme)element;
                return se.getColorName();
            }

            public Color getBackground(Object element) {
                SequenceEnzyme se = (SequenceEnzyme)element;
                return colorMap.get(se.getColorName());
            }
        });
        TableViewerColumn col2 = new TableViewerColumn(this.tableViewer, 16384);
        col2.getColumn().setText("Enzyme");
        col2.getColumn().setWidth(300);
        col2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SequenceEnzyme se = (SequenceEnzyme)element;
                return se.getEnzyme() + " - " + se.getEnzymeName();
            }
        });
        TableViewerColumn col3 = new TableViewerColumn(this.tableViewer, 16384);
        col3.getColumn().setText("Sequences");
        col3.getColumn().setWidth(500);
        col3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SequenceEnzyme se = (SequenceEnzyme)element;
                return CompositeEnzymes.this.getSequenceString(se.getListSequences());
            }
        });
        if (this.showSpeciesFilter) {
            TableViewerColumn col4 = new TableViewerColumn(this.tableViewer, 16384);
            col4.getColumn().setText("Species Filter");
            col4.getColumn().setWidth(500);
            col4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    SequenceEnzyme se = (SequenceEnzyme)element;
                    return se.getSpeciesFilter();
                }
            });
        }
    }

    public void setModel(List<SequenceEnzyme> listEnzymes) {
        this.model = listEnzymes;
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return CompositeEnzymes.this.model.toArray();
            }
        });
        this.tableViewer.setInput(this.model);
    }

    private String getSequenceString(List<String> listSequences) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < listSequences.size() - 1) {
            builder.append(listSequences.get(i) + ", ");
            ++i;
        }
        builder.append(listSequences.get(listSequences.size() - 1));
        return builder.toString();
    }
}

