/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.data;

import com.biotechvana.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class Species
implements Comparable<Species> {
    private String speciesName;
    private String taxonId;
    private String keggCode;
    private boolean keggResolved = false;
    private HashMap<String, List<String>> ec2Maps = new HashMap();

    public Species(String name) {
        this.speciesName = name;
    }

    public String getSpeciesName() {
        return this.speciesName;
    }

    public int hashCode() {
        return this.speciesName.hashCode();
    }

    public String toString() {
        return this.speciesName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.speciesName.equals(obj);
        }
        if (obj instanceof Species) {
            return this.speciesName.equals(((Species)obj).speciesName);
        }
        return false;
    }

    @Override
    public int compareTo(Species o) {
        return this.speciesName.compareTo(o.getSpeciesName());
    }

    public boolean resolveTaxon(String taxon, String kegg_sym) {
        this.taxonId = taxon;
        this.keggCode = kegg_sym;
        if (!StringUtils.isEmpty((String)kegg_sym)) {
            this.keggResolved = true;
        }
        return this.keggResolved;
    }

    public String getTaxonId() {
        return this.taxonId;
    }

    public String getKeggCode() {
        return this.keggCode;
    }

    public boolean isResolved() {
        return this.keggResolved;
    }

    public void addEC2Map(String ec, String pathway) {
        if (!this.ec2Maps.containsKey(ec)) {
            this.ec2Maps.put(ec, new ArrayList());
        }
        this.ec2Maps.get(ec).add("map" + pathway);
    }

    public Collection<String> getMapForEc(String enzyme) {
        return this.ec2Maps.get(enzyme);
    }
}

