/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.data;

import com.biotechvana.metabolicPathEditor.data.EnzymePathway;
import com.biotechvana.metabolicPathEditor.data.Species;
import com.biotechvana.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class SequenceEnzyme {
    private static HashMap<String, String> EC_TO_DESC_CACHE = new HashMap();
    private static HashMap<String, List<String>> EC_TO_MAPS_CACHE = new HashMap();
    private static HashMap<String, String> MAP_TO_DESC_CACHE = new HashMap();
    private String enzyme;
    private String enzymeName = "";
    private List<String> listSequences = new ArrayList<String>();
    private HashMap<String, Species> speciesList = new HashMap();
    private List<String> mapPathways = new ArrayList<String>();
    private HashMap<String, String> mapPathwaysDescription = new HashMap();
    private List<String> listEvidenceCodes = new ArrayList<String>();
    private String colorName;
    private String colorHex;
    private int totalUniqueCount = 0;
    private double totalWeight;
    private String spFilter = "";
    static HashSet<String> overviewMaps = new HashSet<String>(){
        {
            this.add("map01100");
            this.add("map01110");
            this.add("map01120");
            this.add("map01130");
            this.add("map01200");
            this.add("map01210");
            this.add("map01212");
            this.add("map01230");
            this.add("map01220");
        }
    };

    public static String getEnzymeDesc(String enzyme) {
        return EC_TO_DESC_CACHE.get(enzyme);
    }

    public static List<String> getEnzymeMaps(String enzyme) {
        return EC_TO_MAPS_CACHE.get(enzyme);
    }

    public static String getMapName(String mapId) {
        return MAP_TO_DESC_CACHE.get(mapId);
    }

    public static void cacheEnzymeDesc(String code, String descName) {
        EC_TO_DESC_CACHE.put(code, descName);
    }

    public static void cacheEnzymeMap(String code, String mapId, String mapName) {
        if (!EC_TO_MAPS_CACHE.containsKey(code)) {
            EC_TO_MAPS_CACHE.put(code, new ArrayList());
        }
        MAP_TO_DESC_CACHE.put(mapId, mapName);
        EC_TO_MAPS_CACHE.get(code).add(mapId);
    }

    public SequenceEnzyme() {
    }

    public SequenceEnzyme(String enzyme, List<String> listSequences) {
        this.enzyme = enzyme;
        this.listSequences = listSequences;
    }

    public SequenceEnzyme(String enzyme, String sequence) {
        this.enzyme = enzyme;
        this.addSequenceToList(sequence);
    }

    public String getEnzyme() {
        return this.enzyme;
    }

    public void setEnzyme(String enzyme) {
        this.enzyme = enzyme;
    }

    public int getNumberSequences() {
        return this.listSequences.size();
    }

    public String getSequences() {
        StringBuffer sequence = new StringBuffer();
        for (String s : this.listSequences) {
            if (sequence.length() == 0) {
                sequence.append(s);
                continue;
            }
            sequence.append(", " + s);
        }
        return sequence.toString();
    }

    public List<String> getListSequences() {
        return this.listSequences;
    }

    public void addSequenceToList(String sequence) {
        int index = Collections.binarySearch(this.listSequences, sequence);
        if (index < 0) {
            this.listSequences.add(-index - 1, sequence);
        }
    }

    public String getEnzymeName() {
        return this.enzymeName;
    }

    public void setEnzymeName(String enzymeName) {
        this.enzymeName = enzymeName;
    }

    public void addPathway(String mapPathway, String mapPathwayDescription) {
        this.mapPathways.add(mapPathway);
        this.mapPathwaysDescription.put(mapPathway, mapPathwayDescription);
    }

    public int getPathwaysCount() {
        return this.mapPathways.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\tSequences(" + this.listSequences.size() + ")" + Arrays.toString(this.listSequences.toArray(new String[this.listSequences.size()])) + "\n");
        builder.append("\tEvidence codes(" + this.listEvidenceCodes.size() + "): " + Arrays.toString(this.listEvidenceCodes.toArray(new String[this.listEvidenceCodes.size()])) + "\n");
        builder.append("\tWeight: " + this.totalWeight);
        return builder.toString();
    }

    public List<String> getEvidenceCodes() {
        return this.listEvidenceCodes;
    }

    public void setEvidenceCodes(ArrayList<String> evidenceCodes) {
        this.listEvidenceCodes = evidenceCodes;
    }

    public void setEvidenceCodes(String evidenceCodesString) {
        String[] tokens;
        this.listEvidenceCodes = new ArrayList<String>();
        String[] stringArray = tokens = evidenceCodesString.split(";");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (t.trim().length() > 0) {
                this.listEvidenceCodes.add(t.trim());
            }
            ++n2;
        }
    }

    public void addEvidenceCodes(String evidenceCodesString) {
        String[] tokens;
        if (this.listEvidenceCodes == null) {
            this.listEvidenceCodes = new ArrayList<String>();
        }
        String[] stringArray = tokens = evidenceCodesString.split(";");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (t.trim().length() > 0) {
                this.listEvidenceCodes.add(t.trim());
            }
            ++n2;
        }
    }

    public void addEvidenceCodes(ArrayList<String> evidenceCodes) {
        if (evidenceCodes == null) {
            evidenceCodes = new ArrayList();
        }
        for (String e : evidenceCodes) {
            this.listEvidenceCodes.add(e);
        }
    }

    public int getTotalUniqueCount() {
        return this.totalUniqueCount;
    }

    public void setTotalUniqueCount(int totalUniqueCount) {
        this.totalUniqueCount = totalUniqueCount;
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    public void setTotalWeight(double totalWeight) {
        this.totalWeight = totalWeight;
    }

    public String getColorName() {
        return this.colorName;
    }

    public void setColorName(String colorName) {
        this.colorName = colorName;
    }

    public String getColorHex() {
        return this.colorHex;
    }

    public void setColorHex(String colorHex) {
        this.colorHex = colorHex;
    }

    public EnzymePathway getPathway(int i) {
        String map = this.mapPathways.get(i);
        String desc = this.mapPathwaysDescription.get(map);
        return new EnzymePathway(map, desc);
    }

    public void addSpecies(Species species) {
        this.speciesList.put(species.getSpeciesName(), species);
    }

    public String getSpeciesFilter(char delimiter) {
        return this.spFilter.replace('|', delimiter);
    }

    public String getSpeciesFilter() {
        return this.spFilter;
    }

    public void applyFilterPathways() {
        this.applyFilterPathways(false);
    }

    public void applyFilterPathways(boolean addOverviewMap) {
        if (this.speciesList.size() > 0) {
            HashSet<String> allJoin = null;
            for (Species sp : this.speciesList.values()) {
                if (!sp.isResolved()) continue;
                Collection<String> ec2MapList = sp.getMapForEc(this.enzyme);
                if (ec2MapList != null) {
                    if (allJoin == null) {
                        allJoin = new HashSet<String>(ec2MapList);
                        this.spFilter = sp.getSpeciesName();
                        continue;
                    }
                    allJoin.retainAll(ec2MapList);
                    this.spFilter = String.valueOf(this.spFilter) + "|" + sp.getSpeciesName();
                    continue;
                }
                this.spFilter = StringUtils.isEmpty((String)this.spFilter) ? "Warning Code 1(" + sp.getSpeciesName() + ")" : String.valueOf(this.spFilter) + "| Warning Code 1(" + sp.getSpeciesName() + ")";
            }
            if (allJoin != null && allJoin.size() > 0) {
                allJoin.retainAll(this.mapPathways);
                this.mapPathways.clear();
                this.mapPathways.addAll((Collection<String>)allJoin);
            }
        }
        if (!addOverviewMap) {
            for (String ovMap : overviewMaps) {
                this.mapPathways.remove(ovMap);
            }
        }
    }
}

