/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.data;

import com.biotechvana.metabolicPathEditor.data.SequenceEnzyme;
import com.biotechvana.pipelineCommander.PipelineCommanderQueryUtils;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.PreferenceManager;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class QueryEcDescriptionsHTTPRunnable
implements IRunnableWithProgress {
    private List<SequenceEnzyme> listSequenceEnzyme;
    private final String QUERY_EC_DESCRIPTION = "SELECT ec_desc FROM ec2go WHERE ecid = ?";
    private final String PIPELINE_USER = PreferenceManager.getInstance().get("ssh_user", "");
    private final String PIPELINE_PASS = PreferenceManager.getInstance().get("ssh_password", "");
    private final String DB_NAME = PreferenceManager.getInstance().get("DB_PIPELINE", "");
    int stepSize = 1;

    public QueryEcDescriptionsHTTPRunnable(List<SequenceEnzyme> listSequenceEnzymes) {
        this.listSequenceEnzyme = listSequenceEnzymes;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.getEcDescriptions(monitor);
    }

    private void getEcDescriptions(IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Query EC descriptions", this.listSequenceEnzyme.size());
            monitor.subTask("Fetching descriptions for enzyme codes");
            if (this.listSequenceEnzyme.size() > 100) {
                this.stepSize = this.listSequenceEnzyme.size() / 100;
            }
            int i = 0;
            while (i < this.listSequenceEnzyme.size()) {
                block11: {
                    String code = this.listSequenceEnzyme.get(i).getEnzyme();
                    String cachedDesc = SequenceEnzyme.getEnzymeDesc(code);
                    if (cachedDesc != null) {
                        this.listSequenceEnzyme.get(i).setEnzymeName(cachedDesc);
                    } else {
                        String preparedQuery = PipelineCommanderQueryUtils.prepareQuery((String)"SELECT ec_desc FROM ec2go WHERE ecid = ?", (String[])new String[]{code}, (String[])new String[]{"s"});
                        List resultSet = PipelineCommanderQueryUtils.runQuery((IPrefs)PreferenceManager.getInstance(), (String)PreferenceManager.getInstance().get("ssh_host", ""), (String)this.PIPELINE_USER, (String)this.PIPELINE_PASS, (String)this.DB_NAME, (String)preparedQuery);
                        try {
                            if (resultSet.size() == 1) break block11;
                            String descName = ((String)((List)resultSet.get(1)).get(0)).replace("GO:", "");
                            this.listSequenceEnzyme.get(i).setEnzymeName(descName);
                            SequenceEnzyme.cacheEnzymeDesc(code, descName);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (i % this.stepSize == 0) {
                            monitor.worked(this.stepSize);
                        }
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }
}

