/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.data;

import com.biotechvana.metabolicPathEditor.data.EnzymePathway;
import com.biotechvana.metabolicPathEditor.data.SequenceEnzyme;
import com.biotechvana.metabolicPathEditor.main.CompositePathway;
import com.biotechvana.metabolicPathEditor.main.EcWeightDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetabolicPathUtils {
    public HashMap<String, EnzymePathway> getPathwaysModel(List<SequenceEnzyme> listSequenceEnzyme) {
        if (listSequenceEnzyme == null) {
            return null;
        }
        HashMap<String, EnzymePathway> pathways = new HashMap<String, EnzymePathway>();
        ArrayList listDescriptions = new ArrayList();
        for (SequenceEnzyme se : listSequenceEnzyme) {
            int i = 0;
            while (i < se.getPathwaysCount()) {
                EnzymePathway map = se.getPathway(i);
                if (!pathways.containsKey(map.getMapName())) {
                    pathways.put(map.getMapName(), map);
                }
                pathways.get(map.getMapName()).addSequenceEnzyme(se);
                ++i;
            }
        }
        return pathways;
    }

    public Collection<String> getSortedDescriptionList(Collection<String> listOfNames) {
        if (listOfNames == null) {
            return null;
        }
        ArrayList<String> sortedList = new ArrayList<String>();
        for (String desc : listOfNames) {
            int index;
            if (desc == null || desc.length() <= 0 || (index = Collections.binarySearch(sortedList, desc)) >= 0) continue;
            sortedList.add(-index - 1, desc);
        }
        return sortedList;
    }

    public void assignWeightsAndSort(List<SequenceEnzyme> matchingEnzymes) {
        Map<String, String> mapEcWeights = EcWeightDialog.getEcWeightValues();
        for (SequenceEnzyme se : matchingEnzymes) {
            int totalWeight = 0;
            if (se.getEvidenceCodes() != null && se.getEvidenceCodes().size() > 0) {
                for (String ec : se.getEvidenceCodes()) {
                    try {
                        totalWeight = (int)((float)totalWeight + Float.parseFloat(mapEcWeights.get(ec)) * (float)se.getNumberSequences());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            } else {
                totalWeight = 1 * se.getNumberSequences();
            }
            se.setTotalWeight(totalWeight);
        }
        Collections.sort(matchingEnzymes, new Comparator<SequenceEnzyme>(){

            @Override
            public int compare(SequenceEnzyme o1, SequenceEnzyme o2) {
                return (int)(o2.getTotalWeight() - o1.getTotalWeight());
            }
        });
    }

    public void assignColors(List<SequenceEnzyme> matchingEnzymes, int colorMode) {
        if (colorMode == 2) {
            int i = 0;
            while (i < matchingEnzymes.size()) {
                matchingEnzymes.get(i).setColorName(CompositePathway.MAP_COLORS.get(0));
                ++i;
            }
        } else {
            int i = 0;
            while (i < matchingEnzymes.size()) {
                if (i < CompositePathway.MAP_COLORS.size()) {
                    matchingEnzymes.get(i).setColorName(CompositePathway.MAP_COLORS.get(i));
                } else {
                    matchingEnzymes.get(i).setColorName(CompositePathway.MAP_COLORS.get(CompositePathway.MAP_COLORS.size() - 1));
                }
                ++i;
            }
        }
    }

    public int getMatchingEnzymeCount(List<SequenceEnzyme> matchingEnzymes) {
        ArrayList<String> uniqueNames = new ArrayList<String>();
        for (SequenceEnzyme se : matchingEnzymes) {
            for (String name : se.getListSequences()) {
                int index = Collections.binarySearch(uniqueNames, name);
                if (index >= 0) continue;
                uniqueNames.add(-index - 1, name);
            }
        }
        return uniqueNames.size();
    }
}

