/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.data;

import com.biotechvana.metabolicPathEditor.data.EnzymePathway;
import com.biotechvana.metabolicPathEditor.data.MetabolicPathUtils;
import com.biotechvana.metabolicPathEditor.data.SequenceEnzyme;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class MetabolicExportDataRunnable
implements IRunnableWithProgress {
    private final String[] HEADERS = new String[]{"Pathway", "Seqs in Pathway", "Enzyme", "EzymeId", "rSeqs", "Seqs", "Species", "PathwayId", "PathwayImage"};
    private final char SEPARATOR = (char)59;
    private final char DELIMITER = (char)34;
    private List<SequenceEnzyme> listSequenceEnzyme;
    private Collection<EnzymePathway> listMapNames;
    private File outputDir;
    private MetabolicPathUtils metabolicUtils;
    private String fileName;
    private boolean exportSpeciesFilter = false;

    public MetabolicExportDataRunnable(List<SequenceEnzyme> listSequenceEnzyme, Collection<EnzymePathway> listMapNames, File outputDir, String fileName, boolean exportSpeciesFilter) {
        this.listSequenceEnzyme = listSequenceEnzyme;
        this.listMapNames = listMapNames;
        this.outputDir = outputDir;
        this.fileName = fileName;
        this.exportSpeciesFilter = exportSpeciesFilter;
        this.metabolicUtils = new MetabolicPathUtils();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.createMetabolicPathwayFile(monitor);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void createMetabolicPathwayFile(IProgressMonitor monitor) throws InterruptedException, IOException {
        monitor.beginTask("Export metabolic data", this.listMapNames.size());
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.fileName));
        if (this.exportSpeciesFilter) {
            writer.write("## Warning code 1 : EC is associated to a sequence annotated in one species that has not been associated yet to the pathway. Please check the annotation providing this EC.");
            writer.newLine();
        }
        String[] stringArray = this.HEADERS;
        int n = this.HEADERS.length;
        int n2 = 0;
        while (n2 < n) {
            String h = stringArray[n2];
            if (this.exportSpeciesFilter || !h.equals("Species")) {
                writer.append("\"" + h + "\";");
            }
            ++n2;
        }
        writer.newLine();
        try {
            for (EnzymePathway mapName : this.listMapNames) {
                List<SequenceEnzyme> matchingEnzymes = mapName.getMatchingEnzymes();
                int uniqueEnzymeCount = this.metabolicUtils.getMatchingEnzymeCount(matchingEnzymes);
                for (SequenceEnzyme se : matchingEnzymes) {
                    writer.append("\"" + mapName.getMapName() + "\";");
                    writer.append("\"" + String.valueOf(uniqueEnzymeCount) + "\";");
                    writer.append("\"" + se.getEnzymeName() + "\";");
                    writer.append("\"" + se.getEnzyme() + "\";");
                    List<String> sequenceNames = se.getListSequences();
                    writer.append("\"" + String.valueOf(sequenceNames.size()) + "\";");
                    writer.append('\"');
                    int i = 0;
                    while (i < sequenceNames.size() - 1) {
                        writer.append(sequenceNames.get(i) + "; ");
                        ++i;
                    }
                    writer.append(sequenceNames.get(sequenceNames.size() - 1));
                    writer.append('\"');
                    writer.append(';');
                    if (this.exportSpeciesFilter) {
                        writer.append('\"');
                        writer.append(se.getSpeciesFilter(';'));
                        writer.append('\"');
                        writer.append(';');
                    }
                    writer.append("\"" + mapName.getMapID() + "\";");
                    writer.append("\"" + this.outputDir.getAbsolutePath() + File.separator + mapName.getMapID() + ".png\";");
                    writer.newLine();
                }
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            writer.close();
            monitor.done();
        }
    }
}

