/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.data;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.metabolicPathEditor.data.SequenceEnzyme;
import com.biotechvana.metabolicPathEditor.data.Species;
import com.biotechvana.utils.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ExtractEcListRunnable
implements IRunnableWithProgress {
    private CSVEditor csvEditor;
    private int sequenceColumnIndex;
    private int enzymeCodeColumnIndex;
    private int evidenceColumnIndex;
    private int speciesColumnIndex;
    private int stepSize = 1;
    private List<SequenceEnzyme> listSequenceEnzyme;
    private HashMap<String, Species> allSpecies = null;

    public ExtractEcListRunnable(CSVEditor csvEditor, int sequenceColumnIndex, int enzymeCodeColumnIndex, int evidenceColumnIndex, int speciesColumnIndex) {
        this.csvEditor = csvEditor;
        this.sequenceColumnIndex = sequenceColumnIndex;
        this.enzymeCodeColumnIndex = enzymeCodeColumnIndex;
        this.evidenceColumnIndex = evidenceColumnIndex;
        this.speciesColumnIndex = speciesColumnIndex;
        if (this.speciesColumnIndex != -1) {
            this.allSpecies = new HashMap();
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.getEnzymeCodes(monitor);
    }

    private void getEnzymeCodes(IProgressMonitor monitor) throws InterruptedException {
        try {
            this.listSequenceEnzyme = new ArrayList<SequenceEnzyme>();
            List model = (List)this.csvEditor.getModel();
            Pattern patternEC = Pattern.compile("EC:\\d+\\.\\d+(\\.\\d+)?(\\.\\d+)?");
            if (model.size() > 100) {
                this.stepSize = model.size() / 100;
            }
            monitor.beginTask("Parse enzyme codes", model.size());
            int i = 0;
            while (i < model.size()) {
                List row = (List)model.get(i);
                String cellEnzymes = ((String)row.get(this.enzymeCodeColumnIndex)).trim();
                if (cellEnzymes.length() > 0) {
                    String sequenceName = ((String)row.get(this.sequenceColumnIndex)).trim();
                    String[] tokens = cellEnzymes.split(";");
                    String evidenceString = null;
                    String speciesName = null;
                    if (this.evidenceColumnIndex != -1) {
                        evidenceString = ((String)row.get(this.evidenceColumnIndex)).trim();
                    }
                    if (this.speciesColumnIndex != -1) {
                        speciesName = ((String)row.get(this.speciesColumnIndex)).trim();
                    }
                    String[] stringArray = tokens;
                    int n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Matcher m;
                        String token = stringArray[n2];
                        if ((token = token.trim()).length() > 0 && (m = patternEC.matcher(token)).matches()) {
                            int index = Collections.binarySearch(this.listSequenceEnzyme, token, new Comparator<Object>(){

                                @Override
                                public int compare(Object o1, Object o2) {
                                    return ((SequenceEnzyme)o1).getEnzyme().compareTo((String)o2);
                                }
                            });
                            if (index < 0) {
                                se = new SequenceEnzyme(token, sequenceName);
                                this.listSequenceEnzyme.add(-index - 1, se);
                                if (evidenceString != null) {
                                    this.listSequenceEnzyme.get(-index - 1).setEvidenceCodes(evidenceString);
                                }
                                if (!StringUtils.isEmpty((String)speciesName)) {
                                    sp = null;
                                    if (!this.allSpecies.containsKey(speciesName)) {
                                        sp = new Species(speciesName);
                                        this.allSpecies.put(speciesName, sp);
                                    } else {
                                        sp = this.allSpecies.get(speciesName);
                                    }
                                    se.addSpecies(sp);
                                }
                            } else {
                                se = this.listSequenceEnzyme.get(index);
                                se.addSequenceToList(sequenceName);
                                if (evidenceString != null) {
                                    se.addEvidenceCodes(evidenceString);
                                }
                                if (!StringUtils.isEmpty((String)speciesName)) {
                                    sp = null;
                                    if (!this.allSpecies.containsKey(speciesName)) {
                                        sp = new Species(speciesName);
                                        this.allSpecies.put(speciesName, sp);
                                    } else {
                                        sp = this.allSpecies.get(speciesName);
                                    }
                                    se.addSpecies(sp);
                                }
                            }
                        }
                        ++n2;
                    }
                }
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public List<SequenceEnzyme> getListEC() {
        return this.listSequenceEnzyme;
    }

    public Collection<Species> getSpeciesList() {
        return this.allSpecies == null ? null : this.allSpecies.values();
    }
}

