/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.views;

import com.biotechvana.csveditor.actions.keggViewer.KeggViewerOpenAction;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.CsvModifiedRecord;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionRowEdit;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class SequenceView
extends ViewPart {
    public static final String ID = "com.biotechvana.csveditor.views.SequenceView";
    private CSVEditor csvEditor;
    private int selectionIndex;
    private String[] fieldNames;
    private String[] data;
    private List<Text> textNames = new ArrayList<Text>();
    private Link linkNcbi;
    private Button buttonUpdate;
    private Composite composite;
    private Composite parent;
    private ScrolledComposite sc;

    public SequenceView() {
    }

    public SequenceView(CSVEditor csvEditor) {
        this.setData(csvEditor);
    }

    public void setData(CSVEditor csvEditor) {
        this.csvEditor = csvEditor;
        this.selectionIndex = csvEditor.getTable().getSelectionIndex();
        List row = (List)((List)csvEditor.getModel()).get(this.selectionIndex);
        this.fieldNames = csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, true);
        this.data = row.toArray(new String[row.size()]);
        if (this.parent != null) {
            Control[] controlArray = this.parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
        }
        this.sc = new ScrolledComposite(this.parent, 768);
        this.sc.setLayout((Layout)new GridLayout(1, false));
        this.sc.setLayoutData((Object)new GridData(1808));
        this.composite = new Composite((Composite)this.sc, 0);
        this.composite.setLayout((Layout)new GridLayout(3, false));
        this.composite.setLayoutData((Object)new GridData(1808));
        this.composite.pack();
        this.createControls();
        this.composite.setSize(this.composite.computeSize(-1, -1));
        this.sc.setContent((Control)this.composite);
        this.parent.layout();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
    }

    private void createControls() {
        try {
            this.addRow(this.composite, 0, this.fieldNames.length);
            this.buttonUpdate = new Button(this.composite, 0);
            this.buttonUpdate.setText("Update");
            GridData layoutData = new GridData();
            layoutData.horizontalSpan = 3;
            this.buttonUpdate.setLayoutData((Object)layoutData);
            this.composite.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.addListeners();
    }

    private void addListeners() {
        this.buttonUpdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SequenceView.this.run();
            }
        });
    }

    private void addRow(Composite parent, int style, int rows) {
        this.textNames = new ArrayList<Text>();
        int i = 0;
        while (i < rows) {
            Text textValue;
            GridData layoutData = new GridData();
            layoutData.widthHint = 400;
            layoutData.horizontalIndent = 30;
            Label labelCol1 = new Label(parent, 0);
            labelCol1.setText(this.fieldNames[i]);
            if (this.fieldNames[i].equalsIgnoreCase("GI") || this.fieldNames[i].equalsIgnoreCase("Species") || this.fieldNames[i].equalsIgnoreCase("Accession") || this.fieldNames[i].equalsIgnoreCase("GenBank Accession") || this.fieldNames[i].equalsIgnoreCase("GenBank") || this.fieldNames[i].equalsIgnoreCase("GBA")) {
                if (this.data[this.csvEditor.getColumnIndexForName(this.fieldNames[i])].length() > 50) {
                    textValue = new Text(parent, 2626);
                    layoutData.heightHint = 60;
                } else {
                    textValue = new Text(parent, 2052);
                }
                this.linkNcbi = new Link(parent, 0);
                this.linkNcbi.setText("<a>Search in NCBI</a>");
                this.linkNcbi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Program.launch((String)("http://www.ncbi.nlm.nih.gov/gquery/?term=" + textValue.getText()));
                    }
                });
            } else if (this.fieldNames[i].equalsIgnoreCase("EC") || this.fieldNames[i].equalsIgnoreCase("ECs") || this.fieldNames[i].equalsIgnoreCase("E.C.") || this.fieldNames[i].equalsIgnoreCase("Enzyme") || this.fieldNames[i].equalsIgnoreCase("Enzyme code") || this.fieldNames[i].equalsIgnoreCase("Enzyme codes")) {
                textValue = new Text(parent, 2052);
                this.linkNcbi = new Link(parent, 0);
                this.linkNcbi.setText("<a>Search KEGG maps</a>");
                final Text tv = textValue;
                this.linkNcbi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (tv.getText().length() == 0) {
                            return;
                        }
                        String[] tokens = tv.getText().split(";");
                        ArrayList<String> listTokens = new ArrayList<String>();
                        String[] stringArray = tokens;
                        int n = tokens.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String t = stringArray[n2];
                            if (t.trim().length() > 0) {
                                listTokens.add(t);
                            }
                            ++n2;
                        }
                        if (listTokens.size() > 0) {
                            KeggViewerOpenAction action = new KeggViewerOpenAction(listTokens.toArray(new String[listTokens.size()]), 0);
                            action.run();
                        }
                    }
                });
            } else {
                if (this.data[this.csvEditor.getColumnIndexForName(this.fieldNames[i])].length() > 50) {
                    textValue = new Text(parent, 2626);
                    layoutData.heightHint = 60;
                } else {
                    textValue = new Text(parent, 2052);
                }
                layoutData.horizontalSpan = 2;
            }
            textValue.setText(this.data[this.csvEditor.getColumnIndexForName(this.fieldNames[i])]);
            textValue.setLayoutData((Object)layoutData);
            this.textNames.add(textValue);
            ++i;
        }
    }

    private void run() {
        List row = (List)((List)this.csvEditor.getModel()).get(this.selectionIndex);
        int i = 0;
        while (i < this.fieldNames.length) {
            String formText;
            int colIndex = this.csvEditor.getColumnIndexForName(this.fieldNames[i]);
            String modelText = (String)row.get(colIndex);
            if (!modelText.equals(formText = this.textNames.get(i).getText())) {
                int fastaRowIndex = -1;
                int fastaColIndex = -1;
                this.csvEditor.getListModifiedRecords().add(new CsvModifiedRecord(Integer.parseInt((String)row.get(1)) - 1, i, fastaRowIndex, fastaColIndex, modelText, formText));
                row.set(colIndex, formText);
                this.csvEditor.getListActions().add(new CsvActionRowEdit(this.selectionIndex, colIndex, modelText, formText));
            }
            ++i;
        }
        this.csvEditor.getTableViewer().update((Object)row, null);
        this.csvEditor.setModified(true);
    }

    public Composite createGoComposite(Composite parent, String goString) {
        String[] parts;
        Composite composite = new Composite(parent, 0);
        String[] stringArray = parts = goString.split(";");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            Link link = new Link(composite, 0);
            link.setText("<a>" + p + "</a>");
            ++n2;
        }
        return composite;
    }

    public void setFocus() {
    }
}

