/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.views;

import com.biotechvana.csveditor.jobs.keggViewer.KeggMapDownloadJob;
import com.biotechvana.csveditor.views.DBConnection;
import com.biotechvana.utils.PreferenceManager;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.PreparedStatement;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.part.ViewPart;

public class KeggViewer
extends ViewPart {
    public static final String ID = "com.biotechvana.gydbpro.views.KeggViewer";
    public static final String KEGG_URL = "http://www.genome.jp/kegg-bin/show_pathway?";
    public static final String KEGG_DOWNLOAD = "http://www.genome.jp/kegg/pathway/map/";
    public static final String KEGG_EXTENSION = ".png";
    private String defaultOutputPath = null;
    private CTabFolder cTabFolder;

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.cTabFolder = new CTabFolder(composite, 0);
        this.cTabFolder.setLayoutData((Object)new GridData(1808));
    }

    public void setFocus() {
    }

    public ArrayList<String> getKeggsByEc(String[] ecs) {
        ArrayList<String> listMaps;
        block16: {
            Connection connection = DBConnection.getConnection();
            listMaps = new ArrayList<String>();
            try {
                try {
                    PreparedStatement pStatement = (PreparedStatement)connection.prepareStatement("SELECT kegg FROM ec2kegg WHERE ec LIKE ?");
                    String[] stringArray = ecs;
                    int n = ecs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String res;
                        String ec = stringArray[n2];
                        pStatement.setString(1, ec);
                        ResultSet rs = pStatement.executeQuery();
                        if (rs != null && rs.next() && (res = rs.getString(1)) != null && !res.equals("NULL")) {
                            String[] tokens;
                            String[] stringArray2 = tokens = res.split(";");
                            int n3 = tokens.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String t = stringArray2[n4];
                                if (t.length() > 0) {
                                    listMaps.add(t);
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    if (connection == null) break block16;
                    try {
                        connection.close();
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return listMaps;
    }

    public void addPaths(String[] paths) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            final String p = stringArray[n2];
            CTabItem tabItem = new CTabItem(this.cTabFolder, 0);
            tabItem.setShowClose(true);
            tabItem.setText(p);
            Composite composite = new Composite((Composite)this.cTabFolder, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            composite.setLayoutData((Object)new GridData(1808));
            ToolBar toolBar = new ToolBar(composite, 64);
            ToolItem menuBack = new ToolItem(toolBar, 8);
            menuBack.setText("Back");
            ToolItem menuForward = new ToolItem(toolBar, 8);
            menuForward.setText("Forward");
            ToolItem menuDownload = new ToolItem(toolBar, 8);
            menuDownload.setText("Download map");
            GridData layoutData = new GridData(768);
            layoutData.grabExcessHorizontalSpace = true;
            toolBar.setLayoutData((Object)layoutData);
            final Browser browser = new Browser(composite, 0);
            browser.setUrl(KEGG_URL + p.toLowerCase());
            browser.setLayoutData((Object)new GridData(1808));
            menuBack.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    browser.back();
                }
            });
            menuBack.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    browser.forward();
                }
            });
            menuDownload.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String output = KeggViewer.this.selectOutputFile(browser, p.toLowerCase());
                    if (output == null) {
                        return;
                    }
                    KeggMapDownloadJob job = new KeggMapDownloadJob("KEGG Viewer", p.toLowerCase(), output);
                    job.setUser(true);
                    job.schedule();
                }
            });
            tabItem.setControl((Control)composite);
            this.cTabFolder.showItem(tabItem);
            this.cTabFolder.setSelection(tabItem);
            ++n2;
        }
    }

    public boolean downloadMap(String mapId, String outputFile, IProgressMonitor monitor) {
        if (outputFile == null) {
            return false;
        }
        try {
            int b;
            URL url = new URL(KEGG_DOWNLOAD + mapId + KEGG_EXTENSION);
            URLConnection connection = url.openConnection();
            int contentLength = -1;
            try {
                contentLength = connection.getContentLength();
            }
            catch (Exception ex) {
                contentLength = -1;
            }
            if (monitor != null) {
                monitor.beginTask("Download KEGG map", contentLength);
            }
            InputStream in = url.openStream();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));
            while ((b = in.read()) != -1) {
                ((OutputStream)out).write(b);
                if (monitor == null) continue;
                monitor.worked(1);
            }
            ((OutputStream)out).close();
            in.close();
            if (monitor != null) {
                monitor.done();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private String selectOutputFile(Browser browser, String mapId) {
        FileDialog dialog = new FileDialog(browser.getShell(), 8192);
        if (this.defaultOutputPath == null) {
            this.defaultOutputPath = PreferenceManager.getInstance().get("workspace", "");
        }
        dialog.setFilterPath(this.defaultOutputPath);
        dialog.setFileName(mapId + KEGG_EXTENSION);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        this.defaultOutputPath = res;
        return res;
    }
}

