/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ParseAssemblyOut {
    private boolean debug = false;
    private final int BUFFER_SIZE = 524288;
    private File assemblyFile;
    private int columnCount = 0;
    public static final String[] ASSEMBLY_COLUMN_NAMES = new String[]{"SW score", "perc div.", "perc del.", "perc ins.", "query sequence", "query begin", "query end", "query left", "matching repeat", "repeat class/family", "repeat begin", "repeat end", "repeat left", "ID"};
    private String[] header;
    private List<List<String>> model;
    private static final String ASSEMBLY_STRING = "   SW     perc     perc     perc  query                                         position in query  matching          repeat            position in repeat";
    private List<AssemblyRange> listAssemblyRanges;

    public ParseAssemblyOut(File assemblyFile) {
        this.assemblyFile = assemblyFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAssamblyFile(File assemblyFile) {
        int MAX_LINES = 10;
        try (BufferedReader reader = new BufferedReader(new FileReader(assemblyFile));){
            int counter = 0;
            String line = null;
            while (true) {
                line = reader.readLine();
                if (line == null) return false;
                if (counter >= 10) {
                    return false;
                }
                if (line.equals(ASSEMBLY_STRING)) {
                    return true;
                }
                ++counter;
            }
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean parseAssemblyRanges() {
        try {
            this.listAssemblyRanges = new ArrayList<AssemblyRange>();
            try (BufferedReader reader = new BufferedReader(new FileReader(this.assemblyFile), 524288);){
                StringBuilder builder = new StringBuilder();
                char[] buffer = new char[524288];
                int readChars = 0;
                while ((readChars = reader.read(buffer)) != -1) {
                    int i = 0;
                    while (i < readChars) {
                        char c = buffer[i];
                        if (c == '\n') {
                            AssemblyRange aRange = this.parseAssemblyLine(builder.toString());
                            if (aRange != null) {
                                this.listAssemblyRanges.add(aRange);
                            } else if (this.debug) {
                                System.err.println("Fallo con la l\u00ednea: " + builder.toString());
                            }
                            builder = new StringBuilder();
                        } else {
                            builder.append(c);
                        }
                        ++i;
                    }
                }
                AssemblyRange aRange = this.parseAssemblyLine(builder.toString());
                if (aRange != null) {
                    this.listAssemblyRanges.add(aRange);
                } else if (this.debug) {
                    System.err.println("Fallo con la l\u00ednea: " + builder.toString());
                }
            }
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private AssemblyRange parseAssemblyLine(String line) {
        if (line.length() == 0) {
            return null;
        }
        String[] tokens = line.trim().split("\\s{2,}");
        if (tokens.length < 7) {
            return null;
        }
        try {
            return new AssemblyRange(Integer.parseInt(tokens[5]), Integer.parseInt(tokens[6]));
        }
        catch (NumberFormatException ex) {
            if (this.debug) {
                System.out.println("Line: " + line);
                System.out.println("Tokens: " + tokens[5] + " -- " + tokens[6]);
                System.err.println("Cannot parse assembly line range.");
            }
            return null;
        }
    }

    public boolean parse(boolean hasHeader, IProgressMonitor monitor) {
        this.columnCount = this.calculateColumnCount();
        boolean headersFound = false;
        if (!hasHeader) {
            headersFound = true;
        }
        long fileBytes = this.assemblyFile.length();
        if (monitor != null) {
            monitor.beginTask("Reading file", (int)fileBytes);
            monitor.subTask("Parsing file");
        }
        this.model = new ArrayList<List<String>>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.assemblyFile));
            try {
                int counter = 1;
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String[] tokens = line.trim().split("\\s{2,}");
                    if (line.equals(ASSEMBLY_STRING)) {
                        this.header = ASSEMBLY_COLUMN_NAMES;
                        headersFound = true;
                    }
                    if (tokens.length != this.columnCount) continue;
                    if (hasHeader && !headersFound) {
                        headersFound = true;
                        this.header = tokens;
                    } else {
                        ArrayList<String> row = new ArrayList<String>();
                        row.add("0");
                        row.add(String.valueOf(counter));
                        String[] stringArray = tokens;
                        int n = tokens.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String t = stringArray[n2];
                            row.add(t);
                            ++n2;
                        }
                        this.model.add(row);
                    }
                    ++counter;
                    if (monitor == null) continue;
                    monitor.worked(line.length() + 1);
                }
            }
            finally {
                reader.close();
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            return false;
        }
        return true;
    }

    private int calculateColumnCount() {
        int columnCount = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.assemblyFile));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.trim().split("\\s{2,}");
                if (tokens.length <= columnCount) continue;
                columnCount = tokens.length;
            }
        }
        catch (Exception ex) {
            return -1;
        }
        return columnCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String[] getHeaders() {
        return this.header;
    }

    public String[] getColumnNames() {
        return ASSEMBLY_COLUMN_NAMES;
    }

    public List<List<String>> getModel() {
        return this.model;
    }

    public List<AssemblyRange> getListAssemblyRanges() {
        return this.listAssemblyRanges;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public class AssemblyRange {
        private int start;
        private int end;

        public AssemblyRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String toString() {
            return "[" + this.start + " - " + this.end + "]";
        }
    }
}

