/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model;

import com.biotechvana.utils.PreferenceManager;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.PreparedStatement;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GoLevel {
    private final String DB_DRIVER = "com.mysql.jdbc.Driver";
    private final String DB_HOST = "jdbc:mysql://" + PreferenceManager.getInstance().get("ssh_host", "") + "/" + PreferenceManager.getInstance().get("DB_PIPELINE", "");
    private final String DB_USER = PreferenceManager.getInstance().get("DB_USER", "");
    private final String DB_PASS = PreferenceManager.getInstance().get("DB_PASS", "");
    private final String DB_TABLE = "go_depth";
    private Connection connection;
    private final String QUERY_LEVEL = "SELECT level FROM go_depth WHERE acc LIKE ?";
    private Pattern patternGo = Pattern.compile(".*(GO:\\d+)\\D*");
    private PreparedStatement stmtLevel;
    private boolean connectionStarted = false;

    public void initConnection() throws ClassNotFoundException, SQLException {
        Class.forName("com.mysql.jdbc.Driver");
        this.connection = (Connection)DriverManager.getConnection(this.DB_HOST, this.DB_USER, this.DB_PASS);
        this.stmtLevel = (PreparedStatement)this.connection.prepareStatement("SELECT level FROM go_depth WHERE acc LIKE ?");
        this.connectionStarted = true;
    }

    public void closeConnection() throws SQLException {
        this.connection.close();
        this.connectionStarted = false;
    }

    public Map<String, Integer> filterByLevel(Map<String, Integer> mapGo, int levelFilter) throws ClassNotFoundException, SQLException, GoLevelConnectionNotStarted {
        if (!this.connectionStarted) {
            throw new GoLevelConnectionNotStarted();
        }
        HashMap<String, Integer> filteredMap = new HashMap<String, Integer>();
        for (String key : mapGo.keySet()) {
            int level = this.getLevel(key);
            if (level != levelFilter) continue;
            filteredMap.put(key, mapGo.get(key));
        }
        return filteredMap;
    }

    public int getLevel(String goTerm) throws SQLException, GoLevelConnectionNotStarted {
        if (!this.connectionStarted) {
            throw new GoLevelConnectionNotStarted();
        }
        Matcher matcher = this.patternGo.matcher(goTerm);
        if (matcher.find()) {
            String go = matcher.group(1);
            this.stmtLevel.setString(1, go);
            ResultSet resultSet = this.stmtLevel.executeQuery();
            if (resultSet == null) {
                return 0;
            }
            if (resultSet.next()) {
                try {
                    int level = resultSet.getInt(1);
                    return level;
                }
                catch (Exception ex) {
                    return 0;
                }
            }
        }
        return 0;
    }

    class GoLevelConnectionNotStarted
    extends Exception {
        GoLevelConnectionNotStarted() {
        }
    }
}

