/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class FileCopierRunnable
implements IRunnableWithProgress {
    private File input;
    private File output;
    private int bufferSize;
    private static final int DEFAULT_BUFFER_SIZE = 524288;

    public FileCopierRunnable(File input, File output, int bufferSize) {
        this.input = input;
        this.output = output;
        this.bufferSize = bufferSize;
    }

    public FileCopierRunnable(File input, File output) {
        this(input, output, 524288);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.copyFile(monitor);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void copyFile(IProgressMonitor monitor) throws IOException, InterruptedException {
        monitor.beginTask("Copying file", (int)this.input.length());
        FileInputStream reader = new FileInputStream(this.input);
        if (!this.output.exists() && !this.output.createNewFile()) {
            throw new IOException();
        }
        FileOutputStream writer = new FileOutputStream(this.output);
        try {
            byte[] buffer = new byte[this.bufferSize];
            int bytes = reader.read(buffer);
            while (bytes > 0) {
                writer.write(buffer, 0, bytes);
                buffer = new byte[this.bufferSize];
                bytes = reader.read(buffer);
                monitor.worked(bytes);
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            writer.close();
            reader.close();
            monitor.done();
        }
    }
}

