/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EntrezSequenceDownloader {
    private static final String QUERY_URL = "http://www.ncbi.nlm.nih.gov/entrez/eutils/egquery.fcgi?";
    private static final String SEARCH_URL = "http://www.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?";
    private static final String FETCH_URL = "http://www.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?";
    private DocumentBuilderFactory domFactory;
    private DocumentBuilder builder;
    private Document doc;
    private static final int PAUSE = 500;
    private final String DB_PROTEIN = "protein";
    private final String DB_NUCLEOTIDE = "gene";
    private final String DB_NUCCORE = "nuccore";
    private final String GB_EXTENSION = ".gbk";
    private final String FASTA_EXTENSION = ".fa";
    private List<String> notFoundTerms = new ArrayList<String>();

    public String[] download(CSVEditor csvEditor, List<Integer> listSelectedRows, int columnKey, String outputFolder, String rettype, IProgressMonitor monitor) throws InterruptedException {
        return this.download(csvEditor, columnKey, -1, -1, -1, -1, listSelectedRows, outputFolder, rettype, monitor);
    }

    public String[] download(CSVEditor csvEditor, List<Integer> listSelectedRows, int columnKey, int strandKey, String outputFolder, String rettype, IProgressMonitor monitor) throws InterruptedException {
        return this.download(csvEditor, columnKey, strandKey, -1, -1, -1, listSelectedRows, outputFolder, rettype, monitor);
    }

    public String[] download(CSVEditor csvEditor, int columnKey, int columnStrand, int columnStart, int columnEnd, int padding, List<Integer> listSelectedRows, String outputFolder, String rettype, IProgressMonitor monitor) throws InterruptedException {
        String entrezDatabase = "gene";
        List model = (List)csvEditor.getModel();
        monitor.beginTask("Download sequences", listSelectedRows.size());
        for (int i : listSelectedRows) {
            List row = (List)model.get(i);
            String term = (String)row.get(columnKey);
            monitor.subTask("Downloading row: " + i);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            try {
                Object[] queryDatabases = this.getQueryDatabases(new URL("http://www.ncbi.nlm.nih.gov/entrez/eutils/egquery.fcgi?term=" + term));
                System.out.println("Query: http://www.ncbi.nlm.nih.gov/entrez/eutils/egquery.fcgi?term=" + term);
                System.out.println("Databases matched:" + Arrays.toString(queryDatabases));
                Arrays.sort(queryDatabases);
                int resNucleotide = Arrays.binarySearch(queryDatabases, "gene");
                int resProtein = Arrays.binarySearch(queryDatabases, "protein");
                int resNuccore = Arrays.binarySearch(queryDatabases, "nuccore");
                if (resNuccore >= 0) {
                    entrezDatabase = "nuccore";
                } else if (resNucleotide < 0 && resProtein < 0 && resNuccore < 0) {
                    this.notFoundTerms.add(term);
                } else if (resNucleotide >= 0 && resProtein >= 0) {
                    entrezDatabase = "gene";
                } else if (resNucleotide >= 0) {
                    entrezDatabase = "gene";
                } else if (resProtein >= 0) {
                    entrezDatabase = "protein";
                }
                String strand = "2";
                if (columnStrand == -1) {
                    strand = "2";
                } else {
                    strand = (String)row.get(columnStrand);
                    if (strand.equals("-1") && (entrezDatabase.equals("nuccore") || entrezDatabase.equals("gene"))) {
                        strand = "2";
                    }
                }
                System.out.println("Search in database:" + entrezDatabase);
                StringBuilder builderUrl = new StringBuilder();
                builderUrl.append(FETCH_URL);
                builderUrl.append("id=" + (String)row.get(columnKey));
                builderUrl.append("&db=" + entrezDatabase);
                builderUrl.append("&rettype=" + rettype);
                if (columnStart != -1) {
                    int start = 0;
                    try {
                        start = Integer.parseInt((String)row.get(columnStart));
                        if (padding >= 0 && (start -= padding) < 0) {
                            start = 0;
                        }
                    }
                    catch (Exception ex) {
                        start = 0;
                    }
                    builderUrl.append("&seq_start=" + start);
                }
                if (columnEnd != -1) {
                    int end = -1;
                    try {
                        end = Integer.parseInt((String)row.get(columnEnd));
                        if (padding >= 0 && (end += padding) < 0) {
                            end = 0;
                        }
                    }
                    catch (Exception ex) {
                        end = -1;
                    }
                    builderUrl.append("&seq_stop=" + end);
                }
                this.fetchSequence(new URL(builderUrl.toString()), (String)row.get(columnKey), outputFolder);
                monitor.worked(1);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        monitor.done();
        return null;
    }

    public String[] download(String[] terms, String rettype, String outputFolder, IProgressMonitor monitor) throws Exception {
        String entrezDatabase = "gene";
        String[] stringArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            String term = stringArray[n2];
            term = term.trim();
            if (monitor != null) {
                monitor.subTask("Downloading: " + term);
            }
            if (monitor != null && monitor.isCanceled()) {
                return this.notFoundTerms.toArray(new String[this.notFoundTerms.size()]);
            }
            try {
                Object[] queryDatabases = this.getQueryDatabases(new URL("http://www.ncbi.nlm.nih.gov/entrez/eutils/egquery.fcgi?term=" + term));
                System.out.println("Query: http://www.ncbi.nlm.nih.gov/entrez/eutils/egquery.fcgi?term=" + term);
                System.out.println("Databases matched:" + Arrays.toString(queryDatabases));
                Arrays.sort(queryDatabases);
                int resNucleotide = Arrays.binarySearch(queryDatabases, "gene");
                int resProtein = Arrays.binarySearch(queryDatabases, "protein");
                int resNuccore = Arrays.binarySearch(queryDatabases, "nuccore");
                if (resNuccore >= 0) {
                    entrezDatabase = "nuccore";
                } else if (resNucleotide < 0 && resProtein < 0 && resNuccore < 0) {
                    this.notFoundTerms.add(term);
                } else if (resNucleotide >= 0 && resProtein >= 0) {
                    entrezDatabase = "gene";
                } else if (resNucleotide >= 0) {
                    entrezDatabase = "gene";
                } else if (resProtein >= 0) {
                    entrezDatabase = "protein";
                }
                System.out.println("Search in database:" + entrezDatabase);
                URL search = this.getSearchURL(term, entrezDatabase);
                String[] listIds = this.getSearchId(search);
                if (listIds != null && listIds.length > 0) {
                    URL fetch = this.getFetchUrl(listIds[0], entrezDatabase, rettype);
                    this.fetchSequence(fetch, term, outputFolder);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
            ++n2;
        }
        return this.notFoundTerms.toArray(new String[this.notFoundTerms.size()]);
    }

    private URL getSearchURL(String term, String database) throws MalformedURLException {
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append(SEARCH_URL);
        sbuilder.append("db=" + database);
        sbuilder.append("&term=" + term);
        System.out.println("Construyendo url: " + sbuilder.toString());
        URL url = new URL(sbuilder.toString());
        return url;
    }

    private String[] getSearchId(URL url) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<String> listSites = new ArrayList<String>();
        System.out.println("Examinando la url: " + url.getPath());
        this.domFactory = DocumentBuilderFactory.newInstance();
        this.domFactory.setNamespaceAware(true);
        this.builder = this.domFactory.newDocumentBuilder();
        this.doc = this.builder.parse(url.openStream());
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "/eSearchResult/IdList";
        try {
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(this.doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            int i = 0;
            while (i < nodes.getLength()) {
                listSites.add(nodes.item(i).getTextContent());
                ++i;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return listSites.toArray(new String[listSites.size()]);
    }

    private String[] getQueryDatabases(URL url) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<String> listDatabases = new ArrayList<String>();
        this.domFactory = DocumentBuilderFactory.newInstance();
        this.domFactory.setNamespaceAware(true);
        this.builder = this.domFactory.newDocumentBuilder();
        this.doc = this.builder.parse(url.openStream());
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "//ResultItem";
        try {
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(this.doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            String dbName = null;
            String dbCount = null;
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                NodeList children = node.getChildNodes();
                int c = 0;
                while (c < children.getLength()) {
                    if (children.item(c).getNodeName().equals("DbName")) {
                        dbName = children.item(c).getTextContent();
                    } else if (children.item(c).getNodeName().equals("Count")) {
                        dbCount = children.item(c).getTextContent();
                    }
                    ++c;
                }
                if (dbCount != null && !dbCount.equals("0")) {
                    listDatabases.add(dbName);
                }
                ++i;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return listDatabases.toArray(new String[listDatabases.size()]);
    }

    private URL getFetchUrl(String searchId, String database, String rettype) throws MalformedURLException {
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append(FETCH_URL);
        sbuilder.append("db=" + database);
        sbuilder.append("&id=" + searchId);
        sbuilder.append("&rettype=" + rettype);
        System.out.println("Construyendo url: " + sbuilder.toString());
        URL url = new URL(sbuilder.toString());
        return url;
    }

    private boolean fetchSequence(URL url, String term, String outputFolder) {
        DecimalFormat format = new DecimalFormat("000000");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
            int counter = 0;
            File output = new File(outputFolder + File.separator + term + "_" + format.format(counter) + ".fa");
            while (output.exists()) {
                output = new File(outputFolder + File.separator + term + "_" + format.format(++counter) + ".fa");
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(output));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            finally {
                reader.close();
                writer.close();
            }
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }
}

