/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model;

import com.biotechvana.csveditor.model.CsvRecord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CsvParser {
    private File csvFile;
    private List<CsvRecord> records;
    private final char ESCAPE_CHAR = (char)92;
    private final boolean debug = true;
    private boolean parsed = false;

    public CsvParser(File csvFile) {
        this.csvFile = csvFile;
        this.records = new ArrayList<CsvRecord>();
    }

    public boolean parse(char fieldSeparator, char fieldDelimiter, int queryColumn) {
        int offset = 0;
        int length = 0;
        StringBuilder buffer = new StringBuilder();
        boolean delimiterOpen = false;
        double startTime = System.currentTimeMillis();
        int countLine = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));){
            int c;
            int previousChar = 10;
            int countField = 0;
            while ((c = reader.read()) != -1) {
                ++length;
                char currentChar = (char)c;
                if (currentChar == '\n') {
                    CsvRecord newRecord = new CsvRecord(countLine, buffer.toString(), offset, length);
                    int insertionIndex = Collections.binarySearch(this.records, newRecord);
                    if (insertionIndex < 0) {
                        this.records.add(-insertionIndex - 1, newRecord);
                    } else {
                        this.records.add(insertionIndex, newRecord);
                    }
                    offset += length;
                    length = 0;
                    buffer = new StringBuilder();
                    delimiterOpen = false;
                    countField = 0;
                    ++countLine;
                } else if (currentChar == fieldDelimiter) {
                    if (previousChar != 92) {
                        delimiterOpen = !delimiterOpen;
                    }
                } else if (currentChar == fieldSeparator) {
                    if (!delimiterOpen) {
                        ++countField;
                    }
                } else if (countField == queryColumn) {
                    buffer.append(currentChar);
                }
                previousChar = currentChar;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        double endTime = System.currentTimeMillis();
        System.out.println("CSV file parsed in: " + (endTime - startTime) + " ms");
        this.parsed = true;
        return true;
    }

    public List<CsvRecord> getRecords() throws CSVParserDocumentNotParsed {
        if (!this.isParsed()) {
            throw new CSVParserDocumentNotParsed();
        }
        return this.records;
    }

    /*
     * Unable to fully structure code
     */
    public List<CsvRecord> getRecords(String key) throws CSVParserDocumentNotParsed {
        if (!this.isParsed()) {
            throw new CSVParserDocumentNotParsed();
        }
        startIndex = -1;
        endIndex = -1;
        subList = new ArrayList<CsvRecord>();
        keyRecord = new CsvRecord(0, key, 0L, 0);
        index = Collections.binarySearch(this.records, keyRecord);
        if (index >= 0) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            --index;
lbl11:
            // 2 sources

            ** while (index >= 0 && this.records.get((int)index).getQuery().equals((Object)key))
        }
lbl12:
        // 1 sources

        startIndex = ++index;
        while (index < this.records.size() && this.records.get(index).getQuery().equals(key)) {
            ++index;
        }
        endIndex = --index;
        i = startIndex;
        while (i <= endIndex) {
            subList.add(this.records.get(i));
            ++i;
        }
        return subList;
    }

    public String getLine(CsvRecord csvRecord) throws CSVParserDocumentNotParsed {
        String string;
        if (!this.isParsed()) {
            throw new CSVParserDocumentNotParsed();
        }
        long startTime = System.currentTimeMillis();
        RandomAccessFile raf = new RandomAccessFile(this.csvFile, "r");
        try {
            raf.seek(csvRecord.getOffset());
            byte[] buffer = new byte[csvRecord.getLength()];
            raf.read(buffer);
            long endTime = System.currentTimeMillis();
            System.out.println("Line extracted in " + (endTime - startTime) + "ms");
            string = new String(buffer);
        }
        catch (Throwable throwable) {
            try {
                raf.close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        raf.close();
        return string;
    }

    public List<List<String>> getListRows(List<CsvRecord> listRecords, char fieldSeparator, char fieldDelimiter, boolean appendIndex) {
        Collections.sort(listRecords, new Comparator<CsvRecord>(){

            @Override
            public int compare(CsvRecord o1, CsvRecord o2) {
                return o1.getId() - o2.getId();
            }
        });
        String[] selectedLines = this.getLines(listRecords.toArray(new CsvRecord[listRecords.size()]));
        ArrayList<List<String>> listRows = new ArrayList<List<String>>();
        int i = 0;
        while (i < selectedLines.length) {
            List<String> row = this.readCsvLine(selectedLines[i], fieldSeparator, fieldDelimiter);
            if (appendIndex) {
                row.add(0, String.valueOf(listRecords.get(i).getId()));
            }
            listRows.add(row);
            ++i;
        }
        return listRows;
    }

    public String[] getLines(CsvRecord[] csvRecords) {
        String[] stringArray;
        long startTime = System.currentTimeMillis();
        ArrayList<String> lines = new ArrayList<String>();
        RandomAccessFile raf = new RandomAccessFile(this.csvFile, "r");
        try {
            CsvRecord[] csvRecordArray = csvRecords;
            int n = csvRecords.length;
            int n2 = 0;
            while (n2 < n) {
                CsvRecord record = csvRecordArray[n2];
                raf.seek(record.getOffset());
                byte[] buffer = new byte[record.getLength()];
                raf.read(buffer);
                lines.add(new String(buffer));
                ++n2;
            }
            long endTime = System.currentTimeMillis();
            System.out.println("Line extracted in " + (endTime - startTime) + "ms");
            stringArray = lines.toArray(new String[lines.size()]);
        }
        catch (Throwable throwable) {
            try {
                raf.close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        raf.close();
        return stringArray;
    }

    public String[] getLines(String key) throws CSVParserDocumentNotParsed {
        String[] stringArray;
        long startTime = System.currentTimeMillis();
        List<CsvRecord> subList = this.getRecords(key);
        ArrayList<String> output = new ArrayList<String>();
        long endTime = 0L;
        if (subList == null) {
            return null;
        }
        RandomAccessFile raf = new RandomAccessFile(this.csvFile, "r");
        try {
            raf.seek(raf.length());
            for (CsvRecord rec : subList) {
                byte[] buffer = new byte[rec.getLength()];
                raf.seek(rec.getOffset());
                int charsRead = raf.read(buffer);
                if (charsRead <= 0) continue;
                output.add(new String(buffer).trim());
            }
            endTime = System.currentTimeMillis();
            System.out.println(output.size() + " lines read in " + (endTime - startTime) + "ms");
            stringArray = output.toArray(new String[output.size()]);
        }
        catch (Throwable throwable) {
            try {
                raf.close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        raf.close();
        return stringArray;
    }

    public List<String> readCsvLine(String csvLine, char fieldSeparator, char fieldDelimiter) {
        ArrayList<String> listFields = new ArrayList<String>();
        int lineLength = csvLine.length();
        boolean delimiterOpen = false;
        StringBuilder sBuilder = new StringBuilder();
        int i = 0;
        while (i < lineLength) {
            if (csvLine.charAt(i) == fieldDelimiter) {
                if (i > 0) {
                    if (csvLine.charAt(i - 1) == '\\') {
                        sBuilder.append(csvLine.charAt(i));
                    } else {
                        delimiterOpen = !delimiterOpen;
                    }
                }
            } else if (csvLine.charAt(i) == fieldSeparator && delimiterOpen) {
                listFields.add(sBuilder.toString());
                sBuilder = new StringBuilder();
            } else {
                sBuilder.append(csvLine.charAt(i));
            }
            ++i;
        }
        if (csvLine.charAt(lineLength - 1) != fieldSeparator) {
            listFields.add(sBuilder.toString());
        }
        return listFields;
    }

    public void sortByIndex() {
        Collections.sort(this.records, new Comparator<CsvRecord>(){

            @Override
            public int compare(CsvRecord o1, CsvRecord o2) {
                return o1.getId() - o2.getId();
            }
        });
    }

    public void sortByKey() {
        Collections.sort(this.records, new Comparator<CsvRecord>(){

            @Override
            public int compare(CsvRecord o1, CsvRecord o2) {
                return o1.getQuery().compareTo(o2.getQuery());
            }
        });
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public class CSVParserDocumentNotParsed
    extends Exception {
        private static final long serialVersionUID = 4453603902828709488L;
    }
}

