/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model.CsvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.editors.CSVEditorInput;
import com.biotechvana.csveditor.jobs.csvEditor.CSVEditorSaveDocumentRunnable;
import com.biotechvana.csveditor.jobs.csvEditor.CsvColumnSelectionListener;
import com.biotechvana.csveditor.jobs.csvEditor.CsvExportModelRunnable;
import com.biotechvana.csveditor.model.CsvEditor.CsvCombineWorksheets;
import com.biotechvana.csveditor.model.CsvEditor.CsvModifiedRecord;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionColumnHide;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionRowAdd;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionRowEdit;
import com.biotechvana.csveditor.model.WorksheetXmlManager;
import com.biotechvana.e3utils.WorkspaceUtils;
import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import com.biotechvana.utils.PreferenceManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewPart;
import org.xml.sax.SAXException;

public class CsvEditorUtils2 {
    private CSVEditor csvEditor;
    private int selectColorCount = 0;
    private int[] relationIndices;
    private boolean debug = false;

    public CsvEditorUtils2(CSVEditor csvEditor) {
        this.csvEditor = csvEditor;
        this.debug = csvEditor.getDebug();
    }

    public void replace(String regexp, String replacement, int column, int rowIndex) throws PatternSyntaxException {
        ArrayList row = (ArrayList)this.csvEditor.getTableViewer().getElementAt(rowIndex);
        String cellText = (String)row.get(column);
        row.set(column, cellText.replaceAll(regexp, replacement));
        this.csvEditor.getTableViewer().update((Object)row, null);
        int fastaRowIndex = -1;
        int fastaColIndex = -1;
        this.csvEditor.getListModifiedRecords().add(new CsvModifiedRecord(Integer.parseInt((String)row.get(1)) - 1, column, fastaRowIndex, fastaColIndex, cellText, (String)row.get(column)));
        this.csvEditor.getListActions().add(new CsvActionRowEdit(Integer.parseInt((String)row.get(1)) - 1, column, cellText, (String)row.get(column)));
        if (this.debug) {
            System.out.println("Replacing '" + cellText + "' with '" + replacement + "'");
        }
        this.csvEditor.setAsModified();
    }

    public void replace(int indice) {
        this.csvEditor.getTable().deselectAll();
        this.csvEditor.getTable().select(indice);
    }

    public void selectColumn(int indice) {
        this.csvEditor.getTable().deselectAll();
        this.csvEditor.getTable().select(indice);
    }

    public List<Integer> filterByColumnInformation(int column, boolean empty) {
        int rowCount = this.csvEditor.getTable().getItemCount();
        ArrayList<Integer> listIndices = new ArrayList<Integer>();
        int i = 0;
        while (i < rowCount) {
            String cellValue = this.csvEditor.getTable().getItem(i).getText(column).replace(',', '.');
            if (empty) {
                if (cellValue.isEmpty() || cellValue.equals("--UD--")) {
                    listIndices.add(i);
                }
            } else if (!cellValue.isEmpty() && !cellValue.equals("--UD--")) {
                listIndices.add(i);
            }
            ++i;
        }
        return listIndices;
    }

    public int getSelectColorCount() {
        return this.selectColorCount;
    }

    public int[] getAssociationIndices() {
        return this.relationIndices;
    }

    public static String formatDoubleValue(String value) {
        if (value == null) {
            return null;
        }
        String format = value.replace(",", ".");
        return format.toUpperCase();
    }

    public int detectDataType(int columnIndex) throws PatternSyntaxException, IndexOutOfBoundsException {
        String pattern = "(?i).*[abcdfghijklmnopqrstuvwxyz].*";
        for (ArrayList row : (ArrayList)this.csvEditor.getModel()) {
            if (!((String)row.get(columnIndex)).matches("(?i).*[abcdfghijklmnopqrstuvwxyz].*")) continue;
            return CSVEditor.COLUMN_TYPE_ALPHA;
        }
        return CSVEditor.COLUMN_TYPE_NUMERIC;
    }

    public boolean isColumnInteger(int columnIndex) {
        try {
            for (List row : (ArrayList)this.csvEditor.getModel()) {
                if (((String)row.get(columnIndex)).trim().isEmpty()) continue;
                Integer.parseInt((String)row.get(columnIndex));
            }
        }
        catch (NumberFormatException exception) {
            return false;
        }
        return true;
    }

    public boolean isColumnDouble(int columnIndex) {
        try {
            for (List row : (ArrayList)this.csvEditor.getModel()) {
                if (((String)row.get(columnIndex)).trim().isEmpty()) continue;
                Double.parseDouble((String)row.get(columnIndex));
            }
        }
        catch (NumberFormatException exception) {
            return false;
        }
        return true;
    }

    public int hasAlphabeticalValuesInColumn(int columnIndex) throws PatternSyntaxException, IndexOutOfBoundsException {
        String pattern = "(?i).*[abcdfghijklmnopqrstuvwxyz].*";
        int counter = 0;
        for (ArrayList row : (ArrayList)this.csvEditor.getModel()) {
            if (((String)row.get(columnIndex)).matches("(?i).*[abcdfghijklmnopqrstuvwxyz].*")) {
                System.out.println("Hace match en: " + (String)row.get(columnIndex));
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    public void exportModel(List<Integer> rowIndices, List<Integer> columnIndices, List<String> columnNames, File outputFile) throws InvocationTargetException, InterruptedException {
        File multihit = this.csvEditor.getMultiHitFile();
        String comments = null;
        if (multihit != null) {
            comments = "#multihit=" + multihit.getAbsolutePath();
        }
        CsvExportModelRunnable runnable = new CsvExportModelRunnable((List)this.csvEditor.getModel(), rowIndices, columnNames, columnIndices, outputFile, comments);
        new ProgressMonitorDialog(this.csvEditor.getSite().getShell()).run(true, true, (IRunnableWithProgress)runnable);
    }

    public void exportModel(List<Integer> rowIndices, List<Integer> columnIndices, List<String> columnNames, int[] listAssociationColumnIndices, String associationSeparator, List<String> listMatchingNames, File outputFile) throws InvocationTargetException, InterruptedException {
        File multihit = this.csvEditor.getMultiHitFile();
        String comments = null;
        if (multihit != null) {
            comments = "#multihit=" + multihit.getAbsolutePath();
        }
        CsvExportModelRunnable runnable = new CsvExportModelRunnable((List)this.csvEditor.getModel(), rowIndices, columnNames, columnIndices, listAssociationColumnIndices, associationSeparator, listMatchingNames, outputFile, comments);
        new ProgressMonitorDialog(this.csvEditor.getSite().getShell()).run(true, true, (IRunnableWithProgress)runnable);
    }

    public List<Integer> getColumnOrderAsList() {
        ArrayList<Integer> listColumnIndices = new ArrayList<Integer>();
        int[] nArray = this.csvEditor.getTable().getColumnOrder();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int co = nArray[n2];
            listColumnIndices.add(co);
            ++n2;
        }
        return listColumnIndices;
    }

    public int[] getColumnOrderAsArray() {
        return this.csvEditor.getTable().getColumnOrder();
    }

    public String[] getColumnNamesAsArray(boolean ignoreFirst, boolean ignoreUnchecked, boolean ignoreInvisible) {
        List<String> listNames = this.getColumnNamesAsList(ignoreFirst, ignoreUnchecked, ignoreInvisible);
        return listNames.toArray(new String[listNames.size()]);
    }

    public List<String> getColumnNamesAsList(boolean ignoreFirst, boolean ignoreUnchecked, boolean ignoreInvisible) {
        ArrayList<String> columnNames = new ArrayList<String>();
        TableColumn[] tableColumns = this.csvEditor.getTable().getColumns();
        List<Integer> listIndices = this.getColumnIndicesAsList(ignoreFirst, ignoreUnchecked, ignoreInvisible);
        for (int li : listIndices) {
            columnNames.add(tableColumns[li].getText());
        }
        return columnNames;
    }

    public int[] getColumnIndicesAsArray(List<String> columnNames) {
        return this.getColumnIndicesAsArray(columnNames.toArray(new String[columnNames.size()]));
    }

    public int[] getColumnIndicesAsArray(String[] columnNames) {
        List<Integer> listIndices = this.getColumnIndicesAsList(columnNames);
        int[] arrayIndices = new int[listIndices.size()];
        int i = 0;
        while (i < listIndices.size()) {
            arrayIndices[i] = listIndices.get(i);
            ++i;
        }
        return arrayIndices;
    }

    public List<Integer> getColumnIndicesAsList(List<String> columnNames) {
        return this.getColumnIndicesAsList(columnNames.toArray(new String[columnNames.size()]));
    }

    public List<Integer> getColumnIndicesAsList(String[] columnNames) {
        Object[] sortedNames = (String[])columnNames.clone();
        ArrayList<Integer> listIndices = new ArrayList<Integer>();
        Arrays.sort(sortedNames);
        TableColumn[] tableColumns = this.csvEditor.getTable().getColumns();
        int[] columnOrder = this.csvEditor.getTable().getColumnOrder();
        int i = 0;
        while (i < columnOrder.length) {
            int res;
            if (columnOrder[i] > 1 && (res = Arrays.binarySearch(sortedNames, tableColumns[columnOrder[i]].getText())) >= 0) {
                listIndices.add(columnOrder[i]);
            }
            ++i;
        }
        return listIndices;
    }

    public int[] getColumnIndicesAsArray(boolean ignoreFirst, boolean ignoreUnchecked, boolean ignoreInvisible) {
        List<Integer> columnIndices = this.getColumnIndicesAsList(ignoreFirst, ignoreUnchecked, ignoreInvisible);
        int[] arrayIndices = new int[columnIndices.size()];
        int i = 0;
        while (i < columnIndices.size()) {
            arrayIndices[i] = columnIndices.get(i);
            ++i;
        }
        return arrayIndices;
    }

    public List<Integer> getColumnIndicesAsList(boolean ignoreFirst, boolean ignoreUnchecked, boolean ignoreInvisible) {
        ArrayList<Integer> listIndices = new ArrayList<Integer>();
        int[] columnOrder = this.getColumnOrderAsArray();
        TableColumn[] tableColumns = this.csvEditor.getTable().getColumns();
        int[] nArray = columnOrder;
        int n = columnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int co = nArray[n2];
            String columnName = tableColumns[co].getText();
            boolean visible = true;
            if (tableColumns[co].getWidth() == 0) {
                visible = false;
            }
            boolean checked = false;
            Image colImage = tableColumns[co].getImage();
            if (colImage != null && colImage.equals((Object)CSVEditor.CHECK_ENABLED)) {
                checked = true;
            }
            if (co == 1 && !ignoreUnchecked) {
                checked = true;
            }
            boolean write = true;
            if (ignoreFirst && (co == 0 || co == 1)) {
                write = false;
            }
            if (ignoreUnchecked && !checked) {
                write = false;
            }
            if (ignoreInvisible && !visible) {
                write = false;
            }
            if (columnName.startsWith("!@_")) {
                write = false;
            }
            if (write) {
                listIndices.add(co);
            }
            ++n2;
        }
        return listIndices;
    }

    public static boolean createEmptyWorksheetTemplate(File newFile) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(newFile, false));){
            String[] stringArray = CSVEditorInput.DEFAULT_FIELDS;
            int n = CSVEditorInput.DEFAULT_FIELDS.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                bw.append("\"" + field + "\";");
                ++n2;
            }
            bw.newLine();
            int i = 0;
            while (i < 100) {
                int j = 0;
                while (j < CSVEditorInput.DEFAULT_FIELDS.length) {
                    bw.append("\"\";");
                    ++j;
                }
                bw.newLine();
                ++i;
            }
            return true;
        }
    }

    public void fitToContent(int column) throws Exception {
        try {
            GC gc = new GC((Drawable)this.csvEditor.getTable());
            gc.setFont(this.csvEditor.getTable().getItem(column).getFont());
            int rowCount = this.csvEditor.getTable().getItemCount();
            int width = gc.stringExtent((String)this.csvEditor.getTable().getColumn((int)column).getText()).x + 20;
            gc.setFont(this.csvEditor.getTable().getFont());
            int i = 0;
            while (i < rowCount) {
                String cellValue = this.csvEditor.getTable().getItem(i).getText(column);
                int widthRow = gc.stringExtent((String)cellValue).x;
                if (width < widthRow) {
                    width = widthRow;
                }
                ++i;
            }
            this.csvEditor.getTable().getColumn(column).setWidth(width + 14);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    public int hideColumns(List<String> columnNames) {
        int countAffectedRows = 0;
        long timestamp = System.currentTimeMillis();
        Collections.sort(columnNames);
        TableColumn[] columns = this.csvEditor.getTable().getColumns();
        int i = 2;
        while (i < columns.length) {
            int res = Collections.binarySearch(columnNames, columns[i].getText());
            if (res >= 0) {
                this.csvEditor.getListActions().add(new CsvActionColumnHide(i, this.csvEditor.getTable().getColumn(i).getWidth(), timestamp));
                columns[i].setWidth(0);
                columns[i].setImage(CSVEditor.CHECK_DISABLED);
                ++countAffectedRows;
            } else if (!columns[i].getText().startsWith("!@_")) {
                columns[i].setWidth(100);
            }
            ++i;
        }
        return countAffectedRows;
    }

    public int hideColumns(String[] columnNames) {
        List<String> listNames = Arrays.asList(columnNames);
        return this.hideColumns(listNames);
    }

    public void addRows(TableViewer tViewer, int insertionIndex, int numRows) {
        ArrayList model = (ArrayList)this.csvEditor.getModel();
        long timestamp = System.currentTimeMillis();
        int c = 0;
        while (c < numRows) {
            ArrayList<String> newRow = new ArrayList<String>();
            int i = 0;
            while (i < ((ArrayList)model.get(0)).size()) {
                newRow.add("");
                ++i;
            }
            model.add(insertionIndex + 1, newRow);
            this.csvEditor.getListActions().add(new CsvActionRowAdd(insertionIndex + 1, timestamp));
            ++c;
        }
        int i = 0;
        while (i < model.size()) {
            ((ArrayList)model.get(i)).set(1, String.valueOf(i + 1));
            ++i;
        }
        this.csvEditor.getTableViewer().refresh();
    }

    public int getEvalueColumn() {
        TableColumn[] tableColumns = this.csvEditor.getTable().getColumns();
        int i = 0;
        while (i < tableColumns.length) {
            String name = tableColumns[i].getText();
            if (name.equalsIgnoreCase("e-value") || name.equalsIgnoreCase("evalue") || name.equalsIgnoreCase("e")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Point combineWorksheets(String masterFile, String relatedFile, int masterKeyColumnIndex, int relatedKeyColumnIndex, int[] masterExportColumnIndices, int[] relatedExportColumnIndices, boolean masterHasHeader, boolean relatedHasHeader, String outputFile, String[] combinedColumnNames) {
        CsvCombineWorksheets ccw = new CsvCombineWorksheets(masterFile, relatedFile);
        Point associationCount = ccw.combine(masterKeyColumnIndex, relatedKeyColumnIndex, masterExportColumnIndices, relatedExportColumnIndices, masterHasHeader, relatedHasHeader, outputFile, combinedColumnNames);
        return associationCount;
    }

    public void printModel() {
        List model = (List)this.csvEditor.getModel();
        for (List row : model) {
            System.out.print("[" + row.size() + "]");
            for (String col : row) {
                System.out.print(col + " # ");
            }
            System.out.println("");
        }
    }

    public void printModel(List<List<String>> model) {
        for (List<String> row : model) {
            System.out.print("[" + row.size() + "]");
            for (String col : row) {
                System.out.print(col + " # ");
            }
            System.out.println("");
        }
    }

    public void refreshTableViewerColumnListeners() {
        TableColumn[] tableColumns = this.csvEditor.getTableViewer().getTable().getColumns();
        for (CsvColumnSelectionListener l : this.csvEditor.getListColumnListeners()) {
            try {
                l.getTableViewerColumn().getColumn().removeSelectionListener((SelectionListener)l);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.csvEditor.getListColumnListeners().clear();
        int i = 0;
        while (i < tableColumns.length) {
            TableColumn tableColumn = tableColumns[i];
            TableViewerColumn tvc = (TableViewerColumn)tableColumn.getData("org.eclipse.jface.columnViewer");
            CsvColumnSelectionListener columnListener = new CsvColumnSelectionListener(this.csvEditor, tvc, i);
            tvc.getColumn().addSelectionListener((SelectionListener)columnListener);
            this.csvEditor.getListColumnListeners().add(columnListener);
            ++i;
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (((CSVEditorInput)this.csvEditor.getEditorInput()).isTemporary()) {
            this.csvEditor.doSaveAs();
        }
        CSVEditorSaveDocumentRunnable saveRunnable = new CSVEditorSaveDocumentRunnable(this.csvEditor, this.csvEditor.getCsvFile(), ';', '\"');
        try {
            new ProgressMonitorDialog(this.csvEditor.getSite().getShell()).run(true, true, (IRunnableWithProgress)saveRunnable);
            IViewPart viewPart = WorkspaceUtils.findView((String)FileExplorerBasic.ID);
            if (viewPart != null) {
                FileExplorerBasic fileExplorer = (FileExplorerBasic)viewPart;
                fileExplorer.getFileViewer().refresh((Object)this.csvEditor.getCsvFile());
            }
            this.csvEditor.getListModifiedRecords().clear();
            this.csvEditor.setModified(false);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void doSaveAs() {
        CSVEditorInput editorInput = (CSVEditorInput)this.csvEditor.getEditorInput();
        FileDialog dialog = new FileDialog(this.csvEditor.getSite().getShell(), 8192);
        dialog.setText("Save as...");
        dialog.setFileName(this.csvEditor.getCsvFile().getName());
        String prefSaveLocation = this.csvEditor.getCsvFile().getParent();
        String[] extensionFilter = new String[]{".csv", "*.*"};
        String[] nameFilter = new String[]{"Comma separated value (CSV)", "All files"};
        dialog.setFilterNames(nameFilter);
        dialog.setFilterExtensions(extensionFilter);
        if (prefSaveLocation == null || prefSaveLocation.isEmpty()) {
            dialog.setFilterPath(PreferenceManager.getInstance().get("workspace", ""));
        } else {
            dialog.setFilterPath(prefSaveLocation);
        }
        Object res = dialog.open();
        if (res != null && !((String)res).endsWith(".csv")) {
            res = (String)res + ".csv";
        }
        if (res == null) {
            System.err.println("File not selected");
            return;
        }
        CSVEditorSaveDocumentRunnable saveDocumentRunnable = new CSVEditorSaveDocumentRunnable(this.csvEditor, new File((String)res), ';', '\"');
        try {
            new ProgressMonitorDialog(this.csvEditor.getSite().getShell()).run(true, true, (IRunnableWithProgress)saveDocumentRunnable);
        }
        catch (InvocationTargetException e1) {
            if (this.csvEditor.getDebug()) {
                e1.printStackTrace();
            }
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        IViewPart viewPart = WorkspaceUtils.findView((String)FileExplorerBasic.ID);
        if (viewPart != null) {
            FileExplorerBasic fileExplorer = (FileExplorerBasic)viewPart;
            fileExplorer.updateInput();
        }
        this.csvEditor.setModified(false);
        if (editorInput.isTemporary()) {
            editorInput.getInputFile().deleteOnExit();
            editorInput.setTemporary(false);
        }
        this.csvEditor.setCsvFile(new File((String)res));
        editorInput.setInputFile(new File((String)res));
        this.csvEditor.changePartName(FilenameUtils.getName((String)res));
    }

    public boolean saveXmlAssociation(String csvPath, String fastaPath, int[] associationColumnIndices, String columnSeparator) throws ParserConfigurationException, SAXException, IOException {
        WorksheetXmlManager wxm = new WorksheetXmlManager();
        int o = wxm.getIndexForWorksheetFile(csvPath);
        if (o == -1) {
            try {
                wxm.addSite(csvPath, fastaPath, associationColumnIndices, columnSeparator);
                o = wxm.getIndexForWorksheetFile(csvPath);
            }
            catch (Exception e) {
                if (this.debug) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        try {
            wxm.deleteSite(csvPath);
            wxm.addSite(csvPath, fastaPath, associationColumnIndices, columnSeparator);
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public int renameColumn(String oldName, String newName) {
        int renameCounter = 0;
        TableColumn[] tableColumns = this.csvEditor.getTable().getColumns();
        int i = 0;
        while (i < tableColumns.length) {
            if (tableColumns[i].getText().equals(oldName)) {
                tableColumns[i].setText(newName);
                ++renameCounter;
            }
            ++i;
        }
        return renameCounter;
    }
}

