/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model.CsvEditor;

import com.biotechvana.csvUtils.CsvBufferedReader;
import com.biotechvana.csvUtils.CsvWriter;
import com.biotechvana.utils.FilenameUtils;
import com.biotechvana.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvEditorCombineWorksheetMultipleRunnable
implements IRunnableWithProgress {
    private File fileMaster;
    private File[] filesRelated;
    private int keyMasterColumnIndex;
    private int keyRelatedColumnIndex;
    private int[] masterExportColumnIndices;
    private int[] relatedExportColumnIndices;
    private File outputDirectory;
    private char separator;
    private char quotes;
    private List<List<String>> modelMaster;
    private List<String> modelMasterKey;
    private List<String> listHeaderMaster;

    public static void main(String[] args) {
        CsvEditorCombineWorksheetMultipleRunnable runnable = new CsvEditorCombineWorksheetMultipleRunnable(new File("/home/rfutami/Escritorio/combinado/master/master.csv"), new File[]{new File("/home/rfutami/Escritorio/combinado/related/01.csv"), new File("/home/rfutami/Escritorio/combinado/related/02.csv"), new File("/home/rfutami/Escritorio/combinado/related/03.csv")}, 0, 0, new int[]{1}, new int[]{1}, new File("/home/rfutami/Escritorio/combinado/output"), ';', '\"');
        ArrayList<String> row = new ArrayList<String>();
        row.add("uno");
        row.add("dos");
        row.add("tres");
        row.add("cuatro");
        row.add("cinco");
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        List<String> selection = runnable.getValuesForIndices(row, nArray, 3);
        System.out.println("selected: " + Arrays.toString(selection.toArray(new String[selection.size()])));
    }

    public CsvEditorCombineWorksheetMultipleRunnable(File fileMaster, File[] filesRelated, int keyMasterColumnIndex, int keyRelatedColumnIndex, int[] masterExportColumnIndices, int[] relatedExportColumnIndices, File outputDirectory, char separator, char quotes) {
        this.fileMaster = fileMaster;
        this.filesRelated = filesRelated;
        this.keyMasterColumnIndex = keyMasterColumnIndex;
        this.keyRelatedColumnIndex = keyRelatedColumnIndex;
        this.masterExportColumnIndices = masterExportColumnIndices;
        this.relatedExportColumnIndices = relatedExportColumnIndices;
        this.outputDirectory = outputDirectory;
        this.separator = separator;
        this.quotes = quotes;
    }

    private void printModel() {
        for (List<String> row : this.modelMaster) {
            System.out.println(StringUtils.join(row, (String)";"));
        }
    }

    private void readRelatedFile(File fileRelated, char separator, char quotes) throws IOException {
        CsvBufferedReader reader = new CsvBufferedReader(fileRelated, separator, quotes);
        List<String> row = new ArrayList();
        row = reader.readLine();
        List<String> listHeaders = this.getValuesForIndices(row, this.relatedExportColumnIndices, this.keyRelatedColumnIndex);
        int i = 0;
        while (i < listHeaders.size()) {
            listHeaders.set(i, listHeaders.get(i) + " (" + FilenameUtils.getBasename((String)fileRelated.getName()) + ")");
            ++i;
        }
        this.listHeaderMaster.addAll(listHeaders);
        HashMap<String, List<String>> mapRows = new HashMap<String, List<String>>();
        while ((row = reader.readLine()) != null) {
            String key = (String)row.get(this.keyRelatedColumnIndex);
            List<String> listValues = this.getValuesForIndices(row, this.relatedExportColumnIndices, this.keyRelatedColumnIndex);
            mapRows.put(key, listValues);
        }
        reader.close();
        int i2 = 0;
        while (i2 < this.modelMaster.size()) {
            List<String> masterRow = this.modelMaster.get(i2);
            String key = this.modelMasterKey.get(i2);
            if (mapRows.containsKey(key)) {
                masterRow.addAll((Collection)mapRows.get(key));
            } else {
                masterRow.addAll(this.createBlankRow(listHeaders.size()));
            }
            ++i2;
        }
    }

    private List<String> createBlankRow(int len) {
        ArrayList<String> row = new ArrayList<String>(len);
        int i = 0;
        while (i < len) {
            row.add("");
            ++i;
        }
        return row;
    }

    private List<String> getValuesForIndices(List<String> row, int[] indices) {
        return this.getValuesForIndices(row, indices, -1);
    }

    private List<String> getValuesForIndices(List<String> row, int[] indices, int excludeIndex) {
        ArrayList<String> listValues = new ArrayList<String>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (excludeIndex == -1 || i != excludeIndex) {
                listValues.add(row.get(i));
            }
            ++n2;
        }
        return listValues;
    }

    private void loadDocumentInMemory(File fileCsv, char separator, char quotes) throws IOException {
        this.modelMaster = new ArrayList<List<String>>();
        this.modelMasterKey = new ArrayList<String>();
        List<String> row = new ArrayList();
        CsvBufferedReader reader = new CsvBufferedReader(fileCsv, separator, quotes);
        row = reader.readLine();
        String keyName = (String)row.get(this.keyMasterColumnIndex);
        List<String> selectedNames = this.getValuesForIndices(row, this.masterExportColumnIndices, -1);
        this.listHeaderMaster = new ArrayList<String>();
        this.listHeaderMaster.addAll(selectedNames);
        while ((row = reader.readLine()) != null) {
            String key = row.get(this.keyMasterColumnIndex);
            List<String> masterRow = this.getValuesForIndices(row, this.masterExportColumnIndices, -1);
            ArrayList<String> exportRow = new ArrayList<String>();
            exportRow.addAll(masterRow);
            this.modelMaster.add(exportRow);
            this.modelMasterKey.add(key);
        }
        reader.close();
    }

    private void writeOutputFile() throws IOException {
        String basename = FilenameUtils.getBasename((String)this.fileMaster.getName());
        File newOutputFile = new File(String.valueOf(this.outputDirectory) + "/" + basename + "_combined.csv");
        CsvWriter writer = new CsvWriter(newOutputFile, this.separator, this.quotes);
        writer.write(this.listHeaderMaster);
        for (List<String> row : this.modelMaster) {
            writer.write(row);
        }
        writer.close();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Combine worksheets", 2 + this.filesRelated.length);
        try {
            monitor.subTask("Parsing combine file");
            try {
                monitor.subTask("Reading master file: " + this.fileMaster.getName());
                this.loadDocumentInMemory(this.fileMaster, this.separator, this.quotes);
                monitor.worked(1);
                File[] fileArray = this.filesRelated;
                int n = this.filesRelated.length;
                int n2 = 0;
                while (n2 < n) {
                    File fr = fileArray[n2];
                    monitor.subTask("Reading file: " + fr.getName());
                    this.readRelatedFile(fr, this.separator, this.quotes);
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    ++n2;
                }
                monitor.subTask("Writing output file");
                this.writeOutputFile();
                monitor.worked(1);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }
}

