/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model.CsvEditor;

import com.biotechvana.csveditor.model.CSVUtils;
import com.biotechvana.csveditor.model.CsvEditor.LineOffset;
import com.biotechvana.csveditor.model.CsvEditor.WorksheetRelation;
import com.biotechvana.e3utils.WorkspaceUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class CsvCombineWorksheets {
    private final boolean DEBUG = true;
    private final char FIELD_SEPARATOR = (char)59;
    private final char FIELD_DELIMITER = (char)34;
    private final int BUFFER_SIZE = 524288;
    private String worksheetMaster;
    private String worksheetRelated;
    private File combineFile;

    public CsvCombineWorksheets(String worksheet1, String worksheet2) {
        this.worksheetMaster = worksheet1;
        this.worksheetRelated = worksheet2;
    }

    public Point combine(int masterIndex, int relatedIndex, int[] masterSelection, int[] relatedSelection, boolean masterHasHeader, boolean relatedHasHeader, String outputPath, String[] columnNames) {
        int totalCounter = 0;
        int notFoundCounter = 0;
        try {
            this.combineFile = File.createTempFile("combine", ".csv");
            List<WorksheetRelation> relations = this.getMasterFileIndices(masterIndex, masterHasHeader);
            totalCounter = relations.size();
            List<WorksheetRelation> relationsFiltered = relations = this.getRelatedIndices(relatedIndex, relatedHasHeader, relations);
            this.exportMasterSelectionAll(relationsFiltered, masterIndex, masterHasHeader, masterSelection, outputPath);
            List<LineOffset> listOffsets = this.parseRelatedWorksheet(this.worksheetRelated, relatedHasHeader);
            notFoundCounter = this.exportRelatedSelection(outputPath, this.worksheetRelated, relationsFiltered, listOffsets, relatedIndex, relatedHasHeader, relatedSelection, this.combineFile.getAbsolutePath(), columnNames);
            if (notFoundCounter == -1) {
                MessageDialog.openWarning((Shell)WorkspaceUtils.getShell(), (String)"Combine worksheets", (String)"Failed combining worksheets");
            } else {
                this.replaceTemp(outputPath, this.combineFile.getAbsolutePath());
            }
            return new Point(totalCounter, notFoundCounter);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<WorksheetRelation> filterNotAsociatedInMaster(List<WorksheetRelation> relations) {
        ArrayList<WorksheetRelation> relationsFiltered = new ArrayList<WorksheetRelation>();
        try {
            int i = 0;
            while (i < relations.size()) {
                if (relations.get(i).getIndexRelated() != -1) {
                    relationsFiltered.add(relations.get(i));
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return relationsFiltered;
    }

    private boolean replaceTemp(String destinationFile, String tempFile) {
        try {
            BufferedReader bReader = new BufferedReader(new FileReader(tempFile));
            BufferedWriter bWriter = new BufferedWriter(new FileWriter(destinationFile));
            try {
                String line;
                while ((line = bReader.readLine()) != null) {
                    bWriter.append(line);
                    bWriter.newLine();
                }
            }
            finally {
                bReader.close();
                bWriter.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private List<LineOffset> parseRelatedWorksheet(String worksheetRelated, boolean relatedHasHeader) {
        String encoding = System.getProperty("file.encoding");
        Charset fileCharset = Charset.forName(encoding);
        long fileCharOffset = 0L;
        boolean lineStart = true;
        int c = 10;
        ArrayList<LineOffset> listOffsets = new ArrayList<LineOffset>();
        int lineCount = 0;
        try {
            ByteBuffer bBuffer = ByteBuffer.allocate(524288);
            try (FileChannel inFC = new FileInputStream(worksheetRelated).getChannel();){
                while (inFC.read(bBuffer) != -1) {
                    bBuffer.flip();
                    CharBuffer cBuffer = fileCharset.decode(bBuffer);
                    bBuffer.clear();
                    while (cBuffer.hasRemaining()) {
                        int previousChar = c;
                        c = cBuffer.get();
                        ++fileCharOffset;
                        if (previousChar == 13 && c == 10) {
                            lineStart = false;
                        } else if (previousChar == 13 && c != 10) {
                            lineStart = true;
                        } else if (previousChar == 10) {
                            lineStart = true;
                        } else if (previousChar != 13 && previousChar != 10) {
                            lineStart = false;
                        }
                        if (!lineStart) continue;
                        if (relatedHasHeader && lineCount == 0) {
                            ++lineCount;
                            continue;
                        }
                        if (relatedHasHeader) {
                            listOffsets.add(new LineOffset(lineCount - 1, fileCharOffset - 1L));
                        } else {
                            listOffsets.add(new LineOffset(lineCount, fileCharOffset - 1L));
                        }
                        ++lineCount;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listOffsets;
    }

    private int exportRelatedSelection(String exported, String worksheetRelated, List<WorksheetRelation> relations, List<LineOffset> offsets, int relatedIndex, boolean relatedHasHeader, int[] relatedSelection, String outputPath, String[] columnNames) {
        int notFoundCounter = 0;
        try {
            Collections.sort(relations, new Comparator<WorksheetRelation>(){

                @Override
                public int compare(WorksheetRelation arg0, WorksheetRelation arg1) {
                    return arg0.getIndexMaster() - arg1.getIndexMaster();
                }
            });
            Collections.sort(offsets, new Comparator<LineOffset>(){

                @Override
                public int compare(LineOffset o1, LineOffset o2) {
                    return o1.getLineIndex() - o2.getLineIndex();
                }
            });
            BufferedReader bReaderMaster = new BufferedReader(new FileReader(exported));
            BufferedReader bReaderRelated = new BufferedReader(new FileReader(worksheetRelated));
            BufferedWriter bWriterTemp = new BufferedWriter(new FileWriter(this.combineFile.getAbsolutePath()));
            try {
                String line;
                bReaderRelated.mark((int)new File(worksheetRelated).length());
                char relatedSeparator = CSVUtils.autodetectSeparator(worksheetRelated);
                char relatedDelimiter = CSVUtils.autodetectDelimiter(worksheetRelated, relatedSeparator);
                int i = 0;
                while (i < columnNames.length) {
                    bWriterTemp.append("\"" + columnNames[i] + "\";");
                    ++i;
                }
                if (columnNames.length > 0) {
                    bWriterTemp.newLine();
                }
                int lineCounter = 0;
                bReaderMaster.readLine();
                while ((line = bReaderMaster.readLine()) != null) {
                    bWriterTemp.append(line);
                    int relatedLineIndex = relations.get(lineCounter).getIndexRelated();
                    if (relatedLineIndex != -1) {
                        long off = offsets.get(relatedLineIndex).getOffset();
                        bReaderRelated.reset();
                        bReaderRelated.skip((int)off);
                        String lineRelated = bReaderRelated.readLine();
                        if (lineRelated != null) {
                            StringBuilder sBuilder = new StringBuilder();
                            int[] nArray = relatedSelection;
                            int n = relatedSelection.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int i2 = nArray[n2];
                                if (relatedDelimiter == 'N') {
                                    sBuilder.append("\"" + this.getColumnText(lineRelated, i2, ';') + "\";");
                                } else {
                                    sBuilder.append("\"" + this.getColumnText(lineRelated, i2, ';', relatedDelimiter) + "\";");
                                }
                                ++n2;
                            }
                            bWriterTemp.append(sBuilder.toString());
                        }
                    } else {
                        ++notFoundCounter;
                        int i3 = 0;
                        while (i3 < relatedSelection.length) {
                            bWriterTemp.append("\"\";");
                            ++i3;
                        }
                    }
                    bWriterTemp.newLine();
                    ++lineCounter;
                }
            }
            finally {
                bReaderMaster.close();
                bReaderRelated.close();
                bWriterTemp.close();
            }
            return notFoundCounter;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    private void exportMasterSelectionAll(List<WorksheetRelation> relations, int masterIndex, boolean masterHasHeader, int[] masterSelection, String outputPath) {
        try {
            Collections.sort(relations, new Comparator<WorksheetRelation>(){

                @Override
                public int compare(WorksheetRelation arg0, WorksheetRelation arg1) {
                    return arg0.getIndexMaster() - arg1.getIndexMaster();
                }
            });
            BufferedReader bReader = new BufferedReader(new FileReader(this.worksheetMaster));
            BufferedWriter bWriter = new BufferedWriter(new FileWriter(outputPath));
            try {
                String line = null;
                StringBuilder sBuilder = new StringBuilder();
                char masterSeparator = CSVUtils.autodetectSeparator(this.worksheetMaster);
                char masterDelimiter = CSVUtils.autodetectDelimiter(this.worksheetMaster, masterSeparator);
                while ((line = bReader.readLine()) != null) {
                    sBuilder = new StringBuilder();
                    if (line.trim().isEmpty()) continue;
                    sBuilder.append('\"');
                    if (masterDelimiter == 'N') {
                        sBuilder.append(this.getColumnText(line, masterIndex, ';'));
                    } else {
                        sBuilder.append(this.getColumnText(line, masterIndex, ';', masterDelimiter));
                    }
                    sBuilder.append('\"');
                    sBuilder.append(';');
                    int[] nArray = masterSelection;
                    int n = masterSelection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i = nArray[n2];
                        sBuilder.append('\"');
                        if (masterDelimiter == 'N') {
                            sBuilder.append(this.getColumnText(line, i, ';'));
                        } else {
                            sBuilder.append(this.getColumnText(line, i, ';', masterDelimiter));
                        }
                        sBuilder.append('\"');
                        sBuilder.append(';');
                        ++n2;
                    }
                    sBuilder.append("\n");
                    bWriter.append(sBuilder.toString());
                }
            }
            finally {
                bReader.close();
                bWriter.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<WorksheetRelation> getMasterFileIndices(int masterIndex, boolean hasHeader) {
        try {
            ArrayList<WorksheetRelation> relations = new ArrayList<WorksheetRelation>();
            try (BufferedReader bReader = new BufferedReader(new FileReader(this.worksheetMaster));){
                String line;
                char separator = CSVUtils.autodetectSeparator(this.worksheetMaster);
                char delimiter = CSVUtils.autodetectDelimiter(this.worksheetMaster, separator);
                int lineCount = 0;
                while ((line = bReader.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    if (hasHeader && lineCount == 0) {
                        ++lineCount;
                        continue;
                    }
                    if (hasHeader) {
                        if (delimiter == 'N') {
                            relations.add(new WorksheetRelation(lineCount - 1, this.getColumnText(line, masterIndex, ';'), -1));
                        } else {
                            relations.add(new WorksheetRelation(lineCount - 1, this.getColumnText(line, masterIndex, ';', delimiter), -1));
                        }
                    } else if (delimiter == 'N') {
                        relations.add(new WorksheetRelation(lineCount, this.getColumnText(line, masterIndex, ';'), -1));
                    } else {
                        relations.add(new WorksheetRelation(lineCount, this.getColumnText(line, masterIndex, ';', delimiter), -1));
                    }
                    ++lineCount;
                }
            }
            return relations;
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<WorksheetRelation> getRelatedIndices(int relatedIndex, boolean hasHeader, List<WorksheetRelation> relations) {
        try {
            WorksheetValueComparator wvComparator = new WorksheetValueComparator();
            Collections.sort(relations, new Comparator<WorksheetRelation>(){

                @Override
                public int compare(WorksheetRelation o1, WorksheetRelation o2) {
                    return o1.getTextMaster().compareTo(o2.getTextMaster());
                }
            });
            try (BufferedReader bReader = new BufferedReader(new FileReader(this.worksheetRelated));){
                String line;
                char separator = CSVUtils.autodetectSeparator(this.worksheetRelated);
                char delimiter = CSVUtils.autodetectDelimiter(this.worksheetRelated, separator);
                int lineCount = 0;
                while ((line = bReader.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    if (hasHeader && lineCount == 0) {
                        ++lineCount;
                        continue;
                    }
                    int res = -1;
                    res = delimiter == 'N' ? Collections.binarySearch(relations, this.getColumnText(line, relatedIndex, ';'), wvComparator) : Collections.binarySearch(relations, this.getColumnText(line, relatedIndex, ';', '\"'), wvComparator);
                    if (res >= 0) {
                        if (hasHeader) {
                            relations.get(res).setIndexRelated(lineCount - 1);
                        } else {
                            relations.get(res).setIndexRelated(lineCount);
                        }
                    }
                    ++lineCount;
                }
            }
            return relations;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getColumnText(String line, int index, char fieldSeparator, char fieldDelimiter) {
        StringBuilder sBuilder = new StringBuilder();
        boolean delimiterOpen = false;
        int fieldCounter = 0;
        int i = 0;
        while (i < line.length() && fieldCounter <= index) {
            if (line.charAt(i) == fieldDelimiter) {
                if (delimiterOpen) {
                    delimiterOpen = false;
                    ++fieldCounter;
                } else {
                    delimiterOpen = true;
                }
            } else if (line.charAt(i) == fieldSeparator) {
                if (delimiterOpen && fieldCounter == index) {
                    sBuilder.append(line.charAt(i));
                }
            } else if (fieldCounter == index) {
                sBuilder.append(line.charAt(i));
            }
            ++i;
        }
        return sBuilder.toString();
    }

    private String getColumnText(String line, int index, char fieldSeparator) {
        StringBuilder sBuilder = new StringBuilder();
        int fieldCounter = 0;
        boolean delimiterOpen = false;
        int i = 0;
        while (i < line.length() && fieldCounter <= index) {
            if (i == 0) {
                if (line.charAt(i) == '\"') {
                    delimiterOpen = !delimiterOpen;
                }
                if (line.charAt(i) == fieldSeparator && !delimiterOpen) {
                    ++fieldCounter;
                } else if (fieldCounter == index && line.charAt(i) != '\"') {
                    sBuilder.append(line.charAt(i));
                }
            } else {
                if (line.charAt(i) == '\"' && line.charAt(i - 1) != '\\') {
                    delimiterOpen = !delimiterOpen;
                }
                if (line.charAt(i) == fieldSeparator && !delimiterOpen) {
                    ++fieldCounter;
                } else if (fieldCounter == index && line.charAt(i) != '\"') {
                    sBuilder.append(line.charAt(i));
                }
            }
            ++i;
        }
        return sBuilder.toString();
    }

    class WorksheetValueComparator
    implements Comparator<Object> {
        WorksheetValueComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return ((WorksheetRelation)o1).getTextMaster().compareTo((String)o2);
        }
    }
}

