/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model;

import com.biotechvana.javabiotoolkit.exceptions.FastaReaderNotParsedException;
import com.biotechvana.javabiotoolkit.io.FASTAFileRecord;
import com.biotechvana.javabiotoolkit.io.FASTAReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CSVUtils {
    public static final char NULL_DELIMITER = 'N';
    public static final char SINGLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char ESCAPE_CHAR = '\\';
    public static final char NEW_LINE_N = '\n';
    public static final char NEW_LINE_R = '\r';
    public static final char COMMENT_CHAR = '#';
    public static final int COLUMN_PADDING = 2;
    private static final String MULTIHIT_LABEL = "#multihit=";
    private final int BUFFER_SIZE = 524288;
    private StringBuilder modelRowBuilder;
    private int columnCount = 0;
    private int lineCount = 0;
    private File csvFile;
    private boolean parseColumnCountDone = false;
    private boolean parseLineCountDone = false;
    private boolean debug = false;

    public CSVUtils(String csvFile) {
        this.csvFile = new File(csvFile);
    }

    public CSVUtils(File csvFile) {
        this.csvFile = csvFile;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public static char autodetectDelimiter(File csvFile, char fieldSeparator) {
        return CSVUtils.autodetectDelimiter(csvFile.getAbsolutePath(), fieldSeparator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char autodetectDelimiter(String csvFile, char fieldSeparator) {
        int countDoubleQuote = 0;
        int countSingleQuote = 0;
        int MAX_LINES = 100;
        int countSeparators = 0;
        String firstLine = null;
        int lineCount = 0;
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            String line;
            boolean delimiterOpen = false;
            while ((line = br.readLine()) != null && lineCount < 100) {
                if (lineCount == 0) {
                    firstLine = line;
                }
                delimiterOpen = false;
                int i = 0;
                while (i < line.length()) {
                    block25: {
                        block23: {
                            block24: {
                                if (i <= 0) break block23;
                                if ((line.charAt(i) == '\"' || line.charAt(i) == '\'') && line.charAt(i - 1) != '\\') {
                                    delimiterOpen = !delimiterOpen;
                                }
                                if (line.charAt(i) != '\"' || line.charAt(i - 1) == '\\') break block24;
                                ++countDoubleQuote;
                                break block25;
                            }
                            if (line.charAt(i) == '\'' && line.charAt(i - 1) != '\\') {
                                ++countSingleQuote;
                                break block25;
                            } else if (line.charAt(i) == fieldSeparator && line.charAt(i - 1) != '\\' && !delimiterOpen) {
                                ++countSeparators;
                            }
                            break block25;
                        }
                        if (line.charAt(i) == '\"' || line.charAt(i) == '\'') {
                            delimiterOpen = !delimiterOpen;
                        }
                        if (line.charAt(i) == '\"') {
                            ++countDoubleQuote;
                        } else if (line.charAt(i) == '\'') {
                            ++countSingleQuote;
                        } else if (line.charAt(i) == fieldSeparator && !delimiterOpen) {
                            ++countSeparators;
                        }
                    }
                    ++i;
                }
                ++lineCount;
            }
            if (!firstLine.endsWith(String.valueOf(fieldSeparator))) {
                ++countSeparators;
            }
            if (countDoubleQuote == 0 && countSingleQuote == 0) {
                return 'N';
            }
            if (countDoubleQuote >= countSeparators) {
                return '\"';
            }
            if (countSingleQuote < countSeparators) return 'N';
            return '\'';
        }
        catch (Exception e) {
            return 'N';
        }
    }

    public static char autodetectSeparator(File csvFile) {
        return CSVUtils.autodetectSeparator(csvFile.getAbsolutePath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char autodetectSeparator(String csvFile) {
        int[] separators = new int[5];
        int MAX_LINES = 100;
        try (BufferedReader br = new BufferedReader(new FileReader(csvFile));){
            String line;
            int lineCount = 0;
            boolean delimiterOpen = false;
            while ((line = br.readLine()) != null && lineCount < 100) {
                delimiterOpen = false;
                int i = 0;
                while (i < line.length()) {
                    char currentChar = line.charAt(i);
                    if (i > 0) {
                        if ((currentChar == '\"' || currentChar == '\'') && line.charAt(i - 1) != '\\') {
                            delimiterOpen = !delimiterOpen;
                        }
                    } else if (currentChar == '\"' || currentChar == '\'') {
                        delimiterOpen = !delimiterOpen;
                    }
                    if (!delimiterOpen) {
                        switch (currentChar) {
                            case ';': {
                                int n = Separators.SEMICOLON.getIndex();
                                separators[n] = separators[n] + 1;
                                break;
                            }
                            case ':': {
                                int n = Separators.COLON.getIndex();
                                separators[n] = separators[n] + 1;
                                break;
                            }
                            case ' ': {
                                int n = Separators.SPACE.getIndex();
                                separators[n] = separators[n] + 1;
                                break;
                            }
                            case '\t': {
                                int n = Separators.TAB.getIndex();
                                separators[n] = separators[n] + 1;
                                break;
                            }
                            case ',': {
                                int n = Separators.COMMA.getIndex();
                                separators[n] = separators[n] + 1;
                                break;
                            }
                        }
                    }
                    ++i;
                }
                ++lineCount;
            }
            int maxIndex = 0;
            int maxCount = 0;
            int i = 0;
            while (i < separators.length) {
                if (separators[i] > maxCount) {
                    maxCount = separators[i];
                    maxIndex = i;
                }
                ++i;
            }
            if (separators[Separators.SEMICOLON.getIndex()] >= separators[Separators.COLON.getIndex()] && (separators[Separators.SEMICOLON.getIndex()] > 0 || separators[Separators.COLON.getIndex()] > 0)) {
                char c = Separators.SEMICOLON.getSeparator();
                return c;
            }
            char c = Separators.values()[maxIndex].getSeparator();
            return c;
        }
        catch (FileNotFoundException e) {
            return Separators.SEMICOLON.getSeparator();
        }
        catch (IOException e) {
            return Separators.SEMICOLON.getSeparator();
        }
    }

    public void parseColumnCount(char fieldSeparator, char fieldDelimiter, IProgressMonitor monitor) throws IOException, InterruptedException {
        try {
            BufferedReader bReader = new BufferedReader(new FileReader(this.csvFile));
            char[] buffer = new char[524288];
            char lastChar = '1';
            int bytesRead = 0;
            long totalBytesRead = 0L;
            long totalBytes = this.csvFile.length();
            int currentColumnCount = 0;
            boolean delimiterOpen = false;
            DecimalFormat decimalFormat = new DecimalFormat("###,##0.00");
            int taskSize = (int)(totalBytes / 524288L);
            monitor.beginTask("Get column count", taskSize);
            while ((bytesRead = bReader.read(buffer)) != -1) {
                int i = 0;
                while (i < bytesRead) {
                    char currentChar = buffer[i];
                    if (currentChar == '\n') {
                        if (i > 0 && buffer[i - 1] != fieldSeparator) {
                            ++currentColumnCount;
                        }
                        if (i < bytesRead - 1 && buffer[i + 1] == '\r') {
                            ++i;
                        }
                        if (currentColumnCount > this.columnCount) {
                            this.columnCount = currentColumnCount;
                        }
                        currentColumnCount = 0;
                    } else if (currentChar == '\r') {
                        if (i > 0 && buffer[i - 1] != fieldSeparator) {
                            ++currentColumnCount;
                        }
                        if (i < bytesRead - 1 && buffer[i + 1] == '\n') {
                            ++i;
                        }
                        if (currentColumnCount > this.columnCount) {
                            this.columnCount = currentColumnCount;
                        }
                        currentColumnCount = 0;
                    } else if (currentChar == fieldDelimiter) {
                        if (lastChar != '\\') {
                            delimiterOpen = !delimiterOpen;
                        }
                    } else if (currentChar == fieldSeparator && !delimiterOpen) {
                        ++currentColumnCount;
                    }
                    lastChar = currentChar;
                    ++i;
                }
                monitor.worked(1);
                monitor.subTask("Read " + decimalFormat.format((float)(totalBytesRead += (long)bytesRead) / 1048576.0f) + " of " + decimalFormat.format((float)totalBytes / 1048576.0f) + " MB.");
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
            this.parseColumnCountDone = true;
        }
        finally {
            monitor.done();
        }
    }

    public void parseColumnCount(char fieldSeparator, IProgressMonitor monitor) throws IOException, InterruptedException {
        try {
            BufferedReader bReader = new BufferedReader(new FileReader(this.csvFile));
            char[] buffer = new char[524288];
            int bytesRead = 0;
            long totalBytesRead = 0L;
            long totalBytes = this.csvFile.length();
            int currentColumnCount = 0;
            DecimalFormat decimalFormat = new DecimalFormat("###,##0.00");
            boolean delimiterOpen = false;
            int taskSize = (int)(totalBytes / 524288L);
            this.columnCount = 0;
            monitor.beginTask("Get column count", taskSize);
            while ((bytesRead = bReader.read(buffer)) != -1) {
                int i = 0;
                while (i < bytesRead) {
                    char currentChar = buffer[i];
                    if (currentChar == '\n') {
                        if (i > 0 && buffer[i - 1] != fieldSeparator) {
                            ++currentColumnCount;
                        }
                        if (i < bytesRead - 1 && buffer[i + 1] == '\r') {
                            ++i;
                        }
                        if (currentColumnCount > this.columnCount) {
                            this.columnCount = currentColumnCount;
                        }
                        currentColumnCount = 0;
                        delimiterOpen = false;
                    } else if (currentChar == '\r') {
                        if (i > 0 && buffer[i - 1] != fieldSeparator) {
                            ++currentColumnCount;
                        }
                        if (i < bytesRead - 1 && buffer[i + 1] == '\n') {
                            ++i;
                        }
                        if (currentColumnCount > this.columnCount) {
                            this.columnCount = currentColumnCount;
                        }
                        currentColumnCount = 0;
                        delimiterOpen = false;
                    } else if (currentChar == '\"') {
                        if (i == 0) {
                            delimiterOpen = !delimiterOpen;
                        } else if (buffer[i - 1] != '\\') {
                            delimiterOpen = !delimiterOpen;
                        }
                    } else if (currentChar == fieldSeparator && !delimiterOpen) {
                        ++currentColumnCount;
                    }
                    ++i;
                }
                monitor.worked(1);
                monitor.subTask("Read " + decimalFormat.format((float)(totalBytesRead += (long)bytesRead) / 1048576.0f) + " of " + decimalFormat.format((float)totalBytes / 1048576.0f) + " MB.");
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
            this.parseColumnCountDone = true;
        }
        finally {
            monitor.done();
        }
    }

    public String[] getHeaders(char fieldSeparator, char fieldDelimiter, int columnCount) throws IOException {
        int counter = 0;
        ArrayList<Object> headerList = new ArrayList<Object>();
        try (BufferedReader bReader = new BufferedReader(new FileReader(this.csvFile));){
            String line;
            while ((line = bReader.readLine()) != null) {
                if (!line.isEmpty() && line.charAt(0) != '#') break;
            }
            if (line != null && line.length() > 0) {
                line = line.trim();
                StringBuilder sbuilder = new StringBuilder();
                int i = 0;
                while (i < line.length() && counter < columnCount) {
                    if (line.charAt(i) == fieldSeparator) {
                        headerList.add(sbuilder.toString());
                        ++counter;
                        sbuilder = new StringBuilder();
                    } else if (line.charAt(i) != fieldDelimiter) {
                        sbuilder.append(line.charAt(i));
                    }
                    ++i;
                }
                if (counter < columnCount) {
                    headerList.add(sbuilder.toString());
                }
                i = 0;
                while (i < headerList.size()) {
                    if (((String)headerList.get(i)).isEmpty()) {
                        headerList.set(i, "Col #" + (i + 1));
                    }
                    ++i;
                }
                String[] stringArray = headerList.toArray(new String[headerList.size()]);
                return stringArray;
            }
        }
        return null;
    }

    public String[] getHeaders(char fieldSeparator, int columnCount) throws IOException {
        int counter = 0;
        ArrayList<Object> headerList = new ArrayList<Object>();
        try (BufferedReader bReader = new BufferedReader(new FileReader(this.csvFile));){
            String line;
            while ((line = bReader.readLine()) != null) {
                if (!line.isEmpty() && line.charAt(0) != '#') break;
            }
            if (line != null && line.length() > 0) {
                line = line.trim();
                StringBuilder sbuilder = new StringBuilder();
                int i = 0;
                while (i < line.length() && counter < columnCount) {
                    if (line.charAt(i) == fieldSeparator) {
                        headerList.add(sbuilder.toString());
                        ++counter;
                        sbuilder = new StringBuilder();
                    } else {
                        sbuilder.append(line.charAt(i));
                    }
                    ++i;
                }
                if (counter < columnCount) {
                    headerList.add(sbuilder.toString());
                }
                i = 0;
                while (i < headerList.size()) {
                    if (((String)headerList.get(i)).isEmpty()) {
                        headerList.set(i, "Col #" + (i + 1));
                    }
                    ++i;
                }
                String[] headerArray = new String[headerList.size()];
                int i2 = 0;
                while (i2 < headerList.size()) {
                    headerArray[i2] = ((String)headerList.get(i2)).trim();
                    ++i2;
                }
                String[] stringArray = headerArray;
                return stringArray;
            }
        }
        return null;
    }

    public List<List<String>> getRows(int columnCount, char fieldSeparator, char fieldDelimiter, boolean hasHeader, boolean appendIndex, IProgressMonitor monitor) throws IOException, InterruptedException, LineCountNotDoneException {
        ArrayList<List<String>> rowList = new ArrayList<List<String>>();
        DecimalFormat decimalFormat = new DecimalFormat("###,###");
        int stepSize = 1;
        this.parseFileLineCount((IProgressMonitor)new NullProgressMonitor());
        int totalLines = this.getLineCount();
        if (totalLines > 100) {
            stepSize = totalLines / 100;
        }
        monitor.beginTask("Parse CSV file", totalLines);
        BufferedReader bReader = new BufferedReader(new FileReader(this.csvFile));
        try {
            String line;
            boolean firstLine = true;
            int lineCount = 0;
            int lc = 0;
            while ((line = bReader.readLine()) != null) {
                ++lc;
                if (line.isEmpty() || this.rowIsEmpty(line, fieldSeparator) || line.charAt(0) == '#') continue;
                ArrayList<String> row = new ArrayList<String>();
                if (appendIndex) {
                    row.add("0");
                    row.add(String.valueOf(lineCount++));
                }
                row.addAll(this.readCsvLine(line, fieldSeparator, fieldDelimiter, columnCount));
                if (hasHeader && firstLine) {
                    firstLine = false;
                    continue;
                }
                int i = row.size();
                while (i < columnCount + 2) {
                    row.add("");
                    ++i;
                }
                rowList.add(row);
                if (lc % stepSize != 0) continue;
                monitor.worked(stepSize);
                monitor.subTask("Parsing line " + decimalFormat.format(lc) + " of " + decimalFormat.format(totalLines) + " total lines.");
            }
            ArrayList<List<String>> arrayList = rowList;
            return arrayList;
        }
        finally {
            bReader.close();
            monitor.done();
        }
    }

    public List<List<String>> getRowsBuffered(int columnCount, char fieldSeparator, char fieldDelimiter, boolean hasHeader, boolean appendIndex, IProgressMonitor monitor) throws IOException, InterruptedException {
        char[] charBuffer = new char[524288];
        long fileLength = this.csvFile.length();
        long totalRead = 0L;
        double fileLenghtMB = (double)fileLength / 1048576.0;
        int totalBlocks = (int)(fileLength / 524288L);
        int linesRead = 0;
        int readBytes = 0;
        int stepSize = 1;
        ArrayList<List<String>> model = new ArrayList<List<String>>();
        BufferedReader reader = new BufferedReader(new FileReader(this.csvFile), 524288);
        ArrayList<String> row = new ArrayList<String>();
        DecimalFormat decimalFormat = new DecimalFormat("##0.00");
        if (totalBlocks > 100) {
            stepSize = totalBlocks / 100;
        }
        try {
            monitor.beginTask("Parse CSV file.\nPlease wait while creating table items, it may take some minutes depending on the file's size.", totalBlocks);
            this.modelRowBuilder = new StringBuilder();
            if (appendIndex) {
                row.add("0");
                row.add(String.valueOf(linesRead + 1));
            }
            int counter = 0;
            while ((readBytes = reader.read(charBuffer)) != -1) {
                int i = 0;
                while (i < readBytes) {
                    if (charBuffer[i] == '\n') {
                        if (i < readBytes - 1 && charBuffer[i + 1] == '\r') {
                            ++i;
                        }
                        if (!(hasHeader && linesRead <= 0 || (listFields = this.readCsvLine(this.modelRowBuilder.toString(), fieldSeparator, fieldDelimiter, columnCount)) == null || listFields.size() <= 0)) {
                            row.addAll(listFields);
                            if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                                model.add(row);
                            }
                        }
                        if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                            ++linesRead;
                        }
                        this.modelRowBuilder.delete(0, this.modelRowBuilder.length());
                        row = new ArrayList();
                        if (appendIndex) {
                            row.add("0");
                            row.add(String.valueOf(linesRead));
                        }
                    } else if (charBuffer[i] == '\r') {
                        if (i < readBytes - 1 && charBuffer[i + 1] == '\n') {
                            ++i;
                        }
                        if (!(hasHeader && linesRead <= 0 || (listFields = this.readCsvLine(this.modelRowBuilder.toString(), fieldSeparator, fieldDelimiter, columnCount)) == null || listFields.size() <= 0)) {
                            row.addAll(listFields);
                            if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                                model.add(row);
                            }
                        }
                        if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                            ++linesRead;
                        }
                        this.modelRowBuilder.delete(0, this.modelRowBuilder.length());
                        row = new ArrayList();
                        if (appendIndex) {
                            row.add("0");
                            row.add(String.valueOf(linesRead));
                        }
                    } else {
                        this.modelRowBuilder.append(charBuffer[i]);
                    }
                    ++i;
                }
                totalRead += (long)readBytes;
                if (counter % stepSize == 0) {
                    monitor.worked(stepSize);
                    monitor.subTask("Read " + decimalFormat.format((double)totalRead / 1048576.0) + "MB of " + decimalFormat.format(fileLenghtMB) + "MB");
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++counter;
            }
            ArrayList<List<String>> arrayList = model;
            return arrayList;
        }
        finally {
            reader.close();
            monitor.done();
        }
    }

    public List<List<String>> getRowsBuffered(int columnsCount, char fieldSeparator, boolean hasHeader, boolean appendIndex, IProgressMonitor monitor) throws IOException, InterruptedException {
        long totalByteLength = this.csvFile.length();
        double fileLenghtMB = (double)totalByteLength / 1048576.0;
        int linesRead = 0;
        int totalBlocks = (int)(totalByteLength / 524288L);
        int totalBytesRead = 0;
        int stepSize = 1;
        ArrayList<List<String>> model = new ArrayList<List<String>>();
        BufferedReader reader = new BufferedReader(new FileReader(this.csvFile), 524288);
        DecimalFormat decimalFormat = new DecimalFormat("##0.00");
        if (totalBlocks > 100) {
            stepSize = totalBlocks / 100;
        }
        try {
            monitor.beginTask("Parse CSV file.\nPlease wait while creating table items, it may take some minutes depending on file's size.", totalBlocks);
            char[] charBuffer = new char[524288];
            int readBytes = 0;
            this.modelRowBuilder = new StringBuilder();
            ArrayList<String> row = new ArrayList<String>();
            if (appendIndex) {
                row.add("0");
                row.add(String.valueOf(linesRead + 1));
            }
            int counter = 0;
            while ((readBytes = reader.read(charBuffer)) != -1) {
                int i = 0;
                while (i < readBytes) {
                    if (charBuffer[i] == '\n') {
                        if (i < readBytes && charBuffer[i + 1] == '\r') {
                            ++i;
                        }
                        if (!(hasHeader && linesRead <= 0 || (listFields = this.readCsvLine(this.modelRowBuilder.toString(), fieldSeparator, this.columnCount)) == null || listFields.size() <= 0)) {
                            row.addAll(listFields);
                            if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                                model.add(row);
                            }
                        }
                        if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                            ++linesRead;
                        }
                        this.modelRowBuilder.replace(0, this.modelRowBuilder.length(), "");
                        row = new ArrayList();
                        if (appendIndex) {
                            row.add("0");
                            row.add(String.valueOf(linesRead));
                        }
                    } else if (charBuffer[i] == '\r') {
                        if (i < readBytes - 1 && charBuffer[i + 1] == '\n') {
                            ++i;
                        }
                        if (!(hasHeader && linesRead <= 0 || (listFields = this.readCsvLine(this.modelRowBuilder.toString(), fieldSeparator, this.columnCount)) == null || listFields.size() <= 0)) {
                            row.addAll(listFields);
                            if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                                model.add(row);
                            }
                        }
                        if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                            ++linesRead;
                        }
                        this.modelRowBuilder.replace(0, this.modelRowBuilder.length(), "");
                        row = new ArrayList();
                        if (appendIndex) {
                            row.add("0");
                            row.add(String.valueOf(linesRead));
                        }
                    } else {
                        this.modelRowBuilder.append(charBuffer[i]);
                    }
                    ++i;
                }
                totalBytesRead += readBytes;
                if (counter % stepSize == 0) {
                    monitor.worked(stepSize);
                    monitor.subTask("Read " + decimalFormat.format((double)totalBytesRead / 1048576.0) + "MB of " + decimalFormat.format(fileLenghtMB) + "MB");
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++counter;
            }
            ArrayList<List<String>> arrayList = model;
            return arrayList;
        }
        finally {
            reader.close();
            monitor.done();
        }
    }

    public List<List<String>> getRows(int countColumns, char fieldSeparator, boolean hasHeader, boolean appendIndex, IProgressMonitor monitor) throws LineCountNotDoneException, IOException, InterruptedException {
        int totalLines = 0;
        ArrayList<List<String>> rowList = new ArrayList<List<String>>();
        this.parseFileLineCount((IProgressMonitor)new NullProgressMonitor());
        totalLines = this.getLineCount();
        monitor.beginTask("Parse worksheet", totalLines);
        BufferedReader bReader = new BufferedReader(new FileReader(this.csvFile));
        try {
            String line;
            boolean firstLine = true;
            int lineCount = 0;
            int lc = 0;
            while ((line = bReader.readLine()) != null) {
                if (!line.isEmpty() && !this.rowIsEmpty(line, fieldSeparator)) {
                    if (line.charAt(0) == '#') continue;
                    ArrayList<String> row = new ArrayList<String>();
                    if (appendIndex) {
                        row.add("0");
                        row.add(String.valueOf(lineCount++));
                    }
                    row.addAll(this.readCsvLine(line, fieldSeparator, this.columnCount));
                    if (hasHeader && firstLine) {
                        firstLine = false;
                        continue;
                    }
                    int i = row.size();
                    while (i < countColumns + 2) {
                        row.add("");
                        ++i;
                    }
                    rowList.add(row);
                }
                monitor.subTask("Parsing line " + ++lc + " of " + totalLines);
                monitor.worked(1);
            }
            ArrayList<List<String>> arrayList = rowList;
            return arrayList;
        }
        finally {
            bReader.close();
            monitor.done();
        }
    }

    private List<String> readCsvLine(String csvLine, char fieldSeparator, char fieldDelimiter, int columnCount) {
        int countCurrent;
        ArrayList<String> listFields = new ArrayList<String>();
        int lineLength = csvLine.length();
        boolean delimiterOpen = false;
        StringBuilder sBuilder = new StringBuilder();
        int i = 0;
        while (i < lineLength) {
            if (csvLine.charAt(i) == fieldDelimiter) {
                if (i > 0) {
                    if (csvLine.charAt(i - 1) == '\\') {
                        sBuilder.append(csvLine.charAt(i));
                    } else {
                        delimiterOpen = !delimiterOpen;
                    }
                }
            } else if (csvLine.charAt(i) == fieldSeparator && delimiterOpen) {
                listFields.add(sBuilder.toString());
                sBuilder = new StringBuilder();
            } else {
                sBuilder.append(csvLine.charAt(i));
            }
            ++i;
        }
        if (lineLength - 1 >= 0 && csvLine.charAt(lineLength - 1) != fieldSeparator) {
            listFields.add(sBuilder.toString());
        }
        int i2 = countCurrent = listFields.size();
        while (i2 < columnCount) {
            listFields.add("");
            ++i2;
        }
        return listFields;
    }

    private List<String> readCsvLine(String csvLine, char fieldSeparator, int columnCount) {
        int countCurrent;
        ArrayList<String> listFields = new ArrayList<String>();
        int lineLength = csvLine.length();
        StringBuilder sBuilder = new StringBuilder();
        boolean delimiterOpen = false;
        if (csvLine == null || csvLine.trim().length() == 0) {
            return null;
        }
        int i = 0;
        while (i < lineLength) {
            if (csvLine.charAt(i) == '\"') {
                if (i > 0) {
                    if (csvLine.charAt(i - 1) != '\\') {
                        delimiterOpen = !delimiterOpen;
                    }
                } else {
                    delimiterOpen = !delimiterOpen;
                }
            }
            if (csvLine.charAt(i) == fieldSeparator) {
                if (!delimiterOpen) {
                    listFields.add(sBuilder.toString());
                    sBuilder = new StringBuilder();
                } else {
                    sBuilder.append(csvLine.charAt(i));
                }
            } else if (csvLine.charAt(i) == '\"') {
                if (delimiterOpen && i > 0 && csvLine.charAt(i - 1) == '\\') {
                    sBuilder.append(csvLine.charAt(i));
                }
            } else {
                sBuilder.append(csvLine.charAt(i));
            }
            ++i;
        }
        if (csvLine.charAt(lineLength - 1) != fieldSeparator) {
            listFields.add(sBuilder.toString());
        }
        boolean lineIsEmpty = true;
        int i2 = 0;
        while (i2 < listFields.size() && lineIsEmpty) {
            if (((String)listFields.get(i2)).trim().length() > 0) {
                lineIsEmpty = false;
            }
            ++i2;
        }
        if (lineIsEmpty) {
            return null;
        }
        int i3 = countCurrent = listFields.size();
        while (i3 < columnCount) {
            listFields.add("");
            ++i3;
        }
        return listFields;
    }

    public List<List<String>> getRows(char fieldSeparator, char fieldDelimiter, char innerSeparator, boolean hasHeader) throws IOException {
        ArrayList<List<String>> rowList = new ArrayList<List<String>>();
        try (BufferedReader bReader = new BufferedReader(new FileReader(this.csvFile));){
            String line;
            boolean firstLine = true;
            int lineCount = 0;
            while ((line = bReader.readLine()) != null) {
                ArrayList<String> row = new ArrayList<String>();
                row.add("");
                row.add(String.valueOf(lineCount++));
                if (hasHeader && firstLine) {
                    firstLine = false;
                    continue;
                }
                row.addAll(this.getRow(line, fieldSeparator, fieldDelimiter, innerSeparator));
                rowList.add(row);
            }
            ArrayList<List<String>> arrayList = rowList;
            return arrayList;
        }
    }

    private boolean rowIsEmpty(String line, char fieldSeparator) {
        line = line.trim();
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) != fieldSeparator) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int saveTable(List<List<String>> table, String outputFile, char fieldSeparator, char fieldDelimiter, String[] headers, boolean ignoreFirst) throws IOException {
        int columnPadding = 0;
        if (ignoreFirst) {
            columnPadding = 2;
        }
        if (table == null) {
            System.err.println("CSVUtils->saveTable(): table is null");
            return -1;
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile, false));){
            if (headers != null && headers.length > 0) {
                String[] stringArray = headers;
                int n = headers.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    bw.append(fieldDelimiter + s + fieldDelimiter + fieldSeparator);
                    ++n2;
                }
                bw.newLine();
            }
            for (List<String> row : table) {
                int i = columnPadding;
                while (i < row.size()) {
                    bw.append(fieldDelimiter + row.get(i).replace("\n", "<br>") + fieldDelimiter + fieldSeparator);
                    ++i;
                }
                bw.newLine();
            }
            if (this.debug) {
                System.out.println("Saved csv file to: " + outputFile);
            }
            return 1;
        }
    }

    public static boolean fastaToCsv(File fastaFile, char headerSeparator, char fieldSeparator, char fieldDelimiter, File csvFile, boolean overwrite) throws FileNotFoundException, IOException, FastaReaderNotParsedException {
        int n;
        int n2;
        String[] stringArray;
        StringBuilder sbuilder;
        int seqLength;
        String[] headerCols;
        if (!fastaFile.exists()) {
            return false;
        }
        FASTAReader fastaReader = new FASTAReader(fastaFile);
        fastaReader.parse();
        List listSeqs = fastaReader.getFastaRecords();
        csvFile.delete();
        csvFile.createNewFile();
        int i = 0;
        while (i < listSeqs.size()) {
            FASTAFileRecord rec = (FASTAFileRecord)listSeqs.get(i);
            headerCols = CSVUtils.splitHeader(rec.loadDescription(), headerSeparator);
            seqLength = rec.toString().length();
            if (i == 0) {
                StringBuilder sHeader = new StringBuilder();
                sHeader.append(fieldDelimiter + "Name" + fieldDelimiter + fieldSeparator);
                int p = 0;
                while (p < headerCols.length - 1) {
                    sHeader.append("" + fieldDelimiter + fieldDelimiter + fieldSeparator);
                    ++p;
                }
                sHeader.append(fieldDelimiter + "Length" + fieldDelimiter + fieldSeparator);
                CSVUtils.appendToCsv(csvFile, sHeader.toString());
            }
            sbuilder = new StringBuilder();
            stringArray = headerCols;
            n2 = headerCols.length;
            n = 0;
            while (n < n2) {
                String h = stringArray[n];
                sbuilder.append(fieldDelimiter + h + fieldDelimiter + fieldSeparator);
                ++n;
            }
            sbuilder.append(fieldDelimiter + Integer.toString(seqLength) + fieldDelimiter + fieldSeparator);
            CSVUtils.appendToCsv(csvFile, sbuilder.toString());
            ++i;
        }
        for (FASTAFileRecord rec : listSeqs) {
            headerCols = CSVUtils.splitHeader(rec.loadDescription(), headerSeparator);
            seqLength = rec.toString().length();
            sbuilder = new StringBuilder();
            stringArray = headerCols;
            n2 = headerCols.length;
            n = 0;
            while (n < n2) {
                String h = stringArray[n];
                sbuilder.append(fieldDelimiter + h + fieldDelimiter + fieldSeparator);
                ++n;
            }
            sbuilder.append(fieldDelimiter + Integer.toString(seqLength) + fieldDelimiter + fieldSeparator);
            CSVUtils.appendToCsv(csvFile, sbuilder.toString());
        }
        return true;
    }

    private static boolean appendToCsv(File csvFile, String line) {
        BufferedWriter bw = new BufferedWriter(new FileWriter(csvFile, true));
        try {
            bw.append(line);
            bw.newLine();
        }
        catch (Throwable throwable) {
            try {
                bw.close();
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        bw.close();
        return true;
    }

    private static String[] splitHeader(String header, char headerSeparator) {
        ArrayList<String> columns = new ArrayList<String>();
        header = header.trim();
        StringBuilder sbuilder = new StringBuilder();
        int i = 0;
        while (i < header.length()) {
            if (header.charAt(i) != '>') {
                if (header.charAt(i) == headerSeparator) {
                    columns.add(sbuilder.toString());
                    sbuilder = new StringBuilder();
                } else {
                    sbuilder.append(header.charAt(i));
                }
            }
            ++i;
        }
        columns.add(sbuilder.toString());
        return columns.toArray(new String[columns.size()]);
    }

    public boolean hasRepeatedQueries(char separator, int columnCount) throws IOException {
        return this.hasRepeatedQueries(separator, 'N', columnCount);
    }

    public boolean hasRepeatedQueries(char separator, char delimiter, int columnCount) throws IOException {
        String[] headers = delimiter == 'N' ? this.getHeaders(separator, columnCount) : this.getHeaders(separator, delimiter, columnCount);
        boolean found = false;
        int sequenceColumnIndex = 0;
        while (sequenceColumnIndex < headers.length && !found) {
            if (headers[sequenceColumnIndex].equalsIgnoreCase("Sequence")) {
                found = true;
            }
            if (found) continue;
            ++sequenceColumnIndex;
        }
        if (this.debug) {
            System.out.println("Sequence column index: " + sequenceColumnIndex);
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));){
            String line;
            String lastValue = null;
            while ((line = reader.readLine()) != null) {
                List<String> row = delimiter == 'N' ? this.readCsvLine(line, separator, columnCount) : this.readCsvLine(line, separator, delimiter, columnCount);
                if (sequenceColumnIndex >= row.size()) continue;
                String value = row.get(sequenceColumnIndex);
                if (lastValue == null) {
                    lastValue = value;
                    continue;
                }
                if (lastValue.equals(value)) {
                    if (this.debug) {
                        System.out.println("Repeated value: " + value);
                    }
                    return true;
                }
                lastValue = value;
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMultiHitComment() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));){
            String line;
            do {
                if ((line = reader.readLine()) == null) {
                    return null;
                }
                if (line.charAt(0) == '#') continue;
                return null;
            } while (line.indexOf(MULTIHIT_LABEL) != 0);
            String string = line.substring(MULTIHIT_LABEL.length()).trim();
            return string;
        }
        catch (Exception e) {
            if (!this.debug) return null;
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getRow(String line, char fieldSeparator, char fieldDelimiter, char innerSeparator) {
        ArrayList<String> row = new ArrayList<String>();
        StringBuilder sbuilder = new StringBuilder();
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) == fieldSeparator || line.charAt(i) == innerSeparator) {
                row.add(sbuilder.toString());
                sbuilder = new StringBuilder();
            } else if (line.charAt(i) != fieldDelimiter) {
                sbuilder.append(line.charAt(i));
            }
            ++i;
        }
        return row;
    }

    public List<List<String>> getRow(int from, int to, char fieldSeparator, char fieldDelimiter, int columnCount) {
        ArrayList<List<String>> selectedRows;
        block7: {
            selectedRows = new ArrayList<List<String>>();
            try (BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));){
                String line;
                int counter = 0;
                while ((line = reader.readLine()) != null) {
                    if (counter > from && counter <= to + 1) {
                        selectedRows.add(this.readCsvLine(line, fieldSeparator, fieldDelimiter, columnCount));
                    }
                    ++counter;
                }
            }
            catch (Exception e) {
                if (!this.debug) break block7;
                e.printStackTrace();
            }
        }
        return selectedRows;
    }

    public void filterMultiHitBuffered(int column, char fieldSeparator, char fieldDelimiter, String newFileName, int columnCount, IProgressMonitor monitor) throws InterruptedException, IOException {
        char[] charBuffer = new char[524288];
        long totalByteLength = this.csvFile.length();
        double fileLenghtMB = (double)totalByteLength / 1048576.0;
        int totalBlocks = (int)(totalByteLength / 524288L);
        boolean totalBytesRead = false;
        int stepSize = 1;
        int readBytes = -1;
        int totalRead = 0;
        BufferedReader reader = new BufferedReader(new FileReader(this.csvFile), 524288);
        BufferedWriter writer = new BufferedWriter(new FileWriter(newFileName));
        DecimalFormat decimalFormat = new DecimalFormat("##0.00");
        ArrayList<String> row = new ArrayList<String>();
        String lastSequenceName = null;
        if (totalBlocks > 100) {
            stepSize = totalBlocks / 100;
        }
        monitor.beginTask("Filtering multiple HSPs", totalBlocks);
        try {
            this.modelRowBuilder = new StringBuilder();
            writer.append(MULTIHIT_LABEL + this.csvFile.getAbsolutePath());
            writer.newLine();
            int counter = 0;
            while ((readBytes = reader.read(charBuffer)) != -1) {
                int i = 0;
                while (i < readBytes) {
                    if (charBuffer[i] == '\n') {
                        if (i < readBytes - 1 && charBuffer[i + 1] == '\r') {
                            ++i;
                        }
                        if ((listFields = fieldDelimiter == 'N' ? this.readCsvLine(this.modelRowBuilder.toString(), fieldSeparator, columnCount) : this.readCsvLine(this.modelRowBuilder.toString(), fieldSeparator, fieldDelimiter, columnCount)) != null && listFields.size() > 0 && this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                            currentName = listFields.get(column);
                            if (lastSequenceName == null || !lastSequenceName.equals(currentName)) {
                                writer.append(this.modelRowBuilder.toString());
                                writer.newLine();
                            }
                            lastSequenceName = currentName;
                        }
                        this.modelRowBuilder.delete(0, this.modelRowBuilder.length());
                        row = new ArrayList();
                    } else if (charBuffer[i] == '\r') {
                        if (i < readBytes - 1 && charBuffer[i + 1] == '\n') {
                            ++i;
                        }
                        if ((listFields = fieldDelimiter == 'N' ? this.readCsvLine(this.modelRowBuilder.toString(), fieldSeparator, columnCount) : this.readCsvLine(this.modelRowBuilder.toString(), fieldSeparator, fieldDelimiter, columnCount)) != null && listFields.size() != 0) {
                            row.addAll(listFields);
                            if (this.modelRowBuilder.length() > 0 && this.modelRowBuilder.charAt(0) != '#') {
                                currentName = listFields.get(column);
                                if (lastSequenceName == null || !lastSequenceName.equals(currentName)) {
                                    writer.append(this.modelRowBuilder.toString());
                                    writer.newLine();
                                }
                                lastSequenceName = currentName;
                            }
                        }
                        this.modelRowBuilder.delete(0, this.modelRowBuilder.length());
                        row = new ArrayList();
                    } else {
                        this.modelRowBuilder.append(charBuffer[i]);
                    }
                    ++i;
                }
                totalRead += readBytes;
                if (counter % stepSize == 0) {
                    monitor.worked(stepSize);
                    monitor.subTask("Read " + decimalFormat.format((double)totalRead / 1048576.0) + "MB of " + decimalFormat.format(fileLenghtMB) + "MB");
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++counter;
            }
        }
        finally {
            reader.close();
            writer.close();
            monitor.done();
        }
    }

    public void filterMutiHit(int column, char fieldSeparator, char fieldDelimiter, String newFileName, int columnCount) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(newFileName));
        try {
            String line;
            String lastSequence = null;
            writer.append(MULTIHIT_LABEL + this.csvFile.getAbsolutePath());
            writer.newLine();
            while ((line = reader.readLine()) != null) {
                List<String> row = this.readCsvLine(line, fieldSeparator, fieldDelimiter, columnCount);
                if (lastSequence != null && row.get(column).equals(lastSequence)) continue;
                for (String s : row) {
                    writer.append(fieldDelimiter + s + fieldDelimiter + fieldSeparator);
                }
                writer.newLine();
                lastSequence = row.get(column);
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<List<String>> extractMatchingRows(File csvFile, String subject, int columnIndex, char separator, char delimiter, int columnCount) {
        ArrayList<List<String>> matchingRows = new ArrayList<List<String>>();
        boolean subjectFound = false;
        int lineCount = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(csvFile));){
            String line = null;
            while (true) {
                if ((line = reader.readLine()) == null) {
                    if (!subjectFound) return null;
                    ArrayList<List<String>> arrayList = matchingRows;
                    return arrayList;
                }
                List<String> row = this.readCsvLine(line, separator, delimiter, columnCount);
                String rowSubject = row.get(columnIndex);
                if (rowSubject.equals(subject)) {
                    if (!subjectFound) {
                        subjectFound = true;
                    }
                    row.add(0, String.valueOf(lineCount));
                    matchingRows.add(row);
                } else if (subjectFound) {
                    ArrayList<List<String>> arrayList = matchingRows;
                    return arrayList;
                }
                ++lineCount;
            }
        }
        catch (Exception e) {
            if (!this.debug) return null;
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean switchRows(int index1, int index2, boolean hasHeader) {
        StringBuilder buffer = new StringBuilder();
        if (hasHeader) {
            ++index1;
            ++index2;
        }
        if (index1 == index2) {
            return false;
        }
        if (index1 > index2) {
            int tmp = index1;
            index1 = index2;
            index2 = tmp;
        }
        try {
            File tempFile = new File(this.csvFile.getAbsolutePath() + ".tmp");
            BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
            try {
                String finalName;
                String firstLine = null;
                int i = 0;
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        buffer = null;
                        finalName = this.csvFile.getAbsolutePath();
                        if (this.csvFile.delete()) break;
                        return false;
                    }
                    if (i < index1) {
                        writer.append(line);
                        writer.newLine();
                    } else if (i == index1) {
                        firstLine = line;
                    } else if (i < index2) {
                        buffer.append(line + "\n");
                    } else if (i == index2) {
                        writer.append(line);
                        writer.newLine();
                        writer.append(buffer.toString());
                        writer.append(firstLine);
                        writer.newLine();
                    } else {
                        writer.append(line);
                        writer.newLine();
                    }
                    ++i;
                }
                tempFile.renameTo(new File(finalName));
                return true;
            }
            finally {
                reader.close();
                writer.close();
            }
        }
        catch (IOException e) {
            if (!this.debug) return false;
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateMultihitFromSinglehit(File multihitCsv, int queryColIndex, char fieldSeparator, char fieldDelimiter, char innerSeparator, int columnCount, IProgressMonitor monitor) {
        File tempFile = new File(multihitCsv.getAbsolutePath() + "_reloaded.csv");
        BufferedWriter writer = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));
            try {
                writer = new BufferedWriter(new FileWriter(tempFile));
                String line = reader.readLine();
                while ((line = reader.readLine()) != null) {
                    List<List<String>> matchingRows;
                    List<String> row = this.getRow(line, fieldSeparator, fieldDelimiter, innerSeparator);
                    String query = row.get(queryColIndex);
                    if (monitor != null) {
                        monitor.subTask(query);
                    }
                    if ((matchingRows = this.extractMatchingRows(multihitCsv, query, queryColIndex, fieldSeparator, fieldDelimiter, columnCount)) != null) {
                        for (List<String> mr : matchingRows) {
                            for (String s : mr) {
                                writer.append(fieldDelimiter + s + fieldDelimiter + fieldSeparator);
                            }
                            writer.newLine();
                        }
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    if (monitor == null || !monitor.isCanceled()) continue;
                    return false;
                }
                return true;
            }
            finally {
                reader.close();
                writer.close();
            }
        }
        catch (Exception e) {
            if (!this.debug) return false;
            e.printStackTrace();
            return false;
        }
    }

    public void parseFileLineCount(IProgressMonitor monitor) throws IOException, InterruptedException {
        this.parseFileLineCount(this.csvFile, monitor);
    }

    public void parseFileLineCount(File inputFile, IProgressMonitor monitor) throws IOException, InterruptedException {
        try {
            this.lineCount = 0;
            BufferedReader reader = new BufferedReader(new FileReader(inputFile));
            char[] buffer = new char[524288];
            int charsRead = 0;
            long totalChars = this.csvFile.length();
            int totalCharsRead = 0;
            DecimalFormat decimalFormat = new DecimalFormat("###,##0.00");
            monitor.beginTask("Count lines", Math.round((int)totalChars / 524288));
            while ((charsRead = reader.read(buffer)) != -1) {
                int i = 0;
                while (i < charsRead) {
                    char currentChar = buffer[i];
                    if (currentChar == '\n') {
                        if (i < charsRead - 1 && buffer[i + 1] == '\r') {
                            ++i;
                        }
                        ++this.lineCount;
                    } else if (currentChar == '\r') {
                        if (i < charsRead - 1 && buffer[i + 1] == '\n') {
                            ++i;
                        }
                        ++this.lineCount;
                    }
                    ++totalCharsRead;
                    ++i;
                }
                monitor.worked(1);
                monitor.subTask("Read " + decimalFormat.format(totalCharsRead / 0x100000) + " of " + decimalFormat.format(totalChars / 0x100000L) + " MB");
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
            this.parseLineCountDone = true;
        }
        finally {
            monitor.done();
        }
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public int getColumnCount() throws ColumnCountNotDoneException {
        if (!this.parseColumnCountDone) {
            throw new ColumnCountNotDoneException();
        }
        return this.columnCount;
    }

    public int getLineCount() throws LineCountNotDoneException {
        if (!this.parseLineCountDone) {
            throw new LineCountNotDoneException();
        }
        return this.lineCount;
    }

    public static String rowToString(List<String> dataRow, char separator, char delimiter, boolean removeFirstFileds) {
        StringBuilder builder = new StringBuilder();
        int startIndex = 0;
        if (removeFirstFileds) {
            startIndex = 2;
        }
        int i = startIndex;
        while (i < dataRow.size()) {
            builder.append(delimiter + dataRow.get(i) + delimiter + separator);
            ++i;
        }
        return builder.toString();
    }

    public boolean columnIsOrdered(int columnIndex, char separator, char delimiter, int columnCount) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));){
            String line;
            String previousRow = null;
            int lineCounter = 0;
            int previousComparation = 0;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.length() == 0) continue;
                if (lineCounter == 0) {
                    lineCounter = 1;
                    continue;
                }
                List<String> row = delimiter == 'N' ? this.readCsvLine(line, separator, columnCount) : this.readCsvLine(line, separator, delimiter, columnCount);
                String currentRow = row.get(columnIndex);
                if (previousRow == null) {
                    previousRow = currentRow;
                } else {
                    int resComp = currentRow.compareTo(previousRow);
                    System.out.println("Res: " + resComp);
                    if (resComp != 0) {
                        if (resComp > 0) {
                            if (previousComparation < 0) {
                                return false;
                            }
                            previousComparation = resComp;
                        } else {
                            if (previousComparation > 0) {
                                return false;
                            }
                            previousComparation = resComp;
                        }
                    }
                }
                previousRow = currentRow;
                ++lineCounter;
            }
        }
        return true;
    }

    public class ColumnCountNotDoneException
    extends Exception {
        private static final long serialVersionUID = -9171821831477919307L;
    }

    public class LineCountNotDoneException
    extends Exception {
        private static final long serialVersionUID = -5651142957330127449L;
    }

    public static enum Separators {
        SEMICOLON(0, ';'),
        COLON(1, ':'),
        SPACE(2, ' '),
        TAB(3, '\t'),
        COMMA(4, ',');

        private int index;
        private char separator;

        private Separators(int index, char separator) {
            this.index = index;
            this.separator = separator;
        }

        public int getIndex() {
            return this.index;
        }

        public char getSeparator() {
            return this.separator;
        }
    }
}

