/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.taxonomy;

import com.biotechvana.csveditor.jobs.taxonomy.AddGOsToCSV;
import com.biotechvana.utils.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class SearchGoHTTPRunnable2
implements IRunnableWithProgress {
    private final String NULLSTRING = "--UD--";
    public static final int FILE_NOT_FOUND = -1;
    private File[] inputFiles;
    private File outputFolder;
    private List<String> row;
    private NumberFormat nf = NumberFormat.getInstance();
    private int startColumn;
    private int columnGi = -1;
    private int columnAccession = -1;
    private int columnSubject = -1;
    int lineCount;

    public SearchGoHTTPRunnable2(File[] inputFiles, File outputFolder, int startColumn, int columnGi, int columnAccession, int columnSubject, int lineCount) {
        this.inputFiles = inputFiles;
        this.outputFolder = outputFolder;
        this.startColumn = startColumn;
        this.columnGi = columnGi;
        this.columnAccession = columnAccession;
        this.columnSubject = columnSubject;
        this.lineCount = lineCount;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.inputFiles.length == 1) {
            try {
                monitor.beginTask("Add GOs", 100);
                this.searchInFile(this.inputFiles[0], monitor);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        monitor.beginTask("Add GOs", this.inputFiles.length);
        int i = 0;
        while (i < this.inputFiles.length) {
            monitor.subTask("Reading file: " + this.inputFiles[i].getName());
            try {
                this.searchInFile(this.inputFiles[1], (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            ++i;
        }
        monitor.done();
    }

    private void searchInFile(File csvFile, IProgressMonitor monitor) throws IOException, InterruptedException {
        String basename = FilenameUtils.getBasename((String)csvFile.getName());
        String extension = FilenameUtils.getExtension((String)csvFile.getName());
        AddGOsToCSV addGos = new AddGOsToCSV(csvFile, this.columnGi, this.columnAccession, this.columnSubject, new File(this.outputFolder, basename + "_with_go" + extension), this.lineCount);
        addGos.run(monitor);
    }
}

