/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.taxonomy;

import com.biotechvana.csvUtils.CsvBufferedReader;
import com.biotechvana.csvUtils.CsvWriter;
import com.biotechvana.pipelineCommander.GproApiRequest;
import com.biotechvana.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddGOsToCSV {
    private final String NULLSTRING = "--UD--";
    public static final int FILE_NOT_FOUND = -1;
    private File fileInputCsv;
    private File fileOutputCsv;
    private int columnGi = -1;
    private int columnAccession = -1;
    private int columnSubject = -1;
    private boolean firstLineRead = false;
    private int lineCount;
    final int batchCount = 250;
    HashMap<String, List<GproApiRequest.Enzyme>> goCache = new HashMap();
    Set<String> go2ecNullCache = new HashSet<String>();

    public AddGOsToCSV(File fileInputCsv, int columnGi, int columnAccession, int columnSubject, File fileOutputCsv, int lineCount) {
        this.fileInputCsv = fileInputCsv;
        this.columnGi = columnGi;
        this.columnAccession = columnAccession;
        this.columnSubject = columnSubject;
        this.fileOutputCsv = fileOutputCsv;
        this.lineCount = lineCount;
    }

    public void run(IProgressMonitor monitor) throws IOException, InterruptedException {
        CsvBufferedReader csvReader = new CsvBufferedReader(this.fileInputCsv, ';', '\"');
        CsvWriter csvWriter = new CsvWriter(this.fileOutputCsv, ';', '\"');
        ArrayList<List<String>> rowsBatch = new ArrayList<List<String>>();
        try {
            csvReader.open();
            csvWriter.open();
            int lineCount = csvReader.getLineCount();
            if (lineCount == 0) {
                lineCount = this.lineCount;
            }
            int stepSize = 1;
            if (lineCount > 100) {
                stepSize = lineCount / 100;
            }
            int counter = 0;
            monitor.beginTask("Add GOs", 100);
            List row = csvReader.readLine();
            if (row != null) {
                row.add("GO#");
                row.add("GO");
                row.add("Evidence codes");
                row.add("Enzyme codes");
                csvWriter.write(row);
            }
            while ((row = csvReader.readLine()) != null) {
                rowsBatch.add(row);
                if (++counter % stepSize == 0) {
                    monitor.worked(1);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                if (rowsBatch.size() < 250) continue;
                this.processBatch(rowsBatch);
                for (List list : rowsBatch) {
                    csvWriter.write(list);
                }
                rowsBatch.clear();
            }
            if (rowsBatch.size() > 0) {
                this.processBatch(rowsBatch);
                for (List list : rowsBatch) {
                    csvWriter.write(list);
                }
                rowsBatch.clear();
            }
        }
        finally {
            if (csvReader != null) {
                csvReader.close();
            }
            if (csvWriter != null) {
                csvWriter.close();
            }
        }
    }

    private void processBatch(List<List<String>> rowsBatch) {
        block14: {
            block13: {
                String keyAccession;
                String keySubject;
                List<String> row;
                int i;
                if (this.columnSubject < 0) break block13;
                List<String> subjectsBatch = this.getSubjectbatch(rowsBatch);
                HashMap<String, GoAnnotation> annotations = this.getAnnotationBySubjects(subjectsBatch);
                if (this.columnAccession >= 0) {
                    ArrayList<String> rowsAccessionBatch = new ArrayList<String>();
                    i = 0;
                    while (i < rowsBatch.size()) {
                        row = rowsBatch.get(i);
                        keySubject = row.get(this.columnSubject).trim();
                        if (annotations.get(keySubject) == null && !(keyAccession = row.get(this.columnAccession).trim()).isEmpty()) {
                            rowsAccessionBatch.add(keyAccession);
                        }
                        ++i;
                    }
                    if (!rowsAccessionBatch.isEmpty()) {
                        annotations.putAll(this.getAnnotationByAccessions(rowsAccessionBatch));
                    }
                }
                GoAnnotation goAnnotation = null;
                i = 0;
                while (i < rowsBatch.size()) {
                    row = rowsBatch.get(i);
                    keySubject = row.get(this.columnSubject).trim();
                    if (annotations.containsKey(keySubject)) {
                        goAnnotation = annotations.get(keySubject);
                    }
                    if (goAnnotation == null && this.columnAccession >= 0) {
                        keyAccession = row.get(this.columnAccession).trim();
                        goAnnotation = annotations.get(keyAccession);
                    }
                    if (goAnnotation == null) {
                        goAnnotation = new GoAnnotation();
                    }
                    row.add(goAnnotation.goCount);
                    row.add(goAnnotation.goCodes);
                    row.add(goAnnotation.evidence);
                    row.add(goAnnotation.enzyme);
                    ++i;
                }
                break block14;
            }
            if (this.columnAccession < 0) break block14;
            ArrayList<String> rowsAccessionBatch = new ArrayList<String>();
            int i = 0;
            while (i < rowsBatch.size()) {
                List<String> row = rowsBatch.get(i);
                String keyAccession = row.get(this.columnAccession).trim();
                if (!keyAccession.isEmpty()) {
                    rowsAccessionBatch.add(keyAccession);
                }
                ++i;
            }
            if (!rowsAccessionBatch.isEmpty()) {
                HashMap<String, GoAnnotation> annotations = this.getAnnotationByAccessions(rowsAccessionBatch);
                GoAnnotation goAnnotation = null;
                int i2 = 0;
                while (i2 < rowsBatch.size()) {
                    List<String> row = rowsBatch.get(i2);
                    String keyAccession = row.get(this.columnAccession).trim();
                    goAnnotation = annotations.get(keyAccession);
                    if (goAnnotation == null) {
                        goAnnotation = new GoAnnotation();
                    }
                    row.add(goAnnotation.goCount);
                    row.add(goAnnotation.goCodes);
                    row.add(goAnnotation.evidence);
                    row.add(goAnnotation.enzyme);
                    ++i2;
                }
            }
        }
    }

    private HashMap<String, GoAnnotation> getAnnotationBySubjects(List<String> subjectsBatch) {
        HashMap<String, GoAnnotation> annotations = new HashMap<String, GoAnnotation>();
        List goEvidences = GproApiRequest.getGoByDescriptionInstance(subjectsBatch);
        ArrayList<String> gosBatch = new ArrayList<String>();
        int i = 0;
        while (i < subjectsBatch.size()) {
            GproApiRequest.GoEvidence goEvidence = (GproApiRequest.GoEvidence)goEvidences.get(i);
            if (goEvidence != null && goEvidence.getGoCount() > 0) {
                GoAnnotation goAnnotation = new GoAnnotation();
                goAnnotation.goCount = String.valueOf(goEvidence.getGoCount());
                goAnnotation.goCodes = goEvidence.go;
                goAnnotation.evidence = goEvidence.evidence;
                List goCodes = goEvidence.getGoCodes();
                gosBatch.addAll(goCodes);
                annotations.put(subjectsBatch.get(i), goAnnotation);
            } else {
                annotations.put(subjectsBatch.get(i), null);
            }
            ++i;
        }
        this.updateGosCache(gosBatch);
        for (GoAnnotation goAnnotation : annotations.values()) {
            if (goAnnotation == null) continue;
            List goCodes = GproApiRequest.GoEvidence.getGoCodes((String)goAnnotation.goCodes);
            HashSet listEnzymes = new HashSet();
            for (String go : goCodes) {
                if (!this.goCache.containsKey(go)) continue;
                listEnzymes.addAll(this.goCache.get(go));
            }
            if (listEnzymes.isEmpty()) continue;
            ArrayList<String> listEnzymeCodes = new ArrayList<String>();
            for (GproApiRequest.Enzyme enzyme : listEnzymes) {
                if (enzyme.ecid.trim().isEmpty()) continue;
                listEnzymeCodes.add(enzyme.ecid);
            }
            goAnnotation.enzyme = StringUtils.join(listEnzymeCodes, (String)";");
        }
        return annotations;
    }

    private HashMap<String, GoAnnotation> getAnnotationByAccessions(List<String> accessionsBatch) {
        HashMap<String, GoAnnotation> annotations = new HashMap<String, GoAnnotation>();
        List goEvidences = GproApiRequest.getGoBySwissprotAccessionInstance(accessionsBatch);
        ArrayList<String> gosBatch = new ArrayList<String>();
        int i = 0;
        while (i < accessionsBatch.size()) {
            GproApiRequest.GoEvidence goEvidence = (GproApiRequest.GoEvidence)goEvidences.get(i);
            if (goEvidence != null && goEvidence.getGoCount() > 0) {
                GoAnnotation goAnnotation = new GoAnnotation();
                goAnnotation.goCount = String.valueOf(goEvidence.getGoCount());
                goAnnotation.goCodes = goEvidence.go;
                goAnnotation.evidence = goEvidence.evidence;
                List goCodes = goEvidence.getGoCodes();
                gosBatch.addAll(goCodes);
                annotations.put(accessionsBatch.get(i), goAnnotation);
            } else {
                annotations.put(accessionsBatch.get(i), null);
            }
            ++i;
        }
        this.updateGosCache(gosBatch);
        for (GoAnnotation goAnnotation : annotations.values()) {
            if (goAnnotation == null) continue;
            List goCodes = GproApiRequest.GoEvidence.getGoCodes((String)goAnnotation.goCodes);
            HashSet listEnzymes = new HashSet();
            for (String go : goCodes) {
                if (!this.goCache.containsKey(go)) continue;
                listEnzymes.addAll(this.goCache.get(go));
            }
            if (listEnzymes.isEmpty()) continue;
            ArrayList<String> listEnzymeCodes = new ArrayList<String>();
            for (GproApiRequest.Enzyme enzyme : listEnzymes) {
                if (enzyme.ecid.trim().isEmpty()) continue;
                listEnzymeCodes.add(enzyme.ecid);
            }
            goAnnotation.enzyme = StringUtils.join(listEnzymeCodes, (String)";");
        }
        return annotations;
    }

    private void updateGosCache(List<String> gosBatch) {
        if (gosBatch.isEmpty()) {
            return;
        }
        HashSet<String> goSet = new HashSet<String>();
        for (String go : gosBatch) {
            if (this.go2ecNullCache.contains(go)) {
                goSet.remove(go);
            } else {
                goSet.add(go);
            }
            if (goSet.size() < 250) continue;
            List listEnzymes = GproApiRequest.getEnzymeInstanceByGo(goSet);
            for (GproApiRequest.Enzyme ec : listEnzymes) {
                if (!this.goCache.containsKey(ec.go)) {
                    this.goCache.put(ec.go, new ArrayList());
                }
                this.goCache.get(ec.go).add(ec);
            }
            for (String qGo : goSet) {
                if (this.goCache.containsKey(qGo)) continue;
                this.go2ecNullCache.add(qGo);
            }
            goSet.clear();
        }
        if (goSet.size() > 0) {
            List listEnzymes = GproApiRequest.getEnzymeInstanceByGo(goSet);
            for (GproApiRequest.Enzyme ec : listEnzymes) {
                if (!this.goCache.containsKey(ec.go)) {
                    this.goCache.put(ec.go, new ArrayList());
                }
                this.goCache.get(ec.go).add(ec);
            }
            for (String qGo : goSet) {
                if (this.goCache.containsKey(qGo)) continue;
                this.go2ecNullCache.add(qGo);
            }
            goSet.clear();
        }
    }

    private List<String> getSubjectbatch(List<List<String>> rowsBatch) {
        ArrayList<String> subjects = new ArrayList<String>();
        int i = 0;
        while (i < rowsBatch.size()) {
            List<String> row = rowsBatch.get(i);
            String keySubject = row.get(this.columnSubject).trim();
            if (!keySubject.isEmpty() && !keySubject.equals("No significant similarities found")) {
                subjects.add(keySubject);
            }
            ++i;
        }
        return subjects;
    }

    @Deprecated
    private GoAnnotation appendBySubject(List<String> row, String keySubject) throws IOException {
        GoAnnotation goAnnotation = null;
        GproApiRequest.GoEvidence goEvidence = null;
        goEvidence = keySubject.trim().isEmpty() || keySubject.equals("No significant similarities found") ? null : GproApiRequest.getGoByDescriptionInstance((String)keySubject);
        if (goEvidence != null && goEvidence.getGoCount() > 0) {
            goAnnotation = new GoAnnotation();
            goAnnotation.goCount = String.valueOf(goEvidence.getGoCount());
            goAnnotation.goCodes = goEvidence.go;
            goAnnotation.evidence = goEvidence.evidence;
            List goCodes = goEvidence.getGoCodes();
            Collection listEnzymes = GproApiRequest.getEnzymeByGo((List)goCodes);
            if (listEnzymes != null && !listEnzymes.isEmpty()) {
                ArrayList<String> listEnzymeCodes = new ArrayList<String>();
                for (GproApiRequest.Enzyme enzyme : listEnzymes) {
                    if (enzyme.ecid.trim().isEmpty() || listEnzymeCodes.contains(enzyme.ecid)) continue;
                    listEnzymeCodes.add(enzyme.ecid);
                }
                goAnnotation.enzyme = StringUtils.join(listEnzymeCodes, (String)";");
            }
        }
        return goAnnotation;
    }

    @Deprecated
    private GoAnnotation appendByAccession(List<String> row, String keyAccession) throws IOException {
        GoAnnotation goAnnotation = null;
        GproApiRequest.GoEvidence goEvidence = null;
        goEvidence = keyAccession.trim().isEmpty() ? null : GproApiRequest.getGoBySwissprotAccessionInstance((String)keyAccession);
        if (goEvidence != null && goEvidence.getGoCount() > 0) {
            goAnnotation = new GoAnnotation();
            goAnnotation.goCount = String.valueOf(goEvidence.getGoCount());
            goAnnotation.goCodes = goEvidence.go;
            goAnnotation.evidence = goEvidence.evidence;
            List goCodes = goEvidence.getGoCodes();
            Collection listEnzymes = GproApiRequest.getEnzymeByGo((List)goCodes);
            if (listEnzymes != null && !listEnzymes.isEmpty()) {
                ArrayList<String> listEnzymeCodes = new ArrayList<String>();
                for (GproApiRequest.Enzyme enzyme : listEnzymes) {
                    if (enzyme.ecid.trim().isEmpty() || listEnzymeCodes.contains(enzyme.ecid)) continue;
                    listEnzymeCodes.add(enzyme.ecid);
                }
                goAnnotation.enzyme = StringUtils.join(listEnzymeCodes, (String)";");
            }
        }
        return goAnnotation;
    }

    private class GoAnnotation {
        public String goCount = "0";
        public String goCodes = "--UD--";
        public String evidence = "--UD--";
        public String enzyme = "--UD--";

        private GoAnnotation() {
        }
    }
}

