/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.taxonomy;

import com.biotechvana.csvUtils.CsvBufferedReader;
import com.biotechvana.csvUtils.CsvWriter;
import com.biotechvana.pipelineCommander.GproApiRequest;
import com.biotechvana.utils.FilenameUtils;
import com.biotechvana.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class AddAnnotationsToCSVRunnable
implements IRunnableWithProgress {
    private final String NULLSTRING = "--UD--";
    public static final int FILE_NOT_FOUND = -1;
    private File[] arrayFileInputCsv;
    private File folderOutput;
    private int inputDataType = -1;
    private int inputColumnIndex = -1;
    private List<Integer> listAppend = new ArrayList<Integer>();
    private Map<String, List<String>> mapSubjectGos = new HashMap<String, List<String>>();
    public static final int DATA_TYPE_GI = 0;
    public static final int DATA_TYPE_SUBJECT = 1;
    public static final int DATA_TYPE_ACCESSION_GENBANK = 2;
    public static final int DATA_TYPE_ACCESSION_SWISSPROT = 3;
    public static final int DATA_TYPE_GENE_NAME = 4;
    public static final int DATA_TYPE_GO = 5;
    public static final int DATA_TYPE_EVIDENCE = 6;
    public static final int DATA_TYPE_ENZYME = 7;
    public static final int DATA_TYPE_ACCESSION_UNIPROT = 8;
    public static final int DATA_TYPE_INTERPRO = 9;

    public AddAnnotationsToCSVRunnable(File[] arrayFileInputCsv, File folderOutput, int inputColumnIndex, int inputDataType, List<Integer> listAppend) {
        this.arrayFileInputCsv = arrayFileInputCsv;
        this.folderOutput = folderOutput;
        this.inputColumnIndex = inputColumnIndex;
        this.inputDataType = inputDataType;
        this.listAppend = listAppend;
    }

    public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        if (this.arrayFileInputCsv.length > 1) {
            try {
                this.parseFileMulti(monitor);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.parseFileSingle(this.arrayFileInputCsv[0], monitor);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void parseFileMulti(IProgressMonitor monitor) throws InterruptedException, IOException {
        monitor.beginTask("Add annotations", this.arrayFileInputCsv.length);
        File[] fileArray = this.arrayFileInputCsv;
        int n = this.arrayFileInputCsv.length;
        int n2 = 0;
        while (n2 < n) {
            File fileInputCsv = fileArray[n2];
            monitor.subTask("Parsing file: " + fileInputCsv.getName());
            this.parseFileSingle(fileInputCsv, (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            ++n2;
        }
        monitor.done();
    }

    private void parseFileSingle(File fileInputCsv, IProgressMonitor monitor) throws IOException, InterruptedException {
        CsvBufferedReader csvReader = new CsvBufferedReader(fileInputCsv, ';', '\"');
        String inputBasename = FilenameUtils.getBasename((String)fileInputCsv.getName());
        File newOutputFile = new File(this.folderOutput, inputBasename + "_annotated.csv");
        CsvWriter csvWriter = new CsvWriter(newOutputFile, ';', '\"');
        try {
            csvReader.open();
            csvWriter.open();
            int lineCount = csvReader.getLineCount();
            int stepSize = 1;
            if (lineCount > 100) {
                stepSize = lineCount / 100;
            }
            int counter = 0;
            monitor.beginTask("Add annotations", 100);
            List row = csvReader.readLine();
            row.addAll(this.getAppendHeaderNames());
            csvWriter.write(row);
            while ((row = csvReader.readLine()) != null) {
                String keyValue = ((String)row.get(this.inputColumnIndex)).trim();
                List<String> newValues = this.getDataFromTo(keyValue);
                row.addAll(newValues);
                csvWriter.write(row);
                if (++counter % stepSize == 0) {
                    monitor.worked(1);
                }
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            if (csvReader != null) {
                csvReader.close();
            }
            if (csvWriter != null) {
                csvWriter.close();
            }
        }
    }

    private List<String> getAppendHeaderNames() {
        ArrayList<String> appendHeaders = new ArrayList<String>();
        for (int i : this.listAppend) {
            if (i == 2) {
                appendHeaders.add("Genbank accession");
                continue;
            }
            if (i == 3) {
                appendHeaders.add("SwissProt accession");
                continue;
            }
            if (i == 8) {
                appendHeaders.add("UniProt accession");
                continue;
            }
            if (i == 7) {
                appendHeaders.add("Enzyme code");
                continue;
            }
            if (i == 6) {
                appendHeaders.add("Evidence code");
                continue;
            }
            if (i == 4) {
                appendHeaders.add("Gene name");
                continue;
            }
            if (i == 0) {
                appendHeaders.add("GI");
                continue;
            }
            if (i == 5) {
                if (this.inputDataType == 1) {
                    appendHeaders.add("GOs");
                    appendHeaders.add("GO");
                    appendHeaders.add("Evidence code");
                    appendHeaders.add("Enzyme code");
                    continue;
                }
                appendHeaders.add("GO");
                continue;
            }
            if (i != 9) continue;
            appendHeaders.add("InterPro");
        }
        return appendHeaders;
    }

    private List<String> getDataFromTo(String value) {
        ArrayList<String> listNewValues;
        block21: {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block20: {
                                        listNewValues = new ArrayList<String>();
                                        if (this.inputDataType != 0) break block20;
                                        for (int dt : this.listAppend) {
                                            try {
                                                listNewValues.add(this.getDataFromGi(dt, value));
                                            }
                                            catch (IOException e) {
                                                listNewValues.add("");
                                            }
                                        }
                                        break block21;
                                    }
                                    if (this.inputDataType != 2) break block22;
                                    for (int dt : this.listAppend) {
                                        try {
                                            listNewValues.add(this.getDataFromAccessionGenbank(dt, value));
                                        }
                                        catch (IOException e) {
                                            listNewValues.add("");
                                        }
                                    }
                                    break block21;
                                }
                                if (this.inputDataType != 3) break block23;
                                for (int dt : this.listAppend) {
                                    try {
                                        listNewValues.add(this.getDataFromAccessionSwissprot(dt, value));
                                    }
                                    catch (IOException e) {
                                        listNewValues.add("");
                                    }
                                }
                                break block21;
                            }
                            if (this.inputDataType != 8) break block24;
                            for (int dt : this.listAppend) {
                                try {
                                    listNewValues.add(this.getDataFromAccessionUniprot(dt, value));
                                }
                                catch (IOException e) {
                                    listNewValues.add("");
                                }
                            }
                            break block21;
                        }
                        if (this.inputDataType != 1) break block25;
                        for (int dt : this.listAppend) {
                            try {
                                listNewValues.addAll(this.getDataFromSubject(dt, value));
                            }
                            catch (IOException e) {
                                listNewValues.add("");
                            }
                        }
                        break block21;
                    }
                    if (this.inputDataType != 4) break block26;
                    for (int dt : this.listAppend) {
                        listNewValues.add(this.getDataFromGeneName(dt, value));
                    }
                    break block21;
                }
                if (this.inputDataType != 5) break block27;
                for (int dt : this.listAppend) {
                    try {
                        listNewValues.add(this.getDataFromGo(dt, value));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                break block21;
            }
            if (this.inputDataType != 7) break block21;
            for (int dt : this.listAppend) {
                listNewValues.add(this.getDataFromEnzyme(dt, value));
            }
        }
        return listNewValues;
    }

    private String getDataFromGi(int dataTypeTo, String gi) throws IOException {
        if (gi == null || gi.isEmpty()) {
            return "";
        }
        if (dataTypeTo != 2) {
            if (dataTypeTo == 3) {
                return GproApiRequest.gi2accessionSwissprot((String)gi);
            }
            if (dataTypeTo != 8) {
                if (dataTypeTo == 4) {
                    return GproApiRequest.gi2geneName((String)gi);
                }
                if (dataTypeTo != 0) {
                    if (dataTypeTo == 5) {
                        return StringUtils.join((List)GproApiRequest.gi2go((String)gi), (String)";");
                    }
                    if (dataTypeTo == 1 || dataTypeTo == 7 || dataTypeTo != 6) {
                        // empty if block
                    }
                }
            }
        }
        return "";
    }

    private String getDataFromAccessionGenbank(int dataTypeTo, String accession) throws IOException {
        if (accession == null || accession.isEmpty()) {
            return "";
        }
        if (dataTypeTo != 2 && dataTypeTo != 3 && dataTypeTo != 8) {
            if (dataTypeTo == 4) {
                return GproApiRequest.genbank2gene_name((String)accession);
            }
            if (dataTypeTo == 0 || dataTypeTo == 5 || dataTypeTo == 1 || dataTypeTo == 7 || dataTypeTo != 9) {
                // empty if block
            }
        }
        return "";
    }

    private String getDataFromAccessionSwissprot(int dataTypeTo, String swissprot) throws IOException {
        if (swissprot == null || swissprot.isEmpty()) {
            return "";
        }
        if (dataTypeTo != 2 && dataTypeTo != 3) {
            if (dataTypeTo == 8) {
                return GproApiRequest.swissprot2accessionUniprot((String)swissprot);
            }
            if (dataTypeTo != 4) {
                if (dataTypeTo == 0) {
                    return GproApiRequest.swissprot2gi((String)swissprot);
                }
                if (dataTypeTo == 5) {
                    return StringUtils.join((List)GproApiRequest.swissprot2go((String)swissprot), (String)";");
                }
                if (dataTypeTo == 1 || dataTypeTo == 7 || dataTypeTo != 6) {
                    // empty if block
                }
            }
        }
        return "";
    }

    private String getDataFromAccessionUniprot(int dataTypeTo, String uniprot) throws IOException {
        if (uniprot == null || uniprot.isEmpty()) {
            return "";
        }
        if (dataTypeTo != 2) {
            if (dataTypeTo == 3) {
                return GproApiRequest.uniprot2AccessionSwissprot((String)uniprot);
            }
            if (dataTypeTo != 8) {
                if (dataTypeTo == 4) {
                    return StringUtils.join((List)GproApiRequest.uniprot2geneName((String)uniprot), (String)";");
                }
                if (dataTypeTo == 0) {
                    return GproApiRequest.uniprot2gi((String)uniprot);
                }
                if (dataTypeTo == 5) {
                    return StringUtils.join((List)GproApiRequest.uniprot2go((String)uniprot), (String)";");
                }
                if (dataTypeTo != 1 && dataTypeTo != 7 && dataTypeTo != 6 && dataTypeTo == 9) {
                    return StringUtils.join((List)GproApiRequest.uniprot2interpro((String)uniprot), (String)";");
                }
            }
        }
        return "";
    }

    private List<String> getDataFromSubject(int dataTypeTo, String subject) throws IOException {
        if (subject == null || subject.isEmpty()) {
            String[] goData = new String[]{"", "", "", ""};
            return Arrays.asList(new String[goData.length]);
        }
        if (dataTypeTo != 2 && dataTypeTo != 3 && dataTypeTo != 8 && dataTypeTo != 4 && dataTypeTo != 0) {
            if (dataTypeTo == 5) {
                if (this.mapSubjectGos.containsKey(subject)) {
                    return this.mapSubjectGos.get(subject);
                }
                GoAnnotation goAnnotation = this.appendGoBySubject(subject);
                ArrayList<String> listGoData = new ArrayList<String>();
                listGoData.add(goAnnotation.goCount);
                listGoData.add(goAnnotation.goCodes);
                listGoData.add(goAnnotation.evidence);
                listGoData.add(goAnnotation.enzyme);
                this.mapSubjectGos.put(subject, listGoData);
                return listGoData;
            }
            if (dataTypeTo == 1 || dataTypeTo == 7 || dataTypeTo != 6) {
                // empty if block
            }
        }
        String[] goData = new String[]{"", "", "", ""};
        return Arrays.asList(new String[goData.length]);
    }

    private String getDataFromGeneName(int dataTypeTo, String geneName) {
        if (geneName == null || geneName.isEmpty()) {
            return "";
        }
        if (dataTypeTo == 2 || dataTypeTo == 3 || dataTypeTo == 8 || dataTypeTo == 4 || dataTypeTo == 0 || dataTypeTo == 5 || dataTypeTo == 1 || dataTypeTo == 7 || dataTypeTo != 6) {
            // empty if block
        }
        return "";
    }

    private String getDataFromGo(int dataTypeTo, String go) throws IOException {
        if (go == null || go.isEmpty()) {
            return "";
        }
        if (dataTypeTo != 2) {
            if (dataTypeTo == 3) {
                return GproApiRequest.go2accessionSwissprot((String)go);
            }
            if (dataTypeTo == 8) {
                return GproApiRequest.go2accessionUniprot((String)go);
            }
            if (dataTypeTo != 4 && dataTypeTo != 0 && dataTypeTo != 5 && dataTypeTo != 1) {
                if (dataTypeTo == 7) {
                    return GproApiRequest.go2enzyme((String)go);
                }
                if (dataTypeTo != 6) {
                    // empty if block
                }
            }
        }
        return "";
    }

    private String getDataFromEnzyme(int dataTypeTo, String enzyme) {
        if (enzyme == null || enzyme.isEmpty()) {
            return "";
        }
        if (dataTypeTo == 2 || dataTypeTo == 3 || dataTypeTo == 8 || dataTypeTo == 4 || dataTypeTo == 0 || dataTypeTo == 5 || dataTypeTo == 1 || dataTypeTo == 7 || dataTypeTo != 6) {
            // empty if block
        }
        return "";
    }

    private List<String> getOutputColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>();
        if (this.listAppend.contains("Enzyme")) {
            columnNames.add("Enzyme");
        }
        if (this.listAppend.contains("Evidence codes")) {
            columnNames.add("Evidence codes");
        }
        if (this.listAppend.contains("GO")) {
            columnNames.add("GO");
        }
        return columnNames;
    }

    private GoAnnotation appendGoBySubject(String keySubject) throws IOException {
        GoAnnotation goAnnotation = new GoAnnotation();
        GproApiRequest.GoEvidence goEvidence = null;
        goEvidence = keySubject.trim().isEmpty() || keySubject.equals("No significant similarities found") ? null : GproApiRequest.getGoByDescriptionInstance((String)keySubject);
        if (goEvidence != null && goEvidence.getGoCount() > 0) {
            goAnnotation = new GoAnnotation();
            goAnnotation.goCount = String.valueOf(goEvidence.getGoCount());
            goAnnotation.goCodes = goEvidence.go;
            goAnnotation.evidence = goEvidence.evidence;
            List goCodes = goEvidence.getGoCodes();
            Collection listEnzymes = GproApiRequest.getEnzymeByGo((List)goCodes);
            if (listEnzymes != null && !listEnzymes.isEmpty()) {
                ArrayList<String> listEnzymeCodes = new ArrayList<String>();
                for (GproApiRequest.Enzyme enzyme : listEnzymes) {
                    if (enzyme.ecid.trim().isEmpty() || listEnzymeCodes.contains(enzyme.ecid)) continue;
                    listEnzymeCodes.add(enzyme.ecid);
                }
                goAnnotation.enzyme = StringUtils.join(listEnzymeCodes, (String)";");
            }
        }
        return goAnnotation;
    }

    private GoAnnotation appendGoByAccession(String keyAccession) throws IOException {
        GoAnnotation goAnnotation = null;
        GproApiRequest.GoEvidence goEvidence = null;
        goEvidence = keyAccession.trim().isEmpty() ? null : GproApiRequest.getGoBySwissprotAccessionInstance((String)keyAccession);
        if (goEvidence != null && goEvidence.getGoCount() > 0) {
            goAnnotation = new GoAnnotation();
            goAnnotation.goCount = String.valueOf(goEvidence.getGoCount());
            goAnnotation.goCodes = goEvidence.go;
            goAnnotation.evidence = goEvidence.evidence;
            List goCodes = goEvidence.getGoCodes();
            Collection listEnzymes = GproApiRequest.getEnzymeByGo((List)goCodes);
            if (listEnzymes != null && !listEnzymes.isEmpty()) {
                ArrayList<String> listEnzymeCodes = new ArrayList<String>();
                for (GproApiRequest.Enzyme enzyme : listEnzymes) {
                    if (enzyme.ecid.trim().isEmpty() || listEnzymeCodes.contains(enzyme.ecid)) continue;
                    listEnzymeCodes.add(enzyme.ecid);
                }
                goAnnotation.enzyme = StringUtils.join(listEnzymeCodes, (String)";");
            }
        }
        return goAnnotation;
    }

    private GoAnnotation appendEvidenceByGo(String keyGo) {
        GoAnnotation goAnnotation = null;
        GproApiRequest.GoEvidence goEvidence = null;
        goEvidence = keyGo.trim().isEmpty() ? null : GproApiRequest.getGoDataByIdInstance((String)keyGo);
        if (goEvidence != null && goEvidence.getGoCount() > 0) {
            goAnnotation = new GoAnnotation();
            goAnnotation.goCount = String.valueOf(goEvidence.getGoCount());
            goAnnotation.goCodes = goEvidence.go;
            goAnnotation.evidence = goEvidence.evidence;
            List goCodes = goEvidence.getGoCodes();
            Collection listEnzymes = GproApiRequest.getEnzymeByGo((List)goCodes);
            if (listEnzymes != null && !listEnzymes.isEmpty()) {
                ArrayList<String> listEnzymeCodes = new ArrayList<String>();
                for (GproApiRequest.Enzyme enzyme : listEnzymes) {
                    if (enzyme.ecid.trim().isEmpty() || listEnzymeCodes.contains(enzyme.ecid)) continue;
                    listEnzymeCodes.add(enzyme.ecid);
                }
                goAnnotation.enzyme = StringUtils.join(listEnzymeCodes, (String)";");
            }
        }
        return goAnnotation;
    }

    private class GoAnnotation {
        public String goCount = "0";
        public String goCodes = "--UD--";
        public String evidence = "--UD--";
        public String enzyme = "--UD--";

        private GoAnnotation() {
        }

        public List<String> asList() {
            ArrayList<String> listValues = new ArrayList<String>();
            listValues.add(this.goCount);
            listValues.add(this.goCodes);
            listValues.add(this.evidence);
            listValues.add(this.enzyme);
            return listValues;
        }
    }
}

