/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.keggViewer;

import com.biotechvana.e3utils.WorkspaceUtils;
import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class KeggMapDownloadJob
extends Job {
    private String mapId;
    private String outputFile;
    private boolean status = true;

    public KeggMapDownloadJob(String name, String mapId, String outputFile) {
        super(name);
        this.mapId = mapId;
        this.outputFile = outputFile;
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                WorkspaceUtils.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        KeggMapDownloadJob.this.finish();
                    }
                });
            }
        });
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.status = this.downloadMap(this.mapId, this.outputFile, monitor);
        return Status.OK_STATUS;
    }

    public boolean downloadMap(String mapId, String outputFile, IProgressMonitor monitor) {
        if (outputFile == null) {
            return false;
        }
        try {
            int b;
            URL url = new URL("http://www.genome.jp/kegg/pathway/map/" + mapId + ".png");
            URLConnection connection = url.openConnection();
            int contentLength = -1;
            try {
                contentLength = connection.getContentLength();
            }
            catch (Exception ex) {
                contentLength = -1;
            }
            if (monitor != null) {
                monitor.beginTask("Download KEGG map", contentLength);
            }
            InputStream in = url.openStream();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));
            while ((b = in.read()) != -1) {
                ((OutputStream)out).write(b);
                if (monitor == null) continue;
                monitor.worked(1);
            }
            ((OutputStream)out).close();
            in.close();
            if (monitor != null) {
                monitor.done();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void finish() {
        this.refreshViewer();
        if (!this.status) {
            MessageDialog.openError((Shell)WorkspaceUtils.getShell(), (String)"KEGG Viewer", (String)"Error downloading KEGG map");
        } else {
            MessageDialog.openInformation((Shell)WorkspaceUtils.getShell(), (String)"KEGG Viewer", (String)"KEGG map downloaded successfully");
        }
    }

    public void refreshViewer() {
        FileExplorerBasic fileExplorer = (FileExplorerBasic)WorkspaceUtils.findView((String)FileExplorerBasic.ID);
        fileExplorer.getFileViewer().refresh((Object)new File(this.outputFile).getParent());
    }
}

