/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvAction;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionColumnSplit;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvUndoColumnSplitRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Undo split columns";
    private CSVEditor csvEditor;
    private CsvAction lastAction;
    private List<CsvAction> listActions = new ArrayList<CsvAction>();
    private List<CsvAction> undoActions = new ArrayList<CsvAction>();
    private List<List<String>> model;
    private List<String> row;
    private int[] splitIndices;

    public CsvUndoColumnSplitRunnable(CSVEditor csvEditor, CsvAction lastAction) {
        this.csvEditor = csvEditor;
        this.lastAction = lastAction;
        this.listActions = csvEditor.getListActions();
        this.model = (List)csvEditor.getModel();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long lastTimestamp = this.lastAction.getTimestamp();
        int counter = this.listActions.size() - 1;
        CsvAction ac = this.listActions.get(counter);
        while (counter >= 0) {
            ac = this.listActions.get(counter);
            if (ac == null || ac.getTimestamp() != lastTimestamp || ac.getType() != 13) break;
            this.undoActions.add(this.listActions.remove(counter));
            --counter;
        }
        this.undoSplit(monitor);
    }

    private void undoSplit(IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Undo split columns", this.undoActions.size() * this.model.size());
            for (CsvAction action : this.undoActions) {
                CsvActionColumnSplit splitAction = (CsvActionColumnSplit)action;
                final List<String> splitNames = splitAction.getListSplitNames();
                this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CsvUndoColumnSplitRunnable.this.splitIndices = CsvUndoColumnSplitRunnable.this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(splitNames);
                    }
                });
                int i = 1;
                while (i < splitNames.size()) {
                    final String fname = splitNames.get(i);
                    this.csvEditor.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CsvUndoColumnSplitRunnable.this.csvEditor.deleteColumn(new String[]{fname}, false);
                        }
                    });
                    ++i;
                }
                int firstColumn = this.splitIndices[0];
                int i2 = 0;
                while (i2 < this.model.size()) {
                    this.row = this.model.get(i2);
                    int j = 1;
                    while (j < this.splitIndices.length) {
                        this.row.set(firstColumn, this.row.get(firstColumn) + splitAction.getSeparator() + this.row.get(this.splitIndices[j]));
                        ++j;
                    }
                    this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CsvUndoColumnSplitRunnable.this.csvEditor.getTableViewer().update(CsvUndoColumnSplitRunnable.this.row, null);
                        }
                    });
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    ++i2;
                }
            }
        }
        finally {
            monitor.done();
        }
    }
}

