/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvAction;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionColumnSort;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class CsvUndoColumnSortRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Undo sort column";
    private CSVEditor csvEditor;
    private CsvAction lastAction;
    private List<CsvAction> listActions = new ArrayList<CsvAction>();
    private List<CsvAction> undoActions = new ArrayList<CsvAction>();
    private Shell shell;

    public CsvUndoColumnSortRunnable(CSVEditor csvEditor, CsvAction lastAction) {
        this.csvEditor = csvEditor;
        this.lastAction = lastAction;
        this.listActions = csvEditor.getListActions();
        this.shell = csvEditor.getSite().getShell();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long lastTimestamp = this.lastAction.getTimestamp();
        int counter = this.listActions.size() - 1;
        CsvAction ac = this.listActions.get(counter);
        while (counter >= 0) {
            ac = this.listActions.get(counter);
            if (ac == null || ac.getTimestamp() != lastTimestamp || ac.getType() != 16) break;
            this.undoActions.add(this.listActions.remove(counter));
            --counter;
        }
        this.undoSort(monitor);
    }

    private void undoSort(IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Undo sort column", -1);
            for (CsvAction action : this.undoActions) {
                final CsvActionColumnSort sortAction = (CsvActionColumnSort)action;
                this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CsvUndoColumnSortRunnable.this.csvEditor.getTableViewer().setInput(sortAction.getModel());
                    }
                });
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }
}

