/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvAction;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionColumnJoin;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class CsvUndoColumnJoinRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Undo join columns";
    private CSVEditor csvEditor;
    private CsvAction lastAction;
    private List<CsvAction> listActions = new ArrayList<CsvAction>();
    private List<CsvAction> undoActions = new ArrayList<CsvAction>();
    private List<List<String>> model;
    private List<String> row;
    private Shell shell;

    public CsvUndoColumnJoinRunnable(CSVEditor csvEditor, CsvAction lastAction) {
        this.csvEditor = csvEditor;
        this.lastAction = lastAction;
        this.listActions = csvEditor.getListActions();
        this.shell = csvEditor.getSite().getShell();
        this.model = (List)csvEditor.getModel();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long lastTimestamp = this.lastAction.getTimestamp();
        int counter = this.listActions.size() - 1;
        CsvAction ac = this.listActions.get(counter);
        while (counter >= 0) {
            ac = this.listActions.get(counter);
            if (ac == null || ac.getTimestamp() != lastTimestamp || ac.getType() != 12) break;
            this.undoActions.add(this.listActions.remove(counter));
            --counter;
        }
        this.undoJoin(monitor);
    }

    private void undoJoin(IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask("Undo join columns", this.undoActions.size());
                for (CsvAction action : this.undoActions) {
                    final CsvActionColumnJoin joinAction = (CsvActionColumnJoin)action;
                    this.shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            int[] indices = joinAction.getIndices();
                            String separator = joinAction.getSeparator();
                            int i = 0;
                            while (i < indices.length) {
                                CsvUndoColumnJoinRunnable.this.csvEditor.getTable().getColumn(indices[i]).setWidth(100);
                                CsvUndoColumnJoinRunnable.this.csvEditor.getTable().getColumn(indices[i]).setText(CsvUndoColumnJoinRunnable.this.csvEditor.getTable().getColumn(indices[i]).getText().replace("!@_", ""));
                                ++i;
                            }
                            i = 0;
                            while (i < CsvUndoColumnJoinRunnable.this.model.size()) {
                                CsvUndoColumnJoinRunnable.this.row = CsvUndoColumnJoinRunnable.this.model.get(i);
                                String value = CsvUndoColumnJoinRunnable.this.row.get(indices[0]);
                                if (value != null && value.length() > 0) {
                                    if (separator.equals("|")) {
                                        separator = "\\|";
                                    }
                                    String[] parts = value.split(separator);
                                    int j = 0;
                                    while (j < indices.length) {
                                        if (j < parts.length) {
                                            CsvUndoColumnJoinRunnable.this.row.set(indices[j], parts[j]);
                                        } else {
                                            CsvUndoColumnJoinRunnable.this.row.set(indices[j], "");
                                        }
                                        ++j;
                                    }
                                } else {
                                    int j = 0;
                                    while (j < indices.length) {
                                        CsvUndoColumnJoinRunnable.this.row.set(indices[j], "");
                                        ++j;
                                    }
                                }
                                CsvUndoColumnJoinRunnable.this.csvEditor.getTableViewer().update(CsvUndoColumnJoinRunnable.this.row, null);
                                ++i;
                            }
                        }
                    });
                    monitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    throw new InterruptedException();
                }
            }
            catch (Exception exception) {
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

