/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvAction;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionColumnHide;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvUndoColumnHideRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Undo hide columns";
    private CSVEditor csvEditor;
    private CsvAction lastAction;
    private List<CsvAction> listActions = new ArrayList<CsvAction>();
    private List<CsvAction> undoActions = new ArrayList<CsvAction>();

    public CsvUndoColumnHideRunnable(CSVEditor csvEditor, CsvAction lastAction) {
        this.csvEditor = csvEditor;
        this.lastAction = lastAction;
        this.listActions = csvEditor.getListActions();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long lastTimestamp = this.lastAction.getTimestamp();
        int counter = this.listActions.size() - 1;
        CsvAction ac = this.listActions.get(counter);
        while (counter >= 0) {
            ac = this.listActions.get(counter);
            if (ac == null || ac.getTimestamp() != lastTimestamp || ac.getType() != 15) break;
            this.undoActions.add(this.listActions.remove(counter));
            --counter;
        }
        this.undoHide(monitor);
    }

    private void undoHide(IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Undo hide columns", this.undoActions.size());
            for (CsvAction action : this.undoActions) {
                final CsvActionColumnHide hideAction = (CsvActionColumnHide)action;
                final int columnIndex = hideAction.getRowIndex();
                this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CsvUndoColumnHideRunnable.this.csvEditor.getTable().getColumn(columnIndex).setWidth(hideAction.getPreviousWidth());
                    }
                });
            }
        }
        finally {
            monitor.done();
        }
    }
}

