/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvAction;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionColumnEdit;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class CsvUndoColumnEditRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Undo column rename";
    private CSVEditor csvEditor;
    private CsvAction lastAction;
    private List<CsvAction> listActions = new ArrayList<CsvAction>();
    private List<CsvAction> undoActions = new ArrayList<CsvAction>();
    private Shell shell;

    public CsvUndoColumnEditRunnable(CSVEditor csvEditor, CsvAction lastAction) {
        this.csvEditor = csvEditor;
        this.lastAction = lastAction;
        this.listActions = csvEditor.getListActions();
        this.shell = csvEditor.getSite().getShell();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long lastTimestamp = this.lastAction.getTimestamp();
        int counter = this.listActions.size() - 1;
        CsvAction ac = this.listActions.get(counter);
        while (counter >= 0) {
            ac = this.listActions.get(counter);
            if (ac == null || ac.getTimestamp() != lastTimestamp || ac.getType() != 6) break;
            this.undoActions.add(this.listActions.remove(counter));
            --counter;
        }
        this.undoRename(monitor);
    }

    private void undoRename(IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Undo column rename", this.undoActions.size());
            for (CsvAction action : this.undoActions) {
                final CsvActionColumnEdit editAction = (CsvActionColumnEdit)action;
                this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int index = editAction.getIndex();
                        CsvUndoColumnEditRunnable.this.csvEditor.getTableViewer().getTable().getColumn(index).setText(editAction.getOldText());
                    }
                });
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }
}

