/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvAction;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionColumnDelete;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.TableColumn;

public class CsvUndoColumnDeleteRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Undo column remove";
    private CSVEditor csvEditor;
    private CsvAction lastAction;
    private List<CsvAction> listActions = new ArrayList<CsvAction>();
    private List<CsvAction> undoActions = new ArrayList<CsvAction>();

    public CsvUndoColumnDeleteRunnable(CSVEditor csvEditor, CsvAction lastAction) {
        this.csvEditor = csvEditor;
        this.lastAction = lastAction;
        this.listActions = csvEditor.getListActions();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long lastTimestamp = this.lastAction.getTimestamp();
        int counter = this.listActions.size() - 1;
        CsvAction ac = this.listActions.get(counter);
        while (counter >= 0) {
            ac = this.listActions.get(counter);
            if (ac == null || ac.getTimestamp() != lastTimestamp || ac.getType() != 5) break;
            this.undoActions.add(this.listActions.remove(counter));
            --counter;
        }
        this.undoDelete2(monitor);
    }

    private void undoDelete2(IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Undo column remove", this.undoActions.size());
            for (CsvAction action : this.undoActions) {
                CsvActionColumnDelete addAction = (CsvActionColumnDelete)action;
                final String columnName = addAction.getName();
                monitor.subTask("Restoring column: " + columnName);
                this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        TableColumn[] tableColumns = CsvUndoColumnDeleteRunnable.this.csvEditor.getTable().getColumns();
                        int i = 2;
                        while (i < tableColumns.length) {
                            String cn = tableColumns[i].getText();
                            if (("!@_" + columnName).equals(cn)) {
                                tableColumns[i].setText(columnName);
                                tableColumns[i].setWidth(100);
                                tableColumns[i].setImage(CSVEditor.CHECK_DISABLED);
                            }
                            ++i;
                        }
                    }
                });
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }
}

