/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvAction;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionColumnAdd;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class CsvUndoColumnAddRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Undo column add";
    private CSVEditor csvEditor;
    private CsvAction lastAction;
    private List<CsvAction> listActions = new ArrayList<CsvAction>();
    private List<CsvAction> undoActions = new ArrayList<CsvAction>();
    private List<List<String>> model;
    private List<String> row;
    private Shell shell;

    public CsvUndoColumnAddRunnable(CSVEditor csvEditor, CsvAction lastAction) {
        this.csvEditor = csvEditor;
        this.lastAction = lastAction;
        this.listActions = csvEditor.getListActions();
        this.shell = csvEditor.getSite().getShell();
        this.model = (List)csvEditor.getModel();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long lastTimestamp = this.lastAction.getTimestamp();
        int counter = this.listActions.size() - 1;
        CsvAction ac = this.listActions.get(counter);
        while (counter >= 0) {
            ac = this.listActions.get(counter);
            if (ac == null || ac.getTimestamp() != lastTimestamp || ac.getType() != 4) break;
            this.undoActions.add(this.listActions.remove(counter));
            --counter;
        }
        this.undoAdd(monitor);
    }

    private void undoAdd(IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Undo column add", this.undoActions.size() * this.model.size());
            for (CsvAction action : this.undoActions) {
                CsvActionColumnAdd addAction = (CsvActionColumnAdd)action;
                final int addedColumnIndex = addAction.getIndex();
                monitor.subTask("Deleting column: #" + addedColumnIndex);
                this.shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TableColumn[] tableColumns = CsvUndoColumnAddRunnable.this.csvEditor.getTable().getColumns();
                        tableColumns[addedColumnIndex].dispose();
                    }
                });
                List<TableViewerColumn> listTableViewerColumns = this.csvEditor.getTableViewerColumns();
                listTableViewerColumns.remove(addedColumnIndex);
                for (List<String> row : this.model) {
                    row.remove(addedColumnIndex);
                    monitor.worked(1);
                }
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }
}

