/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.jobs.csvEditor.CsvSplitInvalidColumnCountException;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionColumnSplit;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvSplitColumnsRunnable
implements IRunnableWithProgress {
    private CSVEditor csvEditor;
    private int columnIndex;
    private char separator;
    private long timestamp;
    private int columnCount;
    private List<List<String>> model;
    private List<String> row;
    private DecimalFormat decimalFormat = new DecimalFormat("###,###");
    private String splitColumnName;
    private List<String> affectedColumnNames;

    public CsvSplitColumnsRunnable(CSVEditor csvEditor, int columnIndex, char separator, long timestamp) {
        this.csvEditor = csvEditor;
        this.columnIndex = columnIndex;
        this.separator = separator;
        this.timestamp = timestamp;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.model = (List)this.csvEditor.getModel();
        try {
            this.splitColumn(monitor);
        }
        catch (CsvSplitInvalidColumnCountException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void splitColumn(IProgressMonitor monitor) throws CsvSplitInvalidColumnCountException, InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Split columns", this.model.size());
            monitor.subTask("Verfifying separator...");
            this.affectedColumnNames = new ArrayList<String>();
            Object separator2 = null;
            separator2 = this.separator == '|' || this.separator == '.' || this.separator == '+' || this.separator == '*' ? "\\" + this.separator : Character.toString(this.separator);
            Pattern pattern = Pattern.compile((String)separator2);
            this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CsvSplitColumnsRunnable.this.splitColumnName = CsvSplitColumnsRunnable.this.csvEditor.getTable().getColumn(CsvSplitColumnsRunnable.this.columnIndex).getText();
                    CsvSplitColumnsRunnable.this.affectedColumnNames.add(CsvSplitColumnsRunnable.this.splitColumnName);
                }
            });
            this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CsvSplitColumnsRunnable.this.columnCount = CsvSplitColumnsRunnable.this.csvEditor.getColumnCount();
                }
            });
            int splitCheckIndex = this.csvEditor.splitCheckSeparator(this.columnIndex, (String)separator2);
            if (splitCheckIndex != -1) {
                throw new CsvSplitInvalidColumnCountException(splitCheckIndex + 1);
            }
            monitor.subTask("Creating new columns...");
            int countNewColumns = pattern.split(this.model.get(0).get(this.columnIndex)).length - 1;
            String[] newColumnTitles = new String[countNewColumns];
            int i = 0;
            while (i < countNewColumns) {
                newColumnTitles[i] = this.splitColumnName + "_#" + (i + 1);
                final String newColumnName = newColumnTitles[i];
                final int fi = i++;
                this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CsvSplitColumnsRunnable.this.csvEditor.createColumns(new String[]{newColumnName}, CsvSplitColumnsRunnable.this.columnIndex + fi + 1, false, false);
                            CsvSplitColumnsRunnable.this.affectedColumnNames.add(newColumnName);
                        }
                        catch (InvocationTargetException e1) {
                            e1.printStackTrace();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
            i = 0;
            while (i < this.model.size()) {
                this.row = this.model.get(i);
                String cell = this.row.get(this.columnIndex);
                if (cell != null && cell.length() > 0) {
                    String[] parts = cell.split((String)separator2);
                    int p = 0;
                    while (p < parts.length) {
                        this.row.set(this.columnIndex + p, parts[p]);
                        ++p;
                    }
                }
                this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CsvSplitColumnsRunnable.this.csvEditor.getTableViewer().update(CsvSplitColumnsRunnable.this.row, null);
                    }
                });
                ++i;
            }
            int[] listSplitCols = new int[countNewColumns + 1];
            listSplitCols[0] = this.columnIndex;
            int i2 = 0;
            while (i2 < countNewColumns) {
                listSplitCols[i2 + 1] = this.columnIndex + i2 + 1;
                ++i2;
            }
            this.csvEditor.getListActions().add(new CsvActionColumnSplit(this.affectedColumnNames, Character.toString(this.separator)));
        }
        finally {
            monitor.done();
        }
    }
}

