/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csvUtils.WorksheetUtils;
import com.biotechvana.utils.AlphanumComparator2;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvSortRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Sort";
    public static final int TYPE_ALPHANUM = 0;
    public static final int TYPE_SCIENTIFIC = 1;
    public static final int TYPE_EVALUE = 2;
    public static final int TYPE_SCORE = 3;
    public static final int TYPE_RANGE_START = 4;
    public static final int TYPE_RANGE_END = 5;
    public static final int TYPE_IDENTITIES = 6;
    public static final int TYPE_POSITIVES = 7;
    public static final int TYPE_ALIGN_LENGTH = 8;
    public static final int TYPE_SIMILARITY = 9;
    public static final int TYPE_HSP_QUERY_HIT = 10;
    public static final int MODE_ASCENDING = 1;
    public static final int MODE_DESCENDING = -1;
    private List<List<String>> model;
    private int columnIndex;
    private int sortType;
    private int sortMode;
    String p1;
    String p2;

    public CsvSortRunnable(List<List<String>> model, int columnIndex, int sortType, boolean ascending) {
        this.model = model;
        this.columnIndex = columnIndex;
        this.sortType = sortType;
        this.sortMode = ascending ? 1 : -1;
    }

    public CsvSortRunnable(List<List<String>> model, int columnIndex, int sortType, int sortMode) {
        this.model = model;
        this.columnIndex = columnIndex;
        this.sortType = sortType;
        this.sortMode = sortMode;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.sortType == 0) {
            this.sortAsAlphaNum(monitor);
        } else {
            this.sortNumericalGlobal(monitor);
        }
    }

    private void sortAsAlphaNum(IProgressMonitor monitor) {
        try {
            final AlphanumComparator2 alphanumComparator = new AlphanumComparator2();
            monitor.beginTask("Sort", -1);
            monitor.subTask("Sorting column");
            Collections.sort(this.model, new Comparator<List<String>>(){

                @Override
                public int compare(List<String> o1, List<String> o2) {
                    Collator collator = Collator.getInstance();
                    collator.setStrength(0);
                    if (o1.get(CsvSortRunnable.this.columnIndex).length() == 0 && o2.get(CsvSortRunnable.this.columnIndex).length() == 0) {
                        return 0;
                    }
                    if (o1.get(CsvSortRunnable.this.columnIndex).length() == 0) {
                        return Integer.MAX_VALUE;
                    }
                    if (o2.get(CsvSortRunnable.this.columnIndex).length() == 0) {
                        return Integer.MIN_VALUE;
                    }
                    return alphanumComparator.compare(o1.get(CsvSortRunnable.this.columnIndex), o2.get(CsvSortRunnable.this.columnIndex)) * CsvSortRunnable.this.sortMode;
                }
            });
        }
        finally {
            monitor.done();
        }
    }

    private void sortAsNumber(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Sort", -1);
            monitor.subTask("Sorting column");
            Collections.sort(this.model, new Comparator<List<String>>(){

                @Override
                public int compare(List<String> o1, List<String> o2) {
                    return (Integer.parseInt(o1.get(CsvSortRunnable.this.columnIndex)) - Integer.parseInt(o1.get(CsvSortRunnable.this.columnIndex))) * CsvSortRunnable.this.sortMode;
                }
            });
        }
        finally {
            monitor.done();
        }
    }

    private void sortNumericalGlobal(IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask("Sort", -1);
                monitor.subTask("Sorting column");
                Collections.sort(this.model, new Comparator<List<String>>(){

                    @Override
                    public int compare(List<String> o1, List<String> o2) {
                        String v1 = o1.get(CsvSortRunnable.this.columnIndex).trim();
                        String v2 = o2.get(CsvSortRunnable.this.columnIndex).trim();
                        if (CsvSortRunnable.this.sortType == 3) {
                            v1 = WorksheetUtils.parseScoreColValue((String)o1.get(CsvSortRunnable.this.columnIndex).trim());
                            v2 = WorksheetUtils.parseScoreColValue((String)o2.get(CsvSortRunnable.this.columnIndex).trim());
                        } else if (CsvSortRunnable.this.sortType == 2) {
                            v1 = WorksheetUtils.parseEvalueColValue((String)o1.get(CsvSortRunnable.this.columnIndex).trim());
                            v2 = WorksheetUtils.parseEvalueColValue((String)o2.get(CsvSortRunnable.this.columnIndex).trim());
                        } else if (CsvSortRunnable.this.sortType == 6) {
                            v1 = WorksheetUtils.parseIdentitiesColValue((String)o1.get(CsvSortRunnable.this.columnIndex).trim());
                            v2 = WorksheetUtils.parseIdentitiesColValue((String)o2.get(CsvSortRunnable.this.columnIndex).trim());
                        } else if (CsvSortRunnable.this.sortType == 7) {
                            v1 = WorksheetUtils.parsePositivesColValue((String)o1.get(CsvSortRunnable.this.columnIndex).trim());
                            v2 = WorksheetUtils.parsePositivesColValue((String)o2.get(CsvSortRunnable.this.columnIndex).trim());
                        } else if (CsvSortRunnable.this.sortType == 8) {
                            v1 = WorksheetUtils.parseAlignLengthColValue((String)o1.get(CsvSortRunnable.this.columnIndex).trim());
                            v2 = WorksheetUtils.parseAlignLengthColValue((String)o2.get(CsvSortRunnable.this.columnIndex).trim());
                        } else if (CsvSortRunnable.this.sortType == 10) {
                            v1 = WorksheetUtils.parseHspQueryColValue((String)o1.get(CsvSortRunnable.this.columnIndex).trim());
                            v2 = WorksheetUtils.parseHspQueryColValue((String)o2.get(CsvSortRunnable.this.columnIndex).trim());
                        } else if (CsvSortRunnable.this.sortType == 4) {
                            v1 = WorksheetUtils.parseHitFromColValue((String)o1.get(CsvSortRunnable.this.columnIndex).trim());
                            v2 = WorksheetUtils.parseHitFromColValue((String)o2.get(CsvSortRunnable.this.columnIndex).trim());
                        } else if (CsvSortRunnable.this.sortType == 5) {
                            v1 = WorksheetUtils.parseHitToColValue((String)o1.get(CsvSortRunnable.this.columnIndex).trim());
                            v2 = WorksheetUtils.parseHitToColValue((String)o2.get(CsvSortRunnable.this.columnIndex).trim());
                        } else if (CsvSortRunnable.this.sortType == 9) {
                            v1 = WorksheetUtils.parseSimilarityColValue((String)o1.get(CsvSortRunnable.this.columnIndex).trim());
                            v2 = WorksheetUtils.parseSimilarityColValue((String)o2.get(CsvSortRunnable.this.columnIndex).trim());
                        }
                        if (v1.equalsIgnoreCase(v2)) {
                            return 0;
                        }
                        if (v1.isEmpty() && v2.isEmpty()) {
                            return 0;
                        }
                        if (v1.isEmpty()) {
                            return 1;
                        }
                        if (v2.isEmpty()) {
                            return -1;
                        }
                        Double d1 = Double.parseDouble(v1);
                        Double d2 = Double.parseDouble(v2);
                        if (d1 < d2) {
                            return -1;
                        }
                        if (d1 > d2) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

