/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvSearchTermRunnable
implements IRunnableWithProgress {
    private DecimalFormat decimalFormat = new DecimalFormat("###,###");
    private CSVEditor csvEditor;
    private int columnIndex;
    private String term;
    private boolean exact;
    private boolean caseSensitive;
    private boolean regexp;
    private int[] matchingIndices;
    private int stepSize = 1;

    public CsvSearchTermRunnable(CSVEditor csvEditor, int columnIndex, String term, boolean exact, boolean caseSensitive, boolean regexp) {
        this.csvEditor = csvEditor;
        this.columnIndex = columnIndex;
        this.term = term;
        this.exact = exact;
        this.caseSensitive = caseSensitive;
        this.regexp = regexp;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long timeStart = System.currentTimeMillis();
        this.searchTerm(monitor);
        long timeEnd = System.currentTimeMillis();
        if (this.csvEditor.getDebug()) {
            System.out.println("Selected " + this.decimalFormat.format(this.matchingIndices.length) + " rows in " + this.decimalFormat.format(timeEnd - timeStart) + "ms");
        }
    }

    public void searchTerm(IProgressMonitor monitor) throws InterruptedException, PatternSyntaxException {
        try {
            ArrayList<Integer> matchIndices = new ArrayList<Integer>();
            List model = (List)this.csvEditor.getModel();
            if (model.size() > 100) {
                this.stepSize = model.size() / 100;
            }
            monitor.beginTask("Search", model.size());
            monitor.subTask("Reading column...");
            this.term = this.csvEditor.escapeTerm(this.term, this.exact, this.caseSensitive, this.regexp);
            int i = 0;
            while (i < model.size()) {
                List row = (List)model.get(i);
                if (((String)row.get(this.columnIndex)).matches(this.term)) {
                    matchIndices.add(new Integer(i));
                }
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
            this.matchingIndices = new int[matchIndices.size()];
            i = 0;
            while (i < matchIndices.size()) {
                this.matchingIndices[i] = (Integer)matchIndices.get(i);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public int[] getMatchingIndices() {
        return this.matchingIndices;
    }
}

