/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class CsvRowIndicesByColorRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Get row indices by color";
    private CSVEditor csvEditor;
    private List<Integer> listIndices;
    private Color[] colorList;
    private Shell shell;
    private TableItem[] tableItems;
    private DecimalFormat decimalFormat = new DecimalFormat("###,###");
    private int stepSize = 1;

    public CsvRowIndicesByColorRunnable(CSVEditor csvEditor, Color[] colorList) {
        this.csvEditor = csvEditor;
        this.colorList = colorList;
        this.shell = csvEditor.getSite().getShell();
        this.listIndices = new ArrayList<Integer>();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long timeStart = System.currentTimeMillis();
        this.getIndices(monitor);
        long timeEnd = System.currentTimeMillis();
        if (this.csvEditor.getDebug()) {
            System.out.println("Selected " + this.decimalFormat.format(this.listIndices.size()) + " rows in " + this.decimalFormat.format(timeEnd - timeStart) + "ms");
        }
    }

    private void getIndices(IProgressMonitor monitor) {
        try {
            this.shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CsvRowIndicesByColorRunnable.this.tableItems = CsvRowIndicesByColorRunnable.this.csvEditor.getTable().getItems();
                }
            });
            if (this.tableItems.length > 100) {
                this.stepSize = this.tableItems.length / 100;
            }
            monitor.beginTask("Get row indices by color", this.tableItems.length);
            int i = 0;
            while (i < this.tableItems.length) {
                final int fi = i;
                this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Color backColor = CsvRowIndicesByColorRunnable.this.tableItems[fi].getBackground();
                        Color[] colorArray = CsvRowIndicesByColorRunnable.this.colorList;
                        int n = CsvRowIndicesByColorRunnable.this.colorList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int insertionIndex;
                            Color c = colorArray[n2];
                            if (backColor.equals((Object)c) && (insertionIndex = Collections.binarySearch(CsvRowIndicesByColorRunnable.this.listIndices, fi)) < 0) {
                                CsvRowIndicesByColorRunnable.this.listIndices.add(-insertionIndex - 1, fi);
                            }
                            ++n2;
                        }
                    }
                });
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                    monitor.subTask("Reading row " + this.decimalFormat.format(i) + " of " + this.decimalFormat.format(this.tableItems.length));
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public List<Integer> getIndices() {
        return this.listIndices;
    }
}

