/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class CsvResetAnnotationColorsRunnable
implements IRunnableWithProgress {
    private DecimalFormat decimalFormat = new DecimalFormat("###,###");
    private CSVEditor csvEditor;
    private int itemCount;
    private TableItem rowItem;
    private Shell shell;
    private int stepSize = 1;

    public CsvResetAnnotationColorsRunnable(CSVEditor csvEditor) {
        this.csvEditor = csvEditor;
        this.shell = csvEditor.getSite().getShell();
        this.itemCount = csvEditor.getTable().getItemCount();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long timeStart = System.currentTimeMillis();
        this.resetAnnotationColors(monitor);
        long timeEnd = System.currentTimeMillis();
        if (this.csvEditor.getDebug()) {
            System.out.println("Reseted " + this.decimalFormat.format(this.itemCount) + " rows in " + this.decimalFormat.format(timeEnd - timeStart) + "ms");
        }
    }

    public void resetAnnotationColors(IProgressMonitor monitor) throws InterruptedException {
        try {
            if (this.itemCount > 100) {
                this.stepSize = this.itemCount / 100;
            }
            monitor.beginTask("Reset annotation colors", this.itemCount);
            int i = 0;
            while (i < this.itemCount) {
                final int fi = i;
                this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CsvResetAnnotationColorsRunnable.this.rowItem = CsvResetAnnotationColorsRunnable.this.csvEditor.getTable().getItem(fi);
                        CsvResetAnnotationColorsRunnable.this.rowItem.setBackground(null);
                    }
                });
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                    monitor.subTask("Reading row " + this.decimalFormat.format(i + 1) + " of " + this.decimalFormat.format(this.itemCount) + " total rows");
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }
}

