/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.CsvModifiedRecord;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionRowEdit;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CsvReplaceAllRunnable
implements IRunnableWithProgress {
    private CSVEditor csvEditor;
    private String regexp;
    private String replacement;
    private int column;
    private int[] rowIndices;
    private List<List<String>> model;
    private List<String> row;
    private Shell shell;
    private Display display;
    private int stepSize = 1;
    private DecimalFormat decimalFormat = new DecimalFormat("###,###");

    public CsvReplaceAllRunnable(CSVEditor csvEditor, String regexp, String replacement, int column, int[] rowIndices) {
        this.csvEditor = csvEditor;
        this.regexp = regexp;
        this.replacement = replacement;
        this.column = column;
        this.rowIndices = rowIndices;
        this.model = (List)csvEditor.getModel();
        this.shell = csvEditor.getSite().getShell();
        this.display = this.shell.getDisplay();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long timeStart = System.currentTimeMillis();
        this.replaceAll(monitor);
        long timeEnd = System.currentTimeMillis();
        if (this.csvEditor.getDebug()) {
            System.out.println(new DecimalFormat("###,###").format(this.rowIndices.length) + " rows affected in " + new DecimalFormat("###,###").format(timeEnd - timeStart) + "ms");
        }
    }

    private void replaceAll(IProgressMonitor monitor) throws PatternSyntaxException, InterruptedException {
        try {
            long timestamp = System.currentTimeMillis();
            if (this.rowIndices.length > 100) {
                this.stepSize = this.rowIndices.length / 100;
            }
            monitor.beginTask("Replace all", this.rowIndices.length);
            int i = 0;
            while (i < this.rowIndices.length) {
                this.row = this.model.get(this.rowIndices[i]);
                String cellText = this.row.get(this.column);
                this.row.set(this.column, cellText.replaceAll(this.regexp, this.replacement));
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CsvReplaceAllRunnable.this.csvEditor.getTableViewer().update(CsvReplaceAllRunnable.this.row, null);
                    }
                });
                int fastaRowIndex = -1;
                int fastaColIndex = -1;
                this.csvEditor.getListModifiedRecords().add(new CsvModifiedRecord(Integer.parseInt(this.row.get(1)) - 1, this.column, fastaRowIndex, fastaColIndex, cellText, this.row.get(this.column)));
                this.csvEditor.getListActions().add(new CsvActionRowEdit(Integer.parseInt(this.row.get(1)) - 1, this.column, cellText, this.row.get(this.column), timestamp));
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                    monitor.subTask("Parsing row " + this.decimalFormat.format(i) + " of " + this.decimalFormat.format(this.rowIndices.length));
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    CsvReplaceAllRunnable.this.csvEditor.getTable().select(CsvReplaceAllRunnable.this.rowIndices);
                }
            });
        }
        finally {
            monitor.done();
        }
    }
}

